/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import java.util.HashMap;
import java.util.Iterator;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;
import nfa.transitionlabel.EpsilonTransitionLabel;
import nfa.transitionlabel.TransitionLabel;
import nfa.transitionlabel.TransitionLabelParserRecursive;
import regexcompiler.ParseTreeToNFAConverter;
import regexcompiler.RegexCountClosureOperator;
import regexcompiler.RegexQuantifiableOperator;

public class ThompsonParseTreeToNFAConverter
extends ParseTreeToNFAConverter {
    @Override
    public NFAGraph createBaseCaseEmpty() {
        NFAGraph m = new NFAGraph();
        NFAVertexND q0 = new NFAVertexND("q0");
        NFAVertexND q1 = new NFAVertexND("q1");
        m.addVertex(q0);
        m.addVertex(q1);
        m.setInitialState(q0);
        m.addAcceptingState(q1);
        return m;
    }

    @Override
    public NFAGraph createBaseCaseLookAround(NFAVertexND lookAroundState) {
        NFAGraph m = new NFAGraph();
        NFAVertexND q0 = new NFAVertexND("q0");
        NFAVertexND q1 = new NFAVertexND("q1");
        m.addVertex(q0);
        m.addVertex(lookAroundState);
        m.addVertex(q1);
        m.addEdge(new NFAEdge(q0, lookAroundState, new EpsilonTransitionLabel("\u03b51")));
        m.addEdge(new NFAEdge(lookAroundState, q1, new EpsilonTransitionLabel("\u03b51")));
        m.setInitialState(q0);
        m.addAcceptingState(q1);
        return m;
    }

    @Override
    public NFAGraph createBaseCaseEmptyString() {
        NFAGraph m = new NFAGraph();
        NFAVertexND q0 = new NFAVertexND("q0");
        NFAVertexND q1 = new NFAVertexND("q1");
        m.addVertex(q0);
        m.addVertex(q1);
        m.addEdge(new NFAEdge(q0, q1, new EpsilonTransitionLabel("\u03b51")));
        m.setInitialState(q0);
        m.addAcceptingState(q1);
        return m;
    }

    @Override
    public NFAGraph createBaseCaseSymbol(String symbol) {
        TransitionLabelParserRecursive tlpr = new TransitionLabelParserRecursive(symbol);
        TransitionLabel transitionLabel = tlpr.parseTransitionLabel();
        NFAGraph m = new NFAGraph();
        NFAVertexND q0 = new NFAVertexND("q0");
        NFAVertexND q1 = new NFAVertexND("q1");
        m.addVertex(q0);
        m.addVertex(q1);
        if (!transitionLabel.isEmpty()) {
            m.addEdge(new NFAEdge(q0, q1, transitionLabel));
        }
        m.setInitialState(q0);
        m.addAcceptingState(q1);
        return m;
    }

    @Override
    public NFAGraph unionNFAs(NFAGraph m1, NFAGraph m2) {
        NFAVertexND target;
        NFAVertexND source;
        Iterator v2;
        NFAGraph resultNFA = new NFAGraph();
        HashMap<NFAVertexND, NFAVertexND> stateMap = new HashMap<NFAVertexND, NFAVertexND>();
        assert (m1.getAcceptingStates().size() == 1) : "Construction assumes only one accept state";
        NFAVertexND m1AcceptState = m1.getAcceptingStates().iterator().next();
        for (Iterator v2 : m1.vertexSet()) {
            resultNFA.addVertex((NFAVertexND)((Object)v2));
        }
        assert (m2.getAcceptingStates().size() == 1) : "Construction assumes only one accept state";
        int i = 0;
        v2 = m2.vertexSet().iterator();
        while (v2.hasNext()) {
            NFAVertexND v3;
            NFAVertexND newVertex = v3 = (NFAVertexND)v2.next();
            String newName = "" + v3.getStateNumberByDimension(1).charAt(0);
            while (resultNFA.containsVertex(newVertex)) {
                newVertex = new NFAVertexND(newName + i);
                ++i;
            }
            resultNFA.addVertex(newVertex);
            stateMap.put(v3, newVertex);
        }
        for (NFAEdge e : m1.edgeSet()) {
            source = e.getSourceVertex();
            target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        for (NFAEdge e : m2.edgeSet()) {
            source = (NFAVertexND)stateMap.get(e.getSourceVertex());
            target = (NFAVertexND)stateMap.get(e.getTargetVertex());
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        NFAVertexND newInitialVertex = new NFAVertexND("q0");
        while (resultNFA.containsVertex(newInitialVertex)) {
            newInitialVertex = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newInitialVertex);
        resultNFA.setInitialState(newInitialVertex);
        NFAVertexND m1InitialState = m1.getInitialState();
        NFAVertexND m2InitialState = (NFAVertexND)stateMap.get(m2.getInitialState());
        resultNFA.addEdge(new NFAEdge(newInitialVertex, m1InitialState, new EpsilonTransitionLabel("\u03b51")));
        resultNFA.addEdge(new NFAEdge(newInitialVertex, m2InitialState, new EpsilonTransitionLabel("\u03b52")));
        NFAVertexND newAcceptVertex = new NFAVertexND("q" + resultNFA.vertexSet().size());
        while (resultNFA.containsVertex(newAcceptVertex)) {
            newInitialVertex = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newAcceptVertex);
        resultNFA.addAcceptingState(newAcceptVertex);
        NFAVertexND m2AcceptState = (NFAVertexND)stateMap.get(m2.getAcceptingStates().iterator().next());
        resultNFA.addEdge(new NFAEdge(m1AcceptState, newAcceptVertex, new EpsilonTransitionLabel("\u03b51")));
        resultNFA.addEdge(new NFAEdge(m2AcceptState, newAcceptVertex, new EpsilonTransitionLabel("\u03b51")));
        return resultNFA;
    }

    @Override
    public NFAGraph joinNFAs(NFAGraph m1, NFAGraph m2) {
        NFAVertexND target;
        NFAVertexND source;
        NFAGraph resultNFA = new NFAGraph();
        HashMap<NFAVertexND, NFAVertexND> stateMap = new HashMap<NFAVertexND, NFAVertexND>();
        for (NFAVertexND v : m1.vertexSet()) {
            resultNFA.addVertex(v);
        }
        NFAVertexND m2InitialState = null;
        int i = 0;
        Iterator<Object> iterator = m2.vertexSet().iterator();
        while (iterator.hasNext()) {
            NFAVertexND v;
            NFAVertexND newVertex = v = (NFAVertexND)iterator.next();
            String newName = "" + v.getStateNumberByDimension(1).charAt(0);
            while (resultNFA.containsVertex(newVertex) || newVertex.equals(m2InitialState)) {
                newVertex = new NFAVertexND(newName + i);
                ++i;
            }
            resultNFA.addVertex(newVertex);
            if (m2.getInitialState().equals(v)) {
                m2InitialState = newVertex;
            }
            stateMap.put(v, newVertex);
        }
        for (NFAEdge e : m1.edgeSet()) {
            source = e.getSourceVertex();
            target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        for (NFAEdge e : m2.edgeSet()) {
            source = (NFAVertexND)stateMap.get(e.getSourceVertex());
            target = (NFAVertexND)stateMap.get(e.getTargetVertex());
            NFAEdge newEdge = new NFAEdge(source, target, e.getTransitionLabel());
            resultNFA.addEdge(newEdge);
        }
        for (NFAVertexND m1AcceptingState : m1.getAcceptingStates()) {
            NFAEdge newEdge = new NFAEdge(m1AcceptingState, m2InitialState, new EpsilonTransitionLabel("\u03b51"));
            resultNFA.addEdge(newEdge);
        }
        NFAVertexND oldInitialVertex = m1.getInitialState();
        resultNFA.setInitialState(oldInitialVertex);
        for (NFAVertexND v : m2.getAcceptingStates()) {
            v = (NFAVertexND)stateMap.get(v);
            resultNFA.addAcceptingState(v);
        }
        return resultNFA;
    }

    @Override
    public NFAGraph starNFA(NFAGraph m, RegexQuantifiableOperator.RegexStarOperator starOperator) {
        EpsilonTransitionLabel finishTransitionLabel;
        EpsilonTransitionLabel eatMoreTransitionLabel;
        RegexQuantifiableOperator.QuantifierType quantifierType = starOperator.getQuantifierType();
        switch (quantifierType) {
            case GREEDY: {
                eatMoreTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                break;
            }
            case RELUCTANT: {
                eatMoreTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                break;
            }
            case POSSESSIVE: {
                throw new UnsupportedOperationException("Possessive quantifiers not implemented.");
            }
            default: {
                throw new RuntimeException("Unknown quantifier: " + (Object)((Object)quantifierType));
            }
        }
        NFAGraph resultNFA = new NFAGraph();
        for (NFAVertexND v : m.vertexSet()) {
            resultNFA.addVertex(v);
        }
        for (NFAEdge e : m.edgeSet()) {
            NFAVertexND source = e.getSourceVertex();
            NFAVertexND target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        NFAVertexND oldInitialState = m.getInitialState();
        NFAVertexND oldAcceptState = m.getAcceptingStates().iterator().next();
        int i = 0;
        NFAVertexND newInitialState = new NFAVertexND("q0");
        while (resultNFA.containsVertex(newInitialState)) {
            newInitialState = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newInitialState);
        resultNFA.setInitialState(newInitialState);
        i = 0;
        NFAVertexND newAcceptState = new NFAVertexND("q" + resultNFA.vertexSet().size());
        while (resultNFA.containsVertex(newAcceptState)) {
            newAcceptState = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newAcceptState);
        resultNFA.addAcceptingState(newAcceptState);
        NFAEdge eatMoreEdge1 = new NFAEdge(newInitialState, oldInitialState, eatMoreTransitionLabel);
        resultNFA.addEdge(eatMoreEdge1);
        NFAEdge finishEdge1 = new NFAEdge(newInitialState, newAcceptState, finishTransitionLabel);
        resultNFA.addEdge(finishEdge1);
        NFAEdge eatMoreEdge2 = new NFAEdge(oldAcceptState, oldInitialState, eatMoreTransitionLabel);
        resultNFA.addEdge(eatMoreEdge2);
        NFAEdge finishEdge2 = new NFAEdge(oldAcceptState, newAcceptState, finishTransitionLabel);
        resultNFA.addEdge(finishEdge2);
        return resultNFA;
    }

    @Override
    public NFAGraph plusNFA(NFAGraph m, RegexQuantifiableOperator.RegexPlusOperator plusOperator) {
        EpsilonTransitionLabel finishTransitionLabel;
        EpsilonTransitionLabel eatMoreTransitionLabel;
        RegexQuantifiableOperator.QuantifierType quantifierType = plusOperator.getQuantifierType();
        switch (quantifierType) {
            case GREEDY: {
                eatMoreTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                break;
            }
            case RELUCTANT: {
                eatMoreTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                break;
            }
            case POSSESSIVE: {
                throw new UnsupportedOperationException("Possessive quantifiers not implemented.");
            }
            default: {
                throw new RuntimeException("Unknown quantifier: " + (Object)((Object)quantifierType));
            }
        }
        NFAGraph resultNFA = new NFAGraph();
        for (NFAVertexND v : m.vertexSet()) {
            resultNFA.addVertex(v);
        }
        for (NFAEdge e : m.edgeSet()) {
            NFAVertexND source = e.getSourceVertex();
            NFAVertexND target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        NFAVertexND oldInitialState = m.getInitialState();
        NFAVertexND oldAcceptState = m.getAcceptingStates().iterator().next();
        int i = 0;
        NFAVertexND newInitialState = new NFAVertexND("q0");
        while (resultNFA.containsVertex(newInitialState)) {
            newInitialState = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newInitialState);
        resultNFA.setInitialState(newInitialState);
        i = 0;
        NFAVertexND newAcceptState = new NFAVertexND("q" + resultNFA.vertexSet().size());
        while (resultNFA.containsVertex(newAcceptState)) {
            newAcceptState = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newAcceptState);
        resultNFA.addAcceptingState(newAcceptState);
        NFAEdge eatMoreEdge1 = new NFAEdge(newInitialState, oldInitialState, eatMoreTransitionLabel);
        resultNFA.addEdge(eatMoreEdge1);
        NFAEdge eatMoreEdge2 = new NFAEdge(oldAcceptState, oldInitialState, eatMoreTransitionLabel);
        resultNFA.addEdge(eatMoreEdge2);
        NFAEdge finishEdge2 = new NFAEdge(oldAcceptState, newAcceptState, finishTransitionLabel);
        resultNFA.addEdge(finishEdge2);
        return resultNFA;
    }

    @Override
    public NFAGraph countClosureNFA(NFAGraph m, RegexCountClosureOperator countClosureOperator) {
        int numRepetitions;
        EpsilonTransitionLabel finishTransitionLabel;
        EpsilonTransitionLabel continueTransitionLabel;
        RegexQuantifiableOperator.QuantifierType quantifierType = countClosureOperator.getQuantifierType();
        int cmin = countClosureOperator.getLow();
        int cmax = countClosureOperator.getHigh();
        boolean bounded = cmax < Integer.MAX_VALUE;
        switch (quantifierType) {
            case GREEDY: {
                continueTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                break;
            }
            case RELUCTANT: {
                continueTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                break;
            }
            case POSSESSIVE: {
                throw new UnsupportedOperationException("Possessive quantifiers not implemented.");
            }
            default: {
                throw new RuntimeException("Unknown quantifier: " + (Object)((Object)quantifierType));
            }
        }
        NFAGraph resultNFA = new NFAGraph();
        NFAVertexND newInitialVertex = this.deriveVertex(resultNFA, new NFAVertexND("q0"));
        resultNFA.addVertex(newInitialVertex);
        resultNFA.setInitialState(newInitialVertex);
        NFAVertexND newAcceptVertex = this.deriveVertex(resultNFA, new NFAVertexND("q" + resultNFA.vertexSet().size()));
        resultNFA.addVertex(newAcceptVertex);
        resultNFA.addAcceptingState(newAcceptVertex);
        if (cmin == 0) {
            NFAEdge newEdge;
            if (cmax > 0) {
                newEdge = new NFAEdge(newInitialVertex, newAcceptVertex, finishTransitionLabel);
                resultNFA.addEdge(newEdge);
            } else {
                newEdge = new NFAEdge(newInitialVertex, newAcceptVertex, new EpsilonTransitionLabel("\u03b51"));
                resultNFA.addEdge(newEdge);
            }
        }
        int n = numRepetitions = bounded ? cmax : cmin;
        if (!bounded && cmin == 0) {
            numRepetitions = 1;
        }
        NFAVertexND lastConnectingVertex = newInitialVertex;
        for (int i = 1; i <= numRepetitions; ++i) {
            NFAVertexND repetitionInitialVertex = null;
            NFAVertexND repetitionAcceptVertex = null;
            HashMap<NFAVertexND, NFAVertexND> stateMap = new HashMap<NFAVertexND, NFAVertexND>();
            for (NFAVertexND originalVertex : m.vertexSet()) {
                NFAVertexND newVertex = this.deriveVertex(resultNFA, originalVertex);
                stateMap.put(originalVertex, newVertex);
                resultNFA.addVertex(newVertex);
                if (m.getInitialState().equals(originalVertex)) {
                    repetitionInitialVertex = newVertex;
                }
                if (!m.isAcceptingState(originalVertex)) continue;
                repetitionAcceptVertex = newVertex;
            }
            assert (repetitionInitialVertex != null && repetitionAcceptVertex != null) : "NFA must have an initial and accept state.";
            for (NFAEdge e : m.edgeSet()) {
                NFAVertexND source = (NFAVertexND)stateMap.get(e.getSourceVertex());
                NFAVertexND target = (NFAVertexND)stateMap.get(e.getTargetVertex());
                NFAEdge newEdge = new NFAEdge(source, target, e.getTransitionLabel());
                resultNFA.addEdge(newEdge);
            }
            NFAEdge newEdge = new NFAEdge(lastConnectingVertex, repetitionInitialVertex, continueTransitionLabel);
            resultNFA.addEdge(newEdge);
            if (i >= cmin) {
                if (!bounded) {
                    newEdge = new NFAEdge(repetitionAcceptVertex, lastConnectingVertex, continueTransitionLabel);
                    resultNFA.addEdge(newEdge);
                }
                if ((bounded || cmin != 0) && i == numRepetitions) {
                    newEdge = new NFAEdge(repetitionAcceptVertex, newAcceptVertex, new EpsilonTransitionLabel("\u03b51"));
                    resultNFA.addEdge(newEdge);
                } else if (i < numRepetitions) {
                    newEdge = new NFAEdge(repetitionAcceptVertex, newAcceptVertex, finishTransitionLabel);
                    resultNFA.addEdge(newEdge);
                }
            }
            lastConnectingVertex = repetitionAcceptVertex;
        }
        return resultNFA;
    }

    @Override
    public NFAGraph questionMarkNFA(NFAGraph m, RegexQuantifiableOperator.RegexQuestionMarkOperator questionMarkOperator) {
        EpsilonTransitionLabel finishTransitionLabel;
        EpsilonTransitionLabel eatMoreTransitionLabel;
        RegexQuantifiableOperator.QuantifierType quantifierType = questionMarkOperator.getQuantifierType();
        switch (quantifierType) {
            case GREEDY: {
                eatMoreTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                break;
            }
            case RELUCTANT: {
                eatMoreTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                break;
            }
            case POSSESSIVE: {
                throw new UnsupportedOperationException("Possessive quantifiers not implemented.");
            }
            default: {
                throw new RuntimeException("Unknown quantifier: " + (Object)((Object)quantifierType));
            }
        }
        NFAGraph resultNFA = new NFAGraph();
        for (NFAVertexND v : m.vertexSet()) {
            resultNFA.addVertex(v);
        }
        for (NFAEdge e : m.edgeSet()) {
            NFAVertexND source = e.getSourceVertex();
            NFAVertexND target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        NFAVertexND oldInitialState = m.getInitialState();
        NFAVertexND oldAcceptState = m.getAcceptingStates().iterator().next();
        int i = 0;
        NFAVertexND newInitialState = new NFAVertexND("q0");
        while (resultNFA.containsVertex(newInitialState)) {
            newInitialState = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newInitialState);
        resultNFA.setInitialState(newInitialState);
        i = 0;
        NFAVertexND newAcceptState = new NFAVertexND("q" + resultNFA.vertexSet().size());
        while (resultNFA.containsVertex(newAcceptState)) {
            newAcceptState = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newAcceptState);
        resultNFA.addAcceptingState(newAcceptState);
        NFAEdge eatMoreEdge1 = new NFAEdge(newInitialState, oldInitialState, eatMoreTransitionLabel);
        resultNFA.addEdge(eatMoreEdge1);
        NFAEdge finishEdge1 = new NFAEdge(newInitialState, newAcceptState, finishTransitionLabel);
        resultNFA.addEdge(finishEdge1);
        NFAEdge finishEdge2 = new NFAEdge(oldAcceptState, newAcceptState, finishTransitionLabel);
        resultNFA.addEdge(finishEdge2);
        return resultNFA;
    }
}

