/*
 * Decompiled with CFR 0.152.
 */
package analysis;

public class ExploitString {
    private static final int VERBATIM_CHAR_MIN = 33;
    private static final int VERBATIM_CHAR_MAX = 126;
    private final int degree;
    private final String[] separators;
    private final String[] pumps;
    private final String suffix;

    public int getDegree() {
        return this.degree;
    }

    public String getSeparatorByDegreeVisual(int degree) {
        return ExploitString.visualiseString(this.separators[degree]);
    }

    public final String[] getSeparators() {
        String[] separators = new String[this.degree];
        for (int i = 0; i < this.degree; ++i) {
            separators[i] = this.separators[i];
        }
        return separators;
    }

    public String getPrefixVisual() {
        return ExploitString.visualiseString(this.separators[0]);
    }

    public String getPrefix() {
        return this.separators[0];
    }

    public String getSeparatorByDegree(int degree) {
        return this.separators[degree];
    }

    public String getPumpByDegreeVisual(int degree) {
        return ExploitString.visualiseString(this.pumps[degree]);
    }

    public final String[] getPumps() {
        String[] pumps = new String[this.degree];
        for (int i = 0; i < this.degree; ++i) {
            pumps[i] = this.pumps[i];
        }
        return pumps;
    }

    public String getPumpByDegree(int degree) {
        return this.pumps[degree];
    }

    public String getSuffixVisual() {
        return ExploitString.visualiseString(this.suffix);
    }

    public String getSuffix() {
        return this.suffix;
    }

    public ExploitString(String prefix, String pump, String suffix) {
        this.degree = 0;
        this.separators = new String[1];
        this.separators[0] = prefix;
        this.pumps = new String[1];
        this.pumps[0] = pump;
        this.suffix = suffix;
    }

    public ExploitString(String[] separators, String[] pumps, String suffix) {
        this.degree = pumps.length;
        if (separators.length != pumps.length) {
            throw new IllegalArgumentException("There must be the same number of separators as pumps");
        }
        this.pumps = new String[this.degree];
        this.separators = new String[this.degree];
        for (int i = 0; i < this.degree; ++i) {
            if (separators[i] == null) {
                throw new IllegalArgumentException("Null separators not allowed.");
            }
            if (pumps[i] == null) {
                throw new IllegalArgumentException("Null pumps not allowed.");
            }
            this.pumps[i] = pumps[i];
            this.separators[i] = separators[i];
        }
        this.suffix = suffix;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.degree <= 0) {
            sb.append(ExploitString.visualiseString(this.separators[0]));
            sb.append(ExploitString.visualiseString(this.pumps[0]));
            sb.append("...");
            sb.append(ExploitString.visualiseString(this.pumps[0]));
        } else {
            for (int i = 0; i < this.degree; ++i) {
                sb.append(ExploitString.visualiseString(this.separators[i]));
                sb.append(ExploitString.visualiseString(this.pumps[i]));
                sb.append("...");
                sb.append(ExploitString.visualiseString(this.pumps[i]));
            }
        }
        String visibleSuffix = ExploitString.visualiseString(this.suffix);
        sb.append(visibleSuffix);
        return sb.toString();
    }

    public static String visualiseString(String s) {
        StringBuilder sb = new StringBuilder();
        char[] sArr = s.toCharArray();
        for (int i = 0; i < sArr.length; ++i) {
            char c = sArr[i];
            if (c >= '!' && c <= '~') {
                sb.append(sArr[i]);
                continue;
            }
            if (c < '\u0100') {
                sb.append(String.format("\\x%02x", c));
                continue;
            }
            sb.append(String.format("\\x{%02x}", c));
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        ExploitString es = (ExploitString)o;
        boolean testDegree = this.degree == es.degree;
        boolean testPumps = false;
        boolean testSeparators = false;
        if (this.pumps == null) {
            testPumps = es.pumps == null;
        } else {
            if (!testDegree) {
                return false;
            }
            for (int i = 0; i < this.degree; ++i) {
                if (!this.separators[i].equals(es.separators[i])) {
                    testSeparators = false;
                    break;
                }
                if (this.pumps[i].equals(es.pumps[i])) continue;
                testPumps = false;
                break;
            }
        }
        boolean testSuffix = false;
        testSuffix = this.suffix == null ? es.suffix == null : this.suffix.equals(es.suffix);
        boolean condition = testDegree && testPumps && testSeparators && testSuffix;
        return condition;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }
}

