/*
 * Decompiled with CFR 0.152.
 */
package analysis;

import analysis.EdaAnalysisResults;
import analysis.ExploitString;
import analysis.ExploitStringBuilderInterface;
import analysis.IdaAnalysisResults;
import analysis.NFAAnalyser;
import analysis.NFAAnalyserInterface;
import analysis.NFAAnalysisTools;
import analysis.NoExploitStringException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;
import nfa.transitionlabel.CharacterClassTransitionLabel;
import nfa.transitionlabel.TransitionLabel;

public class ExploitStringBuilder
implements ExploitStringBuilderInterface<EdaAnalysisResults, IdaAnalysisResults> {
    @Override
    public ExploitString buildEdaExploitString(EdaAnalysisResults results) {
        switch (results.edaCase) {
            case PARALLEL: {
                return ExploitStringBuilder.getParallelExploitString((NFAAnalyserInterface.EdaAnalysisResultsParallel)results);
            }
            case ESCC: {
                return ExploitStringBuilder.getEsccExploitString((NFAAnalyserInterface.EdaAnalysisResultsESCC)results);
            }
            case FILTER: {
                return ExploitStringBuilder.getFilterExploitString((NFAAnalyserInterface.EdaAnalysisResultsFilter)results);
            }
            case NO_EDA: {
                throw new NoExploitStringException("The graph does not have EDA.");
            }
        }
        throw new RuntimeException("Invalid case for EDA");
    }

    @Override
    public ExploitString buildIdaExploitString(IdaAnalysisResults results) {
        switch (results.idaCase) {
            case IDA: {
                return ExploitStringBuilder.getIdaExploitString((NFAAnalyserInterface.IdaAnalysisResultsIda)results);
            }
            case NO_IDA: {
                throw new NoExploitStringException("The graph does not have EDA.");
            }
        }
        return null;
    }

    public static ExploitString getParallelExploitString(NFAAnalyserInterface.EdaAnalysisResultsParallel parallelResults) {
        NFAGraph originalGraph = parallelResults.getOriginalGraph();
        NFAVertexND sourceVertex = parallelResults.getSourceVertex();
        NFAGraph mergedScc = parallelResults.getMergedScc();
        NFAEdge parallelEdge = parallelResults.getParallelEdge();
        String prefixString = ExploitStringBuilder.buildPrefixString(originalGraph, sourceVertex);
        NFAEdge incomingEdge = (NFAEdge)mergedScc.incomingEdgesOf(sourceVertex).iterator().next();
        String pumpString = ExploitStringBuilder.buildPumpMultiPath(mergedScc, incomingEdge, parallelEdge);
        String suffixString = ExploitStringBuilder.buildSuffixString(originalGraph, parallelEdge.getTargetVertex());
        return new ExploitString(prefixString, pumpString, suffixString);
    }

    public static ExploitString getEsccExploitString(NFAAnalyserInterface.EdaAnalysisResultsESCC esccResults) {
        NFAGraph originalGraph = esccResults.getOriginalGraph();
        NFAGraph originalScc = esccResults.getOriginalScc();
        NFAEdge entranceEdge = esccResults.getEntranceEdge();
        NFAEdge exitEdge = esccResults.getExitEdge();
        NFAVertexND startVertex = entranceEdge.getTargetVertex();
        String prefixString = ExploitStringBuilder.buildPrefixString(originalGraph, startVertex);
        String pumpString = ExploitStringBuilder.buildPumpMultiPath(originalScc, entranceEdge, exitEdge);
        String suffixString = ExploitStringBuilder.buildSuffixString(originalGraph, exitEdge.getTargetVertex());
        return new ExploitString(prefixString, pumpString, suffixString);
    }

    public static ExploitString getFilterExploitString(NFAAnalyserInterface.EdaAnalysisResultsFilter filterResults) {
        NFAGraph originalGraph = filterResults.getOriginalGraph();
        NFAVertexND endState = filterResults.getEndState();
        NFAVertexND startState = filterResults.getStartState();
        NFAGraph pcScc = filterResults.getPcScc();
        String prefixString = ExploitStringBuilder.buildPrefixString(originalGraph, startState.getStateByDimension(1));
        String pumpString = ExploitStringBuilder.buildPumpIntersect(pcScc, startState, endState);
        String suffixString = ExploitStringBuilder.buildSuffixString(originalGraph, startState.getStateByDimension(1));
        return new ExploitString(prefixString, pumpString, suffixString);
    }

    public static String buildPrefixString(NFAGraph m, NFAVertexND finish) {
        LinkedList<NFAEdge> edges = NFAAnalysisTools.shortestPathTo(m, finish);
        return ExploitStringBuilder.buildStringFromEdges(edges);
    }

    public static String buildSuffixString(NFAGraph n, NFAVertexND start) {
        Iterator<Object> i0;
        HashSet regexAlphabet = (HashSet)NFAAnalysisTools.getAlphabet(n);
        NFAGraph nAccent = n;
        NFAGraph dfa = NFAAnalysisTools.determinize(nAccent, n.vertexSet(), regexAlphabet);
        for (NFAVertexND currentState : dfa.vertexSet()) {
            if (dfa.isAcceptingState(currentState)) {
                dfa.removeAcceptingState(currentState);
                continue;
            }
            dfa.addAcceptingState(currentState);
        }
        if (dfa.getAcceptingStates().isEmpty()) {
            i0 = regexAlphabet.iterator();
            TransitionLabel wholeAlphabet = (TransitionLabel)i0.next();
            while (i0.hasNext()) {
                wholeAlphabet = wholeAlphabet.union((TransitionLabel)i0.next());
            }
            if (!wholeAlphabet.matches("#")) {
                return "#";
            }
            HashSet<TransitionLabel> unicode16Alphabet = new HashSet<TransitionLabel>();
            for (int i = 0; i < 65536; ++i) {
                char currentChar = (char)i;
                Object currentString = "" + currentChar;
                if (currentChar == '[') {
                    currentString = "\\" + currentChar;
                } else if (currentChar == '\u03b5') {
                    currentString = "[\u03b5]";
                }
                if (wholeAlphabet.matches((String)currentString)) continue;
                return "" + (char)i;
            }
            unicode16Alphabet.add(CharacterClassTransitionLabel.wildcardLabel());
            HashSet<NFAVertexND> startStates = NFAAnalysisTools.reachableWithEpsilon(nAccent, start);
            NFAGraph dfa2 = NFAAnalysisTools.determinize(nAccent, startStates, unicode16Alphabet);
            for (NFAVertexND currentState : dfa2.vertexSet()) {
                if (dfa2.isAcceptingState(currentState)) {
                    dfa2.removeAcceptingState(currentState);
                    continue;
                }
                dfa2.addAcceptingState(currentState);
            }
            if (!dfa2.getAcceptingStates().isEmpty()) {
                for (NFAVertexND finalState : dfa2.getAcceptingStates()) {
                    LinkedList<NFAEdge> pathToFinal = NFAAnalysisTools.shortestPathTo(dfa2, finalState);
                    if (pathToFinal.isEmpty()) continue;
                    return ExploitStringBuilder.buildStringFromEdges(pathToFinal);
                }
                throw new RuntimeException("Cannot build suffix! (Only \u03b5 suffixes.)");
            }
            throw new RuntimeException("Cannot build suffix!");
        }
        i0 = dfa.getAcceptingStates().iterator();
        NFAVertexND finalState = (NFAVertexND)i0.next();
        LinkedList<NFAEdge> pathToFinal = NFAAnalysisTools.shortestPathTo(dfa, finalState);
        return ExploitStringBuilder.buildStringFromEdges(pathToFinal);
    }

    public static String buildStringFromEdges(LinkedList<NFAEdge> edges) {
        if (edges == null) {
            return null;
        }
        StringBuilder toReturn = new StringBuilder();
        for (NFAEdge e : edges) {
            if (e.getIsEpsilonTransition()) continue;
            toReturn.append(e.getATransitionCharacter());
        }
        return toReturn.toString();
    }

    private static String buildPumpMultiPath(NFAGraph scc, NFAEdge entranceEdge, NFAEdge exitEdge) {
        LinkedList pathsToP = new LinkedList();
        LinkedList<NFAEdge> queue = new LinkedList<NFAEdge>();
        HashMap paths = new HashMap();
        HashSet<NFAEdge> visitedEdges = new HashSet<NFAEdge>();
        queue.add(exitEdge);
        LinkedList<NFAEdge> newPath = new LinkedList<NFAEdge>();
        newPath.add(exitEdge);
        paths.put(exitEdge, newPath);
        visitedEdges.add(exitEdge);
        while (!queue.isEmpty()) {
            NFAEdge currentEdge = (NFAEdge)queue.removeLast();
            LinkedList currentPath = (LinkedList)paths.get(currentEdge);
            if (entranceEdge.equals(currentEdge)) {
                newPath = new LinkedList(currentPath);
                newPath.add(currentEdge);
                pathsToP.add(newPath);
                break;
            }
            NFAVertexND targetVertex = currentEdge.getTargetVertex();
            for (NFAEdge e : scc.outgoingEdgesOf(targetVertex)) {
                if (visitedEdges.contains(e)) continue;
                visitedEdges.add(e);
                newPath = new LinkedList(currentPath);
                newPath.add(e);
                paths.put(e, newPath);
                queue.addFirst(e);
            }
        }
        String toReturn = ExploitStringBuilder.buildStringFromEdges((LinkedList)pathsToP.get(0));
        return toReturn;
    }

    public static String buildPumpIntersect(NFAGraph pcscc, NFAVertexND p, NFAVertexND q) {
        LinkedList<NFAEdge> pathToQ = ExploitStringBuilder.buildExploitStringSCCPathTo(pcscc, p, q);
        String s1 = ExploitStringBuilder.buildStringFromEdges(pathToQ);
        StringBuilder toReturn = new StringBuilder(s1);
        LinkedList<NFAEdge> pathToP = ExploitStringBuilder.buildExploitStringSCCPathTo(pcscc, q, p);
        String s2 = ExploitStringBuilder.buildStringFromEdges(pathToP);
        toReturn.append(s2);
        return toReturn.toString();
    }

    private static LinkedList<NFAEdge> buildExploitStringSCCPathTo(NFAGraph scc, NFAVertexND p, NFAVertexND q) {
        LinkedList<NFAVertexND> queue = new LinkedList<NFAVertexND>();
        HashMap<NFAVertexND, LinkedList<NFAEdge>> paths = new HashMap<NFAVertexND, LinkedList<NFAEdge>>();
        HashSet<NFAEdge> visitedEdges = new HashSet<NFAEdge>();
        for (NFAEdge e : scc.outgoingEdgesOf(p)) {
            NFAVertexND target = e.getTargetVertex();
            queue.addFirst(target);
            visitedEdges.add(e);
            LinkedList<NFAEdge> newPath = new LinkedList<NFAEdge>();
            newPath.add(e);
            paths.put(target, newPath);
            if (!target.equals(q)) continue;
            return newPath;
        }
        while (!queue.isEmpty()) {
            NFAVertexND current = (NFAVertexND)queue.removeLast();
            LinkedList currentPath = (LinkedList)paths.get(current);
            for (NFAEdge e : scc.outgoingEdgesOf(current)) {
                if (visitedEdges.contains(e)) continue;
                visitedEdges.add(e);
                NFAVertexND target = e.getTargetVertex();
                LinkedList<NFAEdge> newPath = new LinkedList<NFAEdge>(currentPath);
                newPath.add(e);
                paths.put(target, newPath);
                queue.addFirst(target);
                if (!target.equals(q)) continue;
                return newPath;
            }
        }
        return null;
    }

    private static ExploitString getIdaExploitString(NFAAnalyserInterface.IdaAnalysisResultsIda idaResults) {
        NFAGraph originalGraph = idaResults.originalGraph;
        int degree = idaResults.getDegree();
        String[] pumps = new String[degree];
        String[] separators = new String[degree];
        int degreeCounter = 0;
        LinkedList<NFAEdge> maxPath = idaResults.getMaxPath();
        Iterator i0 = maxPath.iterator();
        while (i0.hasNext()) {
            TransitionLabel currentTransitionLabel = ((NFAEdge)i0.next()).getTransitionLabel();
            StringBuilder separatorBuilder = new StringBuilder("");
            while (!(currentTransitionLabel instanceof NFAAnalyser.IdaSpecialTransitionLabel)) {
                if (currentTransitionLabel.getTransitionType() != TransitionLabel.TransitionType.EPSILON) {
                    separatorBuilder.append(currentTransitionLabel.getSymbol());
                }
                if (!i0.hasNext()) break;
                currentTransitionLabel = ((NFAEdge)i0.next()).getTransitionLabel();
            }
            if (!i0.hasNext()) continue;
            separators[degreeCounter] = separatorBuilder.toString();
            StringBuilder pumpBuilder = new StringBuilder();
            NFAAnalyser.IdaSpecialTransitionLabel currentIdaSpecialTransitionLabel = (NFAAnalyser.IdaSpecialTransitionLabel)currentTransitionLabel;
            for (TransitionLabel transitionLabelInSpecialTransitionLabel : currentIdaSpecialTransitionLabel.getTransitionLabels()) {
                if (transitionLabelInSpecialTransitionLabel.getTransitionType() == TransitionLabel.TransitionType.EPSILON) continue;
                pumpBuilder.append(transitionLabelInSpecialTransitionLabel.getSymbol());
            }
            pumps[degreeCounter] = pumpBuilder.toString();
            ++degreeCounter;
        }
        NFAVertexND suffixStartVertex = maxPath.get(maxPath.size() - 1).getTargetVertex();
        String suffix = ExploitStringBuilder.buildSuffixString(originalGraph, suffixStartVertex);
        ExploitString es = new ExploitString(separators, pumps, suffix);
        return es;
    }
}

