/*
 * Decompiled with CFR 0.152.
 */
package nfa;

import java.util.regex.Pattern;
import nfa.NFAVertexND;
import nfa.transitionlabel.CharacterClassTransitionLabel;
import nfa.transitionlabel.EmptyTransitionLabelException;
import nfa.transitionlabel.EpsilonTransitionLabel;
import nfa.transitionlabel.TransitionLabel;
import nfa.transitionlabel.TransitionLabelParserRecursive;
import org.jgrapht.graph.DefaultEdge;

public class NFAEdge
extends DefaultEdge
implements Comparable<NFAEdge> {
    private static final long serialVersionUID = 1L;
    private final NFAVertexND sourceVertex;
    private final NFAVertexND targetVertex;
    private int numParallel;
    private TransitionLabel transitionLabel;
    private final boolean isEpsilonTransition;
    private static Pattern isEpsilonCharacterRegex = Pattern.compile("\u03b5\\d*");

    public NFAVertexND getSourceVertex() {
        return this.sourceVertex;
    }

    public NFAVertexND getTargetVertex() {
        return this.targetVertex;
    }

    public int getNumParallel() {
        return this.numParallel;
    }

    public void setNumParallel(int numParallel) {
        this.numParallel = numParallel;
    }

    public void incNumParallel() {
        ++this.numParallel;
    }

    public TransitionLabel getTransitionLabel() {
        return this.transitionLabel;
    }

    public String getATransitionCharacter() {
        return this.transitionLabel.getSymbol();
    }

    public void setTransitionLabel(String transitionLabelString) {
        TransitionLabelParserRecursive tlp = new TransitionLabelParserRecursive(transitionLabelString);
        this.transitionLabel = tlp.parseTransitionLabel();
    }

    public void setTransitionLabel(TransitionLabel transitionLabel) {
        this.transitionLabel = transitionLabel;
    }

    public boolean getIsEpsilonTransition() {
        return this.isEpsilonTransition;
    }

    public TransitionLabel.TransitionType getTransitionType() {
        return this.transitionLabel.getTransitionType();
    }

    public NFAEdge(NFAVertexND sourceVertex, NFAVertexND targetVertex, String transitionLabelString) throws EmptyTransitionLabelException {
        if (sourceVertex == null || targetVertex == null || transitionLabelString == null) {
            throw new NullPointerException("Null parameters are not allowed.");
        }
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        TransitionLabelParserRecursive tlpr = new TransitionLabelParserRecursive(transitionLabelString);
        this.transitionLabel = tlpr.parseTransitionLabel();
        if (this.transitionLabel.isEmpty()) {
            throw new EmptyTransitionLabelException(transitionLabelString);
        }
        this.numParallel = 1;
        this.isEpsilonTransition = NFAEdge.isEpsilonCharacter(this.transitionLabel.getSymbol());
    }

    public NFAEdge(NFAVertexND sourceVertex, NFAVertexND targetVertex, TransitionLabel transitionLabel) {
        if (sourceVertex == null || targetVertex == null || transitionLabel == null) {
            throw new NullPointerException("Null parameters are not allowed.");
        }
        if (transitionLabel.isEmpty()) {
            throw new IllegalArgumentException("The transition label of an edge cannot be empty.");
        }
        this.sourceVertex = sourceVertex;
        this.targetVertex = targetVertex;
        this.transitionLabel = transitionLabel;
        this.numParallel = 1;
        this.isEpsilonTransition = transitionLabel.getTransitionType() == TransitionLabel.TransitionType.EPSILON;
    }

    public static boolean isEpsilonCharacter(String transitionLabelString) {
        return transitionLabelString.indexOf(949) >= 0 && isEpsilonCharacterRegex.matcher(transitionLabelString).find();
    }

    public NFAEdge copy() {
        NFAEdge newEdge = new NFAEdge(this.sourceVertex, this.targetVertex, this.transitionLabel);
        newEdge.setNumParallel(this.numParallel);
        return newEdge;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!o.getClass().isAssignableFrom(this.getClass())) {
            return false;
        }
        NFAEdge n = (NFAEdge)o;
        if (!this.sourceVertex.equals(n.sourceVertex)) {
            return false;
        }
        if (!this.targetVertex.equals(n.targetVertex)) {
            return false;
        }
        return this.transitionLabel.equals(n.transitionLabel);
    }

    public int hashCode() {
        return this.sourceVertex.hashCode() + this.targetVertex.hashCode() + this.transitionLabel.hashCode();
    }

    public String toString() {
        return this.transitionLabel + "*" + this.numParallel;
    }

    public boolean isTransitionFor(String word) {
        return this.transitionLabel.matches(word);
    }

    public boolean isTransitionFor(TransitionLabel tl) {
        return this.transitionLabel.matches(tl);
    }

    @Override
    public int compareTo(NFAEdge o) {
        if (!this.getIsEpsilonTransition() && o.getIsEpsilonTransition()) {
            return -1;
        }
        if (this.getIsEpsilonTransition() && !o.getIsEpsilonTransition()) {
            return 1;
        }
        if (this.getIsEpsilonTransition() && o.getIsEpsilonTransition()) {
            EpsilonTransitionLabel etl = (EpsilonTransitionLabel)this.transitionLabel;
            EpsilonTransitionLabel oetl = (EpsilonTransitionLabel)o.transitionLabel;
            return etl.compareTo(oetl);
        }
        CharacterClassTransitionLabel cctl = (CharacterClassTransitionLabel)this.transitionLabel;
        CharacterClassTransitionLabel occtl = (CharacterClassTransitionLabel)o.transitionLabel;
        return cctl.compareTo(occtl);
    }
}

