/*
 * Decompiled with CFR 0.152.
 */
package nfa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

public class NFAVertexND
implements Comparable<NFAVertexND> {
    private final ArrayList<String> states = new ArrayList();
    private int hashCode1 = -2128831035;
    private int hashCode2;

    public ArrayList<String> getStates() {
        return new ArrayList<String>(this.states);
    }

    public String getStateNumberByDimension(int dim) {
        return this.states.get(dim - 1);
    }

    public NFAVertexND getStateByDimension(int dim) {
        return new NFAVertexND(this.states.get(dim - 1));
    }

    public NFAVertexND getStateByDimensionRange(int fromIndex, int toIndex) {
        return new NFAVertexND(this.states.subList(fromIndex - 1, toIndex - 1));
    }

    public int getNumDimensions() {
        return this.states.size();
    }

    public NFAVertexND(int m1StateNumber) {
        this(String.valueOf(m1StateNumber));
    }

    public NFAVertexND(String m1StateNumber) {
        this.addToStates(m1StateNumber);
    }

    public NFAVertexND(int m1StateNumber, int m2StateNumber, int m3StateNumber) {
        this(String.valueOf(m1StateNumber), String.valueOf(m2StateNumber), String.valueOf(m3StateNumber));
    }

    public NFAVertexND(String m1StateNumber, String m2StateNumber, String m3StateNumber) {
        this.addToStates(m1StateNumber);
        this.addToStates(m2StateNumber);
        this.addToStates(m3StateNumber);
    }

    public NFAVertexND(int m1StateNumber, int m2StateNumber, int m3StateNumber, int m4StateNumber, int m5StateNumber) {
        this(String.valueOf(m1StateNumber), String.valueOf(m2StateNumber), String.valueOf(m3StateNumber), String.valueOf(m4StateNumber), String.valueOf(m5StateNumber));
    }

    public NFAVertexND(String m1StateNumber, String m2StateNumber, String m3StateNumber, String m4StateNumber, String m5StateNumber) {
        this.addToStates(m1StateNumber);
        this.addToStates(m2StateNumber);
        this.addToStates(m3StateNumber);
        this.addToStates(m4StateNumber);
        this.addToStates(m5StateNumber);
    }

    public NFAVertexND(int ... mStates) {
        for (int i : mStates) {
            String state = String.valueOf(i);
            this.addToStates(state);
        }
    }

    public NFAVertexND(String ... mStates) {
        for (String i : mStates) {
            this.addToStates(i);
        }
    }

    public NFAVertexND(NFAVertexND ... mStates) {
        for (NFAVertexND nfavnd : mStates) {
            for (String i : nfavnd.states) {
                this.addToStates(i);
            }
        }
    }

    public NFAVertexND(Collection<String> states) {
        for (String i : states) {
            this.addToStates(i);
        }
    }

    public NFAVertexND(Set<NFAVertexND> states) {
        for (NFAVertexND i : states) {
            for (String s : i.states) {
                this.addToStates(s);
            }
        }
    }

    public NFAVertexND copy() {
        NFAVertexND c = new NFAVertexND(this.states);
        return c;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("(");
        Iterator<String> i0 = this.states.iterator();
        while (i0.hasNext()) {
            sb.append(i0.next());
            if (!i0.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        NFAVertexND p = (NFAVertexND)o;
        return this.hashCode1 == p.hashCode1 && this.hashCode2 == p.hashCode2 && this.states.size() == p.states.size();
    }

    public int hashCode() {
        return this.hashCode1 ^ this.hashCode2 ^ this.states.size();
    }

    private void addToStates(String state) {
        this.states.add(state);
        for (int i = 0; i < state.length(); ++i) {
            this.hashCode1 = -2128831035 * this.hashCode1 ^ state.charAt(i);
            this.hashCode2 = 31 * this.hashCode2 + state.charAt(i);
        }
    }

    @Override
    public int compareTo(NFAVertexND o) {
        int rc = Integer.compare(this.states.size(), o.states.size());
        if (rc != 0) {
            return rc;
        }
        for (int i = 0; i < this.states.size(); ++i) {
            rc = this.states.get(i).compareTo(o.states.get(i));
            if (rc == 0) continue;
            return rc;
        }
        return 0;
    }
}

