/*
 * Decompiled with CFR 0.152.
 */
package nfa.transitionlabel;

import java.util.LinkedList;
import java.util.regex.PatternSyntaxException;
import nfa.NFAEdge;
import nfa.transitionlabel.CharacterClassTransitionLabel;
import nfa.transitionlabel.CharacterPropertyParser;
import nfa.transitionlabel.EpsilonTransitionLabel;
import nfa.transitionlabel.TransitionLabel;
import util.RangeSet;

public class TransitionLabelParserRecursive {
    private static final int MIN_16UNICODE = 0;
    private static final int MAX_16UNICODE = 65536;
    private final String transitionLabelString;
    private char currentSymbol;
    private int index;
    private int depth;
    private CharacterPropertyParser characterPropertyParser;

    public TransitionLabelParserRecursive(String transitionLabelString) {
        this.transitionLabelString = transitionLabelString;
        this.index = 0;
        this.depth = 0;
    }

    private boolean consumeSymbol() {
        if (this.index >= this.transitionLabelString.length()) {
            return false;
        }
        this.currentSymbol = this.transitionLabelString.charAt(this.index);
        ++this.index;
        return true;
    }

    private void consumeSymbolIfHasNext() {
        if (this.index < this.transitionLabelString.length()) {
            this.consumeSymbol();
        }
    }

    public TransitionLabel parseTransitionLabel() {
        TransitionLabel toReturn;
        this.consumeSymbol();
        switch (this.currentSymbol) {
            case '.': {
                RangeSet labelRanges = CharacterClassTransitionLabel.predefinedRangeWildcard();
                toReturn = new CharacterClassTransitionLabel(labelRanges);
                break;
            }
            case '[': {
                RangeSet labelRanges = this.parseCharacterClass();
                if (this.depth != 0) {
                    throw new PatternSyntaxException("Unclosed character class", this.transitionLabelString, this.index);
                }
                toReturn = new CharacterClassTransitionLabel(labelRanges);
                break;
            }
            case '\\': {
                this.consumeSymbol();
                if (this.currentSymbol == '\\') {
                    toReturn = new CharacterClassTransitionLabel("\\");
                    break;
                }
                if (this.currentSymbol == '-') {
                    toReturn = new CharacterClassTransitionLabel("-");
                    break;
                }
                RangeSet predefinedCharacterClassRangeSet = this.parsePredefinedCharacterClass(this.currentSymbol);
                toReturn = new CharacterClassTransitionLabel(predefinedCharacterClassRangeSet);
                break;
            }
            default: {
                toReturn = NFAEdge.isEpsilonCharacter(this.transitionLabelString) ? new EpsilonTransitionLabel(this.transitionLabelString) : new CharacterClassTransitionLabel(this.transitionLabelString);
            }
        }
        this.index = this.transitionLabelString.length();
        return toReturn;
    }

    private RangeSet parsePredefinedCharacterClass(char firstSymbol) {
        RangeSet toReturn = null;
        boolean complement = false;
        switch (firstSymbol) {
            case 'a': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\u0007');
            }
            case 'e': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\u001b');
            }
            case 'f': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\f');
            }
            case 'n': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\n');
            }
            case 'r': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\r');
            }
            case 't': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\t');
            }
            case '\\': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\\');
            }
            case '\'': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\'');
            }
            case '\"': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('\"');
            }
            case '[': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('[');
            }
            case ']': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange(']');
            }
            case '-': {
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange('-');
            }
            case 'Q': {
                return this.parseQuotedSequence();
            }
            case '0': {
                char c = this.parseEscapedOctalCharacter();
                return this.parseCharacterRange(c);
            }
            case 'u': {
                char c = this.parseEscapedUnicodeCharacter();
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange(c);
            }
            case 'x': {
                char c = this.parseEscapedHexCharacter();
                this.consumeSymbolIfHasNext();
                return this.parseCharacterRange(c);
            }
            case 'c': {
                this.consumeSymbol();
                int charCode = ((this.currentSymbol - 64) % 128 + 128) % 128;
                char c = (char)charCode;
                this.consumeSymbol();
                return this.parseCharacterRange(c);
            }
            case 'D': {
                complement = true;
            }
            case 'd': {
                toReturn = CharacterClassTransitionLabel.predefinedRangeSetDigits();
                break;
            }
            case 'S': {
                complement = true;
            }
            case 's': {
                toReturn = CharacterClassTransitionLabel.predefinedRangeSetWhiteSpaces();
                break;
            }
            case 'W': {
                complement = true;
            }
            case 'w': {
                toReturn = CharacterClassTransitionLabel.predefinedRangeSetWordCharacters();
                break;
            }
            case 'V': {
                complement = true;
            }
            case 'v': {
                toReturn = CharacterClassTransitionLabel.predefinedRangeSetVerticalTab();
                break;
            }
            case 'H': {
                complement = true;
            }
            case 'h': {
                toReturn = CharacterClassTransitionLabel.predefinedRangeSetHorizontalTab();
                break;
            }
            case 'P': {
                complement = true;
            }
            case 'p': {
                toReturn = this.parsePropertyCharacterClass();
                break;
            }
            default: {
                if (this.currentSymbol >= 'A' && this.currentSymbol <= 'Z' || this.currentSymbol >= 'a' && this.currentSymbol <= 'z' || this.currentSymbol >= '0' && this.currentSymbol <= '9') {
                    throw new PatternSyntaxException("Illegal/unsupported escape sequence", this.transitionLabelString, this.index);
                }
                char symbol = this.currentSymbol;
                this.consumeSymbol();
                return this.parseCharacterRange(symbol);
            }
        }
        this.consumeSymbolIfHasNext();
        if (complement) {
            toReturn.complement();
        }
        return toReturn;
    }

    private RangeSet parseQuotedSequence() {
        char lastChar;
        LinkedList<RangeSet.Range> symbolSequence;
        RangeSet toReturn;
        block6: {
            toReturn = new RangeSet(0, 65536);
            this.consumeSymbol();
            symbolSequence = new LinkedList<RangeSet.Range>();
            lastChar = this.currentSymbol;
            do {
                if (this.currentSymbol == '\\') {
                    if (!this.consumeSymbol()) {
                        throw new PatternSyntaxException("Unclosed character class", this.transitionLabelString, this.index);
                    }
                    if (this.currentSymbol == 'E') {
                        if (!this.consumeSymbol()) {
                            throw new PatternSyntaxException("Unclosed character class", this.transitionLabelString, this.index);
                        }
                        break block6;
                    }
                    symbolSequence.add(toReturn.createRange(92));
                }
                symbolSequence.add(toReturn.createRange(this.currentSymbol));
                lastChar = this.currentSymbol;
            } while (this.consumeSymbol());
            throw new PatternSyntaxException("Unclosed character class", this.transitionLabelString, this.index);
        }
        toReturn.union(symbolSequence);
        if (this.currentSymbol == '-') {
            toReturn.union(this.parseCharacterRange(lastChar));
        }
        return toReturn;
    }

    private char parseEscapedOctalCharacter() {
        this.consumeSymbol();
        StringBuilder hexNumberStr = new StringBuilder();
        int tmpNum = 0;
        for (int i = 0; tmpNum < 255 && this.currentSymbol >= '0' && this.currentSymbol <= '7' && i < 3; ++i) {
            hexNumberStr.append(this.currentSymbol);
            tmpNum = Integer.parseInt(hexNumberStr.toString(), 8);
            if (this.consumeSymbol()) continue;
        }
        try {
            int hexNumber = Integer.parseInt(hexNumberStr.toString(), 8);
            if (hexNumber >= 65536) {
                throw new PatternSyntaxException("Hexadecimal codepoint is too big", this.transitionLabelString, this.index);
            }
            return (char)hexNumber;
        }
        catch (NumberFormatException nfe) {
            throw new PatternSyntaxException("Illegal hexadecimal escape sequence", this.transitionLabelString, this.index);
        }
    }

    private char parseEscapedUnicodeCharacter() {
        this.consumeSymbol();
        StringBuilder hexNumberStr = new StringBuilder();
        hexNumberStr.append(this.currentSymbol);
        for (int i = 0; i < 4; ++i) {
            this.consumeSymbol();
            hexNumberStr.append(this.currentSymbol);
        }
        try {
            int hexNumber = Integer.parseInt(hexNumberStr.toString(), 16);
            if (hexNumber >= 65536) {
                throw new PatternSyntaxException("Hexadecimal codepoint is too big", this.transitionLabelString, this.index);
            }
            return (char)hexNumber;
        }
        catch (NumberFormatException nfe) {
            throw new PatternSyntaxException("Illegal hexadecimal escape sequence", this.transitionLabelString, this.index);
        }
    }

    private char parseEscapedHexCharacter() {
        this.consumeSymbol();
        StringBuilder hexNumberStr = new StringBuilder();
        if (this.currentSymbol == '{') {
            this.consumeSymbol();
            while (this.currentSymbol != '}') {
                hexNumberStr.append(this.currentSymbol);
                this.consumeSymbol();
            }
        } else {
            hexNumberStr.append(this.currentSymbol);
            this.consumeSymbol();
            hexNumberStr.append(this.currentSymbol);
        }
        try {
            int hexNumber = Integer.parseInt(hexNumberStr.toString(), 16);
            if (hexNumber >= 65536) {
                throw new PatternSyntaxException("Hexadecimal codepoint is too big", this.transitionLabelString, this.index);
            }
            return (char)hexNumber;
        }
        catch (NumberFormatException nfe) {
            throw new PatternSyntaxException("Illegal hexadecimal escape sequence", this.transitionLabelString, this.index);
        }
    }

    private RangeSet parsePropertyCharacterClass() {
        RangeSet toReturn;
        if (this.characterPropertyParser == null) {
            this.characterPropertyParser = new CharacterPropertyParser(this.transitionLabelString, this.index);
        } else {
            this.characterPropertyParser.setIndex(this.index);
        }
        this.consumeSymbol();
        if (this.currentSymbol != '{') {
            toReturn = this.characterPropertyParser.parseCharacterProperty(Character.toString(this.currentSymbol));
        } else {
            StringBuilder sb = new StringBuilder();
            this.consumeSymbol();
            while (this.currentSymbol != '}') {
                sb.append(this.currentSymbol);
                this.consumeSymbol();
            }
            String characterPropertyString = sb.toString();
            toReturn = this.characterPropertyParser.parseCharacterProperty(characterPropertyString);
        }
        return toReturn;
    }

    private RangeSet parseCharacterClass() {
        ++this.depth;
        if (!this.consumeSymbol()) {
            throw new PatternSyntaxException("Unclosed character class", this.transitionLabelString, this.index);
        }
        boolean isComplement = false;
        if (this.currentSymbol == '^') {
            isComplement = true;
            this.consumeSymbol();
        }
        RangeSet characterClassRangeSet = new RangeSet(0, 65536);
        if (this.currentSymbol == ']') {
            characterClassRangeSet.union(this.createCharacterRange(']'));
            if (!this.consumeSymbol()) {
                throw new PatternSyntaxException("Unclosed character class", this.transitionLabelString, this.index);
            }
        }
        characterClassRangeSet.union(this.parseCharacterClassFactor(characterClassRangeSet, isComplement));
        while (this.currentSymbol != ']') {
            RangeSet currentFactor = this.parseCharacterClassFactor(new RangeSet(0, 65536), false);
            characterClassRangeSet.intersection(currentFactor);
        }
        --this.depth;
        if (this.index < this.transitionLabelString.length()) {
            this.consumeSymbol();
        } else if (this.depth != 0) {
            throw new PatternSyntaxException("Unclosed character class", this.transitionLabelString, this.index);
        }
        return characterClassRangeSet;
    }

    private RangeSet parseCharacterClassFactor(RangeSet characterClassFactorRangeSet, boolean isComplement) {
        boolean factorComplete = false;
        while (!factorComplete) {
            if (this.currentSymbol == '[') {
                if (isComplement) {
                    isComplement = false;
                    if (!characterClassFactorRangeSet.isEmpty()) {
                        characterClassFactorRangeSet.complement();
                    }
                }
                RangeSet currentFactor = this.parseCharacterClass();
                characterClassFactorRangeSet.union(currentFactor);
                continue;
            }
            if (this.currentSymbol == ']') {
                if (isComplement) {
                    characterClassFactorRangeSet.complement();
                }
                factorComplete = true;
                continue;
            }
            if (this.currentSymbol == '&') {
                this.consumeSymbol();
                if (this.currentSymbol == '&') {
                    factorComplete = true;
                    if (isComplement) {
                        characterClassFactorRangeSet.complement();
                    }
                    this.consumeSymbol();
                    continue;
                }
                characterClassFactorRangeSet.union(this.parseCharacterRange('&'));
                continue;
            }
            if (this.currentSymbol == '\\') {
                this.consumeSymbol();
                characterClassFactorRangeSet.union(this.parsePredefinedCharacterClass(this.currentSymbol));
                continue;
            }
            char firstSymbol = this.currentSymbol;
            this.consumeSymbol();
            characterClassFactorRangeSet.union(this.parseCharacterRange(firstSymbol));
        }
        return characterClassFactorRangeSet;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private RangeSet parseCharacterRange(char firstSymbol) {
        RangeSet characterRangeRangeSet;
        if (this.currentSymbol == '-') {
            if (this.index >= this.transitionLabelString.length()) throw new PatternSyntaxException("Illegal character range", this.transitionLabelString, this.index);
            this.consumeSymbol();
            if (this.currentSymbol == '\\') {
                this.consumeSymbol();
                switch (this.currentSymbol) {
                    case 'a': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '\u0007');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case 'e': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '\u001b');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case 'f': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '\f');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case 'n': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '\n');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case 'r': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '\r');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case 't': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '\t');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case '[': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '[');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case ']': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, ']');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case '\\': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '\\');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case '-': {
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, '-');
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case '0': {
                        char c = this.parseEscapedOctalCharacter();
                        return this.createCharacterRange(firstSymbol, c);
                    }
                    case 'u': {
                        char c = this.parseEscapedUnicodeCharacter();
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, c);
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case 'x': {
                        char c = this.parseEscapedHexCharacter();
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, c);
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    case 'c': {
                        this.consumeSymbol();
                        int charCode = ((this.currentSymbol - 64) % 128 + 128) % 128;
                        char c = (char)charCode;
                        this.consumeSymbol();
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, c);
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                    default: {
                        if (this.currentSymbol >= 'A') {
                            if (this.currentSymbol <= 'Z') throw new PatternSyntaxException("Illegal character range", this.transitionLabelString, this.index);
                        }
                        if (this.currentSymbol >= 'a') {
                            if (this.currentSymbol <= 'z') throw new PatternSyntaxException("Illegal character range", this.transitionLabelString, this.index);
                        }
                        if (this.currentSymbol >= '0' && this.currentSymbol <= '9') {
                            throw new PatternSyntaxException("Illegal character range", this.transitionLabelString, this.index);
                        }
                        characterRangeRangeSet = this.createCharacterRange(firstSymbol, this.currentSymbol);
                        this.consumeSymbol();
                        return characterRangeRangeSet;
                    }
                }
            } else if (this.currentSymbol == ']' || this.currentSymbol == '[') {
                characterRangeRangeSet = this.createCharacterRange(firstSymbol);
                characterRangeRangeSet.union(this.createCharacterRange('-'));
                return characterRangeRangeSet;
            } else {
                characterRangeRangeSet = this.createCharacterRange(firstSymbol, this.currentSymbol);
                this.consumeSymbol();
            }
            return characterRangeRangeSet;
        } else {
            if (this.currentSymbol != '\\') return this.createCharacterRange(firstSymbol);
            this.consumeSymbol();
            characterRangeRangeSet = this.createCharacterRange(firstSymbol);
            characterRangeRangeSet.union(this.parsePredefinedCharacterClass(this.currentSymbol));
        }
        return characterRangeRangeSet;
    }

    private RangeSet createCharacterRange(char symbol) {
        char currentSymbolInt = symbol;
        RangeSet characterRangeSet = new RangeSet(0, 65536);
        RangeSet.Range characterRange = characterRangeSet.createRange(currentSymbolInt, currentSymbolInt + '\u0001');
        characterRangeSet.union(characterRange);
        return characterRangeSet;
    }

    private RangeSet createCharacterRange(char symbol1, char symbol2) {
        char currentSymbolInt1 = symbol1;
        char currentSymbolInt2 = symbol2;
        RangeSet characterRangeRangeSet = new RangeSet(0, 65536);
        try {
            RangeSet.Range characterRange = characterRangeRangeSet.createRange(currentSymbolInt1, currentSymbolInt2 + '\u0001');
            characterRangeRangeSet.union(characterRange);
            return characterRangeRangeSet;
        }
        catch (IllegalArgumentException iae) {
            throw new PatternSyntaxException("Illegal character range", this.transitionLabelString, this.index);
        }
    }

    public static void main(String[] args) {
        TransitionLabelParserRecursive tpr = new TransitionLabelParserRecursive(args[0]);
        TransitionLabel parseTransitionLabel = tpr.parseTransitionLabel();
        System.out.println(parseTransitionLabel);
    }
}

