/*
 * Decompiled with CFR 0.152.
 */
package preprocessor;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import preprocessor.Preprocessor;
import preprocessor.PreprocessorRule;

public abstract class ParsingPreprocessor
implements Preprocessor {
    protected static boolean ALLOW_LOOKAROUND = false;
    protected static boolean ALLOW_LINE_BOUNDARY = false;
    protected static boolean ALLOW_ZERO_ONCE = false;
    private static final int MAX_REPETITION = 256;
    private final int MAX_REGEX_LENGTH = 0x800000;
    private LinkedList<PreprocessorRule> rules = new LinkedList();
    private static Pattern canEscapeVerbatimRegex = Pattern.compile("[a-zA-Z]");

    @Override
    public String applyRules(String regex) {
        for (PreprocessorRule rule : this.rules) {
            List<RegexToken> tokenStream;
            regex = rule.process(tokenStream = ParsingPreprocessor.tokenize(regex, 0));
            if (regex.length() <= 0x800000) continue;
            throw new RegexException("Regular expression length exceeded.");
        }
        return regex;
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static List<RegexToken> tokenize(String regex, int currentLevel) {
        tokenStream = new LinkedList<RegexToken>();
        regexArr = regex.toCharArray();
        i = 0;
        escaped = false;
        block38: while (i < regexArr.length) {
            switch (regexArr[i]) {
                case '(': {
                    groupType = GroupFactor.GroupType.NORMAL;
                    if (i >= regex.length() - 2 || regexArr[i + 1] != '?') ** GOTO lbl41
                    if (regexArr[i + 2] != '<') ** GOTO lbl25
                    ParsingPreprocessor.checkAllowedFunctionality(ParsingPreprocessor.ALLOW_LOOKAROUND, "Lookaround symbol");
                    if (i >= regex.length() - 3) ** GOTO lbl22
                    switch (regexArr[i + 3]) {
                        case '=': {
                            groupType = GroupFactor.GroupType.POSLOOKBEHIND;
                            ** GOTO lbl23
                        }
                        case '!': {
                            groupType = GroupFactor.GroupType.NEGLOOKBEHIND;
                            ** GOTO lbl23
                        }
                        default: {
                            throw new PatternSyntaxException("Unknown look-behind group", regex, i);
                        }
                    }
lbl22:
                    // 1 sources

                    throw new PatternSyntaxException("Unknown look-behind group", regex, i);
lbl23:
                    // 2 sources

                    i += 4;
                    ** GOTO lbl42
lbl25:
                    // 1 sources

                    switch (regexArr[i + 2]) {
                        case ':': {
                            groupType = GroupFactor.GroupType.NONCAPTURING;
                            break;
                        }
                        case '=': {
                            ParsingPreprocessor.checkAllowedFunctionality(ParsingPreprocessor.ALLOW_LOOKAROUND, "Positive lookahead");
                            groupType = GroupFactor.GroupType.POSLOOKAHEAD;
                            break;
                        }
                        case '!': {
                            ParsingPreprocessor.checkAllowedFunctionality(ParsingPreprocessor.ALLOW_LOOKAROUND, "Negative lookahead");
                            groupType = GroupFactor.GroupType.NEGLOOKAHEAD;
                            break;
                        }
                        default: {
                            throw new PatternSyntaxException("Unknown inline modifier", regex, i);
                        }
                    }
                    i += 3;
                    ** GOTO lbl42
lbl41:
                    // 1 sources

                    ++i;
lbl42:
                    // 3 sources

                    groupBuilder = new StringBuilder();
                    level = 1;
                    do {
                        if (i >= regexArr.length) {
                            throw new PatternSyntaxException("Unmatched '('", regex, i);
                        }
                        if (regexArr[i] == '\\') {
                            groupBuilder.append(regexArr[i]);
                            ++i;
                            escaped = true;
                        } else if (regexArr[i] == '[') {
                            while (i < regexArr.length && regexArr[i] != ']') {
                                groupBuilder.append(regexArr[i]);
                                ++i;
                            }
                        }
                        if (!escaped && regexArr[i] == '(') {
                            if (level != 0) {
                                groupBuilder.append("(");
                            }
                            ++level;
                        } else if (!escaped && regexArr[i] == ')') {
                            if (--level != 0) {
                                groupBuilder.append(")");
                            }
                        } else {
                            groupBuilder.append(regexArr[i]);
                        }
                        escaped = false;
                        ++i;
                    } while (level != 0);
                    groupTokens = ParsingPreprocessor.tokenize(groupBuilder.toString(), currentLevel + 1);
                    groupFactor = new GroupFactor(groupTokens, groupType);
                    tokenStream.add(groupFactor);
                    continue block38;
                }
                case '[': {
                    groupBuilder = new StringBuilder();
                    level = 1;
                    ++i;
                    while (level != 0) {
                        if (i >= regexArr.length) {
                            throw new PatternSyntaxException("Unclosed character class", regex, i);
                        }
                        if (regexArr[i] == '\\') {
                            groupBuilder.append(regexArr[i]);
                            ++i;
                            escaped = true;
                        }
                        if (!escaped && regexArr[i] == '[') {
                            ++level;
                        } else if (!escaped && regexArr[i] == ']') {
                            --level;
                        }
                        if (level != 0) {
                            groupBuilder.append(regexArr[i]);
                        }
                        escaped = false;
                        ++i;
                    }
                    symbols = groupBuilder.toString();
                    characterClassFactor = new CharacterClassFactor(symbols);
                    tokenStream.add(characterClassFactor);
                    continue block38;
                }
                case '\\': {
                    if (++i < regexArr.length && regexArr[i] == 'Q') {
                        ++i;
                        while (i < regexArr.length) {
                            if (regexArr[i] == '\\') {
                                if (++i < regexArr.length && regexArr[i] == 'E') break;
                                if (i < regexArr.length) {
                                    currentSymbol = "" + regexArr[i];
                                    verbatimChar /* !! */  = ParsingPreprocessor.canEscapeVerbatim(currentSymbol) != false ? new EscapeFactor("\\" + currentSymbol, EscapeFactor.EscapeType.VERBATIM) : new SingleFactor(currentSymbol);
                                    tokenStream.add(verbatimChar /* !! */ );
                                }
                            } else {
                                currentSymbol = "" + regexArr[i];
                                verbatimChar /* !! */  = ParsingPreprocessor.canEscapeVerbatim(currentSymbol) != false ? new EscapeFactor("\\" + currentSymbol, EscapeFactor.EscapeType.VERBATIM) : new SingleFactor(currentSymbol);
                                tokenStream.add(verbatimChar /* !! */ );
                            }
                            ++i;
                        }
                        ++i;
                        continue block38;
                    }
                    if (i >= regexArr.length || regexArr[i] != 'x') ** GOTO lbl155
                    groupBuilder = new StringBuilder("\\x");
                    if (++i >= regexArr.length || regexArr[i] != '{') ** GOTO lbl140
                    while (i < regexArr.length && regexArr[i] != '}') {
                        groupBuilder.append(regexArr[i]);
                        ++i;
                    }
                    groupBuilder.append("}");
                    ++i;
                    ** GOTO lbl150
lbl140:
                    // 1 sources

                    if (i >= regexArr.length) ** GOTO lbl149
                    groupBuilder.append(regexArr[i]);
                    if (++i < regexArr.length) {
                        groupBuilder.append(regexArr[i]);
                        ++i;
                    } else {
                        throw new PatternSyntaxException("Illegal hexadecimal escape sequence", regex, i);
lbl149:
                        // 1 sources

                        throw new PatternSyntaxException("Illegal hexadecimal escape sequence", regex, i);
                    }
lbl150:
                    // 2 sources

                    escapeSequence = groupBuilder.toString();
                    escapeFactor = new EscapeFactor(escapeSequence, EscapeFactor.EscapeType.HEX);
                    tokenStream.add(escapeFactor);
                    continue block38;
lbl155:
                    // 1 sources

                    if (i < regexArr.length && regexArr[i] == '0') {
                        groupBuilder = new StringBuilder("\\0");
                        hexNumberStr = "";
                        tmpNum = 0;
                        ++i;
                        for (octalDigitCounter = 0; i < regexArr.length && tmpNum < 255 && '0' <= regexArr[i] && regexArr[i] <= '7' && octalDigitCounter < 3; ++i, ++octalDigitCounter) {
                            hexNumberStr = hexNumberStr + regexArr[i];
                            groupBuilder.append(regexArr[i]);
                            tmpNum = Integer.parseInt(hexNumberStr, 8);
                        }
                        escapeSequence = groupBuilder.toString();
                        escapeFactor = new EscapeFactor(escapeSequence, EscapeFactor.EscapeType.OCTAL);
                        tokenStream.add(escapeFactor);
                        continue block38;
                    }
                    if (i < regexArr.length && regexArr[i] == 'u') {
                        groupBuilder = new StringBuilder("\\u");
                        if (++i < regexArr.length - 3) {
                            for (j = 0; j < 4; ++j) {
                                groupBuilder.append(regexArr[i]);
                                ++i;
                            }
                        } else {
                            throw new PatternSyntaxException("Illegal unicode escape sequence", regex, i);
                        }
                        escapeSequence = groupBuilder.toString();
                        escapeFactor = new EscapeFactor(escapeSequence, EscapeFactor.EscapeType.UNICODE);
                        tokenStream.add(escapeFactor);
                        throw new PatternSyntaxException("Illegal/unsupported escape sequence", regex, i);
                    }
                    if (i < regexArr.length && regexArr[i] == 'p') {
                        groupBuilder = new StringBuilder("\\p");
                        if (regexArr[++i] == '{') {
                            while (regexArr[i] != '}') {
                                groupBuilder.append(regexArr[i]);
                                if (++i < regexArr.length) continue;
                                throw new PatternSyntaxException("Unclosed character family near index", regex, i);
                            }
                            groupBuilder.append('}');
                            ++i;
                        } else {
                            groupBuilder.append(regexArr[i]);
                            ++i;
                        }
                        escapeSequence = groupBuilder.toString();
                        escapeFactor = new EscapeFactor(escapeSequence, EscapeFactor.EscapeType.CHARACTER_PROPERTY);
                        tokenStream.add(escapeFactor);
                        continue block38;
                    }
                    if (i < regexArr.length) {
                        escapedSequence = "\\" + regexArr[i];
                        escapeFactor = new EscapeFactor(escapedSequence, EscapeFactor.EscapeType.CHARACTER);
                        tokenStream.add(escapeFactor);
                        ++i;
                        continue block38;
                    }
                    escapedSequence = "\\";
                    escapeFactor = new EscapeFactor(escapedSequence, EscapeFactor.EscapeType.CHARACTER);
                    tokenStream.add(escapeFactor);
                    ++i;
                    continue block38;
                }
                case '{': {
                    quantifier = QuantifiableOperator.Quantifier.GREEDY;
                    countedClosureBuilder = new StringBuilder("{");
                    while (regexArr[i] != '}') {
                        if (++i >= regexArr.length) {
                            throw new PatternSyntaxException("Unclosed counted closure", regex, i);
                        }
                        countedClosureBuilder.append(regexArr[i]);
                    }
                    if (++i < regexArr.length) {
                        switch (regexArr[i]) {
                            case '?': {
                                quantifier = QuantifiableOperator.Quantifier.RELUCTANT;
                                ++i;
                                break;
                            }
                            case '+': {
                                quantifier = QuantifiableOperator.Quantifier.POSSESIVE;
                                ++i;
                            }
                        }
                    }
                    operatorSymbol = countedClosureBuilder.toString();
                    boundedPattern = Pattern.compile("\\{(\\d+),(\\d+)\\}");
                    unboundedPattern = Pattern.compile("\\{(\\d+),\\}");
                    constantRepititionPattern = Pattern.compile("\\{(\\d+)\\}");
                    boundedMatcher = boundedPattern.matcher(operatorSymbol);
                    unboundedMatcher = unboundedPattern.matcher(operatorSymbol);
                    constantRepititionMatcher = constantRepititionPattern.matcher(operatorSymbol);
                    if (boundedMatcher.find()) {
                        lowStr = boundedMatcher.group(1);
                        low = Integer.parseInt(lowStr);
                        highStr = boundedMatcher.group(2);
                        high = Integer.parseInt(highStr);
                        if (high < low || low < 0 || high > 256) {
                            throw new PatternSyntaxException("Illegal repetition range", regex, i);
                        }
                        operatorToken = new CountClosureOperator(operatorSymbol, quantifier, low, high);
                        tokenStream.add(operatorToken);
                        continue block38;
                    }
                    if (unboundedMatcher.find()) {
                        lowStr = unboundedMatcher.group(1);
                        low = Integer.parseInt(lowStr);
                        if (low < 0 || low > 256) {
                            throw new PatternSyntaxException("Illegal repetition range", regex, i);
                        }
                        operatorToken = new CountClosureOperator(operatorSymbol, quantifier, low, CountClosureOperator.BoundsType.UNBOUNDED);
                        tokenStream.add(operatorToken);
                        continue block38;
                    }
                    if (constantRepititionMatcher.find()) {
                        lowStr = constantRepititionMatcher.group(1);
                        low = Integer.parseInt(lowStr);
                        if (low < 0 || low > 256) {
                            throw new PatternSyntaxException("Illegal repetition range", regex, i);
                        }
                        operatorToken = new CountClosureOperator(operatorSymbol, quantifier, low, CountClosureOperator.BoundsType.CONSTANT_REPETITION);
                        tokenStream.add(operatorToken);
                        continue block38;
                    }
                    throw new PatternSyntaxException("Illegal repetition range", regex, i);
                }
                case '*': {
                    quantifier = QuantifiableOperator.Quantifier.GREEDY;
                    if (++i < regexArr.length) {
                        switch (regexArr[i]) {
                            case '?': {
                                quantifier = QuantifiableOperator.Quantifier.RELUCTANT;
                                ++i;
                                break;
                            }
                            case '+': {
                                quantifier = QuantifiableOperator.Quantifier.POSSESIVE;
                                ++i;
                            }
                        }
                    }
                    operatorToken = new QuantifiableOperator("*", RegexOperator.OperatorType.STAR, quantifier);
                    tokenStream.add(operatorToken);
                    continue block38;
                }
                case '+': {
                    quantifier = QuantifiableOperator.Quantifier.GREEDY;
                    if (++i < regexArr.length) {
                        switch (regexArr[i]) {
                            case '?': {
                                quantifier = QuantifiableOperator.Quantifier.RELUCTANT;
                                ++i;
                                break;
                            }
                            case '+': {
                                quantifier = QuantifiableOperator.Quantifier.POSSESIVE;
                                ++i;
                            }
                        }
                    }
                    operatorToken = new QuantifiableOperator("+", RegexOperator.OperatorType.PLUS, quantifier);
                    tokenStream.add(operatorToken);
                    continue block38;
                }
                case '?': {
                    quantifier = QuantifiableOperator.Quantifier.GREEDY;
                    if (++i < regexArr.length) {
                        switch (regexArr[i]) {
                            case '?': {
                                quantifier = QuantifiableOperator.Quantifier.RELUCTANT;
                                ++i;
                                break;
                            }
                            case '+': {
                                quantifier = QuantifiableOperator.Quantifier.POSSESIVE;
                                ++i;
                            }
                        }
                    }
                    ParsingPreprocessor.checkAllowedFunctionality(ParsingPreprocessor.ALLOW_ZERO_ONCE, "? operator");
                    operatorToken = new QuantifiableOperator("?", RegexOperator.OperatorType.QM, quantifier);
                    tokenStream.add(operatorToken);
                    continue block38;
                }
                case '|': {
                    ++i;
                    operatorToken = new RegexOperator("|", RegexOperator.OperatorType.OR);
                    tokenStream.add(operatorToken);
                    continue block38;
                }
                case '.': {
                    ++i;
                    wildCardToken = new WildCardFactor();
                    tokenStream.add(wildCardToken);
                    continue block38;
                }
                case '^': {
                    if (i == 0 && currentLevel == 0) {
                        ++i;
                        continue block38;
                    }
                    ParsingPreprocessor.checkAllowedFunctionality(ParsingPreprocessor.ALLOW_LINE_BOUNDARY, "Line Boundary ^");
                    continue block38;
                }
                case '$': {
                    if (i == regexArr.length - 1 && currentLevel == 0) {
                        ++i;
                        continue block38;
                    }
                    ParsingPreprocessor.checkAllowedFunctionality(ParsingPreprocessor.ALLOW_LINE_BOUNDARY, "Line Boundary $");
                    continue block38;
                }
            }
            escapedSequence = "" + regexArr[i];
            escapeFactor = new SingleFactor(escapedSequence);
            tokenStream.add(escapeFactor);
            ++i;
        }
        return tokenStream;
    }

    protected void addRule(PreprocessorRule rule) {
        this.rules.add(rule);
    }

    private static boolean canEscapeVerbatim(String symbol) {
        return !canEscapeVerbatimRegex.matcher(symbol).find();
    }

    private static void checkAllowedFunctionality(boolean isHandled, String message) {
        if (!isHandled) {
            throw new RuntimeException("Unhandled Functionality: " + message);
        }
    }

    public static void main(String[] args) {
        List<RegexToken> tokenStream = ParsingPreprocessor.tokenize("\\x{FFFF}+", 0);
        System.out.println(tokenStream);
        for (RegexToken rt : tokenStream) {
            System.out.print(rt.getRepresentation());
        }
    }

    private static class RegexException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public RegexException(String message) {
            super(message);
        }
    }

    static class SingleFactor
    extends RegexFactor<String> {
        public SingleFactor(String factorContent) {
            super(factorContent);
        }

        @Override
        public RegexFactor.FactorType getFactorType() {
            return RegexFactor.FactorType.SINGLE_CHARACTER;
        }

        public String toString() {
            return (String)this.factorContent;
        }

        @Override
        public String getRepresentation() {
            return (String)this.factorContent;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof SingleFactor)) {
                return false;
            }
            SingleFactor sf = (SingleFactor)o;
            return ((String)sf.factorContent).equals(this.factorContent);
        }

        public int hashCode() {
            return ((String)this.factorContent).hashCode() * 13;
        }
    }

    static class EscapeFactor
    extends RegexFactor<String> {
        private final EscapeType type;

        public EscapeType getEscapeType() {
            return this.type;
        }

        public EscapeFactor(String factorContent, EscapeType type) {
            super(factorContent);
            this.type = type;
        }

        @Override
        public RegexFactor.FactorType getFactorType() {
            return RegexFactor.FactorType.ESCAPED_CHARACTER;
        }

        public String toString() {
            return (String)this.factorContent;
        }

        @Override
        public String getRepresentation() {
            return (String)this.factorContent;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof EscapeFactor)) {
                return false;
            }
            EscapeFactor ef = (EscapeFactor)o;
            return ((String)ef.factorContent).equals(this.factorContent);
        }

        public int hashCode() {
            return this.type.hashCode() * 13 + ((String)this.factorContent).hashCode();
        }

        public static enum EscapeType {
            CHARACTER,
            OCTAL,
            UNICODE,
            HEX,
            VERBATIM,
            CHARACTER_PROPERTY;

        }
    }

    static class GroupFactor
    extends RegexFactor<List<RegexToken>> {
        private int level;
        private GroupType groupType;

        public int getLevel() {
            return this.level;
        }

        public GroupFactor(List<RegexToken> factorContent, GroupType groupType) {
            super(factorContent);
            this.groupType = groupType;
        }

        public GroupFactor(String processedContent, GroupType groupType, int level) {
            super(ParsingPreprocessor.tokenize(processedContent, level + 1));
            this.level = level;
            this.groupType = groupType;
        }

        @Override
        public RegexFactor.FactorType getFactorType() {
            return RegexFactor.FactorType.GROUP;
        }

        public GroupType getGroupType() {
            return this.groupType;
        }

        private String groupPrefix() {
            switch (this.groupType) {
                case NORMAL: {
                    return "";
                }
                case NONCAPTURING: {
                    return "?:";
                }
                case POSLOOKAHEAD: {
                    return "?=";
                }
                case POSLOOKBEHIND: {
                    return "?<=";
                }
                case NEGLOOKAHEAD: {
                    return "?!";
                }
                case NEGLOOKBEHIND: {
                    return "?<!";
                }
            }
            throw new AssertionError((Object)"Unknown group type.");
        }

        public String toString() {
            String type = this.groupPrefix();
            return "Group( " + type + " " + this.factorContent + " )";
        }

        @Override
        public String getRepresentation() {
            String type = this.groupPrefix();
            StringBuilder contentBuilder = new StringBuilder();
            for (RegexToken rt : (List)this.factorContent) {
                contentBuilder.append(rt.getRepresentation());
            }
            return "(" + type + contentBuilder.toString() + ")";
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof GroupFactor)) {
                return false;
            }
            GroupFactor ro = (GroupFactor)o;
            return ((List)ro.factorContent).equals(this.factorContent);
        }

        public int hashCode() {
            return this.groupType.hashCode() * 13 + ((List)this.factorContent).hashCode();
        }

        public static enum GroupType {
            NORMAL,
            NONCAPTURING,
            POSLOOKAHEAD,
            POSLOOKBEHIND,
            NEGLOOKAHEAD,
            NEGLOOKBEHIND;

        }
    }

    static class CharacterClassFactor
    extends RegexFactor<String> {
        public CharacterClassFactor(String factorContent) {
            super(factorContent);
        }

        @Override
        public RegexFactor.FactorType getFactorType() {
            return RegexFactor.FactorType.CHARACTER_CLASS;
        }

        public String toString() {
            return "[" + (String)this.factorContent + "]";
        }

        @Override
        public String getRepresentation() {
            return "[" + (String)this.factorContent + "]";
        }
    }

    static class WildCardFactor
    extends RegexFactor<String> {
        public WildCardFactor() {
            super(".");
        }

        @Override
        public RegexFactor.FactorType getFactorType() {
            return RegexFactor.FactorType.WILD_CARD;
        }

        public String toString() {
            return (String)this.factorContent;
        }

        @Override
        public String getRepresentation() {
            return (String)this.factorContent;
        }
    }

    static class CountClosureOperator
    extends QuantifiableOperator {
        private final int low;
        private final int high;
        private final BoundsType boundsType;

        public int getLow() {
            return this.low;
        }

        public int getHigh() {
            return this.high;
        }

        public BoundsType getBoundsType() {
            return this.boundsType;
        }

        public CountClosureOperator(String operatorSequence, QuantifiableOperator.Quantifier quantifier, int low, int high) {
            super(operatorSequence, RegexOperator.OperatorType.COUNT, quantifier);
            this.low = low;
            this.high = high;
            this.boundsType = BoundsType.BOUNDED;
        }

        public CountClosureOperator(String operatorSequence, QuantifiableOperator.Quantifier quantifier, int low, BoundsType boundsType) {
            super(operatorSequence, RegexOperator.OperatorType.COUNT, quantifier);
            this.low = low;
            switch (boundsType) {
                case UNBOUNDED: {
                    this.high = Integer.MAX_VALUE;
                    break;
                }
                case CONSTANT_REPETITION: {
                    this.high = low;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Upper bounds needs to be specified.");
                }
            }
            this.boundsType = boundsType;
        }

        public static enum BoundsType {
            BOUNDED,
            UNBOUNDED,
            CONSTANT_REPETITION;

        }
    }

    static class QuantifiableOperator
    extends RegexOperator {
        private Quantifier quantifier;

        public Quantifier getOperatorQuantifier() {
            return this.quantifier;
        }

        public QuantifiableOperator(String operatorSequence, RegexOperator.OperatorType operatorType, Quantifier quantifier) {
            super(operatorSequence, operatorType);
            this.quantifier = quantifier;
        }

        public QuantifiableOperator(String operatorSequence, RegexOperator.OperatorType operatorType) {
            super(operatorSequence, operatorType);
            this.quantifier = Quantifier.GREEDY;
        }

        @Override
        public boolean getIsQuantifiable() {
            return true;
        }

        public void setOperatorQuantifier(Quantifier quantifier) {
            this.quantifier = quantifier;
        }

        @Override
        public String toString() {
            String q = "";
            switch (this.quantifier) {
                case GREEDY: {
                    q = "G";
                    break;
                }
                case POSSESIVE: {
                    q = "P";
                    break;
                }
                case RELUCTANT: {
                    q = "R";
                }
            }
            return q + "QO( " + this.operatorSequence + " )";
        }

        public static enum Quantifier {
            GREEDY,
            POSSESIVE,
            RELUCTANT;

        }
    }

    static class RegexOperator
    implements RegexToken {
        protected final String operatorSequence;
        private final OperatorType operatorType;

        public String getOperator() {
            return this.operatorSequence;
        }

        public RegexOperator(String operatorSequence, OperatorType operatorType) {
            this.operatorSequence = operatorSequence;
            this.operatorType = operatorType;
        }

        public boolean getIsQuantifiable() {
            return false;
        }

        public OperatorType getOperatorType() {
            return this.operatorType;
        }

        @Override
        public RegexToken.TokenType getTokenType() {
            return RegexToken.TokenType.REGEX_OPERATOR;
        }

        public String toString() {
            return "O( " + this.operatorSequence + " )";
        }

        @Override
        public String getRepresentation() {
            return this.operatorSequence;
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            if (o == this) {
                return true;
            }
            if (!(o instanceof RegexOperator)) {
                return false;
            }
            RegexOperator ro = (RegexOperator)o;
            return ro.operatorSequence.equals(this.operatorSequence);
        }

        public int hashCode() {
            return this.operatorSequence.hashCode();
        }

        public static enum OperatorType {
            PLUS,
            STAR,
            QM,
            COUNT,
            OR;

        }
    }

    static abstract class RegexFactor<FactorContentType>
    implements RegexToken {
        protected FactorContentType factorContent;

        public FactorContentType getFactorContent() {
            return this.factorContent;
        }

        public RegexFactor(FactorContentType factorContent) {
            this.factorContent = factorContent;
        }

        @Override
        public RegexToken.TokenType getTokenType() {
            return RegexToken.TokenType.REGEX_FACTOR;
        }

        public abstract FactorType getFactorType();

        public static enum FactorType {
            CHARACTER_CLASS,
            SINGLE_CHARACTER,
            ESCAPED_CHARACTER,
            GROUP,
            WILD_CARD;

        }
    }

    static interface RegexToken {
        public TokenType getTokenType();

        public String getRepresentation();

        public static enum TokenType {
            REGEX_FACTOR,
            REGEX_OPERATOR;

        }
    }
}

