/*
 * Decompiled with CFR 0.152.
 */
package regexcompiler;

import java.util.HashMap;
import java.util.Iterator;
import nfa.NFAEdge;
import nfa.NFAGraph;
import nfa.NFAVertexND;
import nfa.transitionlabel.EpsilonTransitionLabel;
import nfa.transitionlabel.TransitionLabel;
import nfa.transitionlabel.TransitionLabelParserRecursive;
import regexcompiler.ParseTreeToNFAConverter;
import regexcompiler.RegexCountClosureOperator;
import regexcompiler.RegexQuantifiableOperator;

public class JavaParseTreeToNFAConverter
extends ParseTreeToNFAConverter {
    @Override
    public NFAGraph createBaseCaseEmpty() {
        NFAGraph m = new NFAGraph();
        NFAVertexND q0 = this.nextState();
        NFAVertexND q1 = this.nextState();
        m.addVertex(q0);
        m.addVertex(q1);
        m.setInitialState(q0);
        m.addAcceptingState(q1);
        return m;
    }

    @Override
    public NFAGraph createBaseCaseLookAround(NFAVertexND lookAroundState) {
        NFAGraph m = new NFAGraph();
        NFAVertexND q0 = this.nextState();
        NFAVertexND q1 = this.nextState();
        m.addVertex(q0);
        m.addVertex(lookAroundState);
        m.addVertex(q1);
        m.addEdge(new NFAEdge(q0, lookAroundState, new EpsilonTransitionLabel("\u03b51")));
        m.addEdge(new NFAEdge(lookAroundState, q1, new EpsilonTransitionLabel("\u03b51")));
        m.setInitialState(q0);
        m.addAcceptingState(q1);
        return m;
    }

    @Override
    public NFAGraph createBaseCaseEmptyString() {
        NFAGraph m = new NFAGraph();
        NFAVertexND q0 = this.nextState();
        NFAVertexND q1 = this.nextState();
        m.addVertex(q0);
        m.addVertex(q1);
        m.addEdge(new NFAEdge(q0, q1, new EpsilonTransitionLabel("\u03b51")));
        m.setInitialState(q0);
        m.addAcceptingState(q1);
        return m;
    }

    @Override
    public NFAGraph createBaseCaseSymbol(String symbol) {
        if (symbol.isEmpty()) {
            return this.createBaseCaseEmptyString();
        }
        TransitionLabelParserRecursive tlpr = new TransitionLabelParserRecursive(symbol);
        TransitionLabel transitionLabel = tlpr.parseTransitionLabel();
        NFAGraph m = new NFAGraph();
        NFAVertexND q0 = this.nextState();
        NFAVertexND q1 = this.nextState();
        m.addVertex(q0);
        m.addVertex(q1);
        if (!transitionLabel.isEmpty()) {
            m.addEdge(new NFAEdge(q0, q1, transitionLabel));
        }
        m.setInitialState(q0);
        m.addAcceptingState(q1);
        return m;
    }

    @Override
    public NFAGraph unionNFAs(NFAGraph m1, NFAGraph m2) {
        NFAVertexND target;
        NFAVertexND source;
        NFAGraph resultNFA = new NFAGraph();
        HashMap<NFAVertexND, NFAVertexND> stateMap = new HashMap<NFAVertexND, NFAVertexND>();
        assert (m1.getAcceptingStates().size() == 1) : "Construction assumes only one accept state";
        NFAVertexND m1AcceptState = m1.getAcceptingStates().iterator().next();
        for (NFAVertexND v : m1.vertexSet()) {
            resultNFA.addVertex(v);
        }
        NFAVertexND m2Acceptstate = null;
        assert (m2.getAcceptingStates().size() == 1) : "Construction assumes only one accept state";
        NFAVertexND m2OriginalAcceptState = m2.getAcceptingStates().iterator().next();
        int i = 0;
        Iterator iterator = m2.vertexSet().iterator();
        while (iterator.hasNext()) {
            NFAVertexND v;
            NFAVertexND newVertex = v = (NFAVertexND)iterator.next();
            String newName = "" + newVertex.getStateNumberByDimension(1).charAt(0);
            while (resultNFA.containsVertex(newVertex) || newVertex.equals(m2Acceptstate)) {
                newVertex = new NFAVertexND(newName + i);
                ++i;
            }
            if (!m2OriginalAcceptState.equals(v)) {
                resultNFA.addVertex(newVertex);
            } else {
                m2Acceptstate = newVertex;
            }
            stateMap.put(v, newVertex);
        }
        for (NFAEdge e : m1.edgeSet()) {
            source = e.getSourceVertex();
            target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        for (NFAEdge e : m2.edgeSet()) {
            source = (NFAVertexND)stateMap.get(e.getSourceVertex());
            target = (NFAVertexND)stateMap.get(e.getTargetVertex());
            if (!m2Acceptstate.equals(target)) {
                resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
                continue;
            }
            resultNFA.addEdge(new NFAEdge(source, m1AcceptState, e.getTransitionLabel()));
        }
        NFAVertexND newInitialVertex = new NFAVertexND("q0");
        while (resultNFA.containsVertex(newInitialVertex)) {
            newInitialVertex = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newInitialVertex);
        resultNFA.setInitialState(newInitialVertex);
        NFAVertexND m1InitialState = m1.getInitialState();
        NFAVertexND m2InitialState = (NFAVertexND)stateMap.get(m2.getInitialState());
        resultNFA.addEdge(new NFAEdge(newInitialVertex, m1InitialState, new EpsilonTransitionLabel("\u03b51")));
        resultNFA.addEdge(new NFAEdge(newInitialVertex, m2InitialState, new EpsilonTransitionLabel("\u03b52")));
        resultNFA.addAcceptingState(m1AcceptState);
        return resultNFA;
    }

    @Override
    public NFAGraph joinNFAs(NFAGraph m1, NFAGraph m2) {
        NFAVertexND target;
        NFAVertexND source;
        NFAGraph resultNFA = new NFAGraph();
        HashMap<NFAVertexND, NFAVertexND> stateMap = new HashMap<NFAVertexND, NFAVertexND>();
        for (NFAVertexND v : m1.vertexSet()) {
            resultNFA.addVertex(v);
        }
        NFAVertexND m2InitialState = null;
        int i = 0;
        Iterator iterator = m2.vertexSet().iterator();
        while (iterator.hasNext()) {
            NFAVertexND v;
            NFAVertexND newVertex = v = (NFAVertexND)iterator.next();
            String newName = "" + v.getStateNumberByDimension(1).charAt(0);
            while (resultNFA.containsVertex(newVertex) || newVertex.equals(m2InitialState)) {
                newVertex = new NFAVertexND(newName + i);
                ++i;
            }
            if (!m2.getInitialState().equals(v)) {
                resultNFA.addVertex(newVertex);
            } else {
                m2InitialState = newVertex;
            }
            stateMap.put(v, newVertex);
        }
        for (NFAEdge e : m1.edgeSet()) {
            source = e.getSourceVertex();
            target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        for (NFAEdge e : m2.edgeSet()) {
            NFAEdge newEdge;
            source = (NFAVertexND)stateMap.get(e.getSourceVertex());
            target = (NFAVertexND)stateMap.get(e.getTargetVertex());
            if (!m2InitialState.equals(source) && !m2InitialState.equals(target)) {
                NFAEdge newEdge2 = new NFAEdge(source, target, e.getTransitionLabel());
                resultNFA.addEdge(newEdge2);
                continue;
            }
            if (m2InitialState.equals(source)) {
                for (NFAVertexND m1AcceptingState : m1.getAcceptingStates()) {
                    newEdge = new NFAEdge(m1AcceptingState, target, e.getTransitionLabel());
                    resultNFA.addEdge(newEdge);
                }
                continue;
            }
            for (NFAVertexND m1AcceptingState : m1.getAcceptingStates()) {
                newEdge = new NFAEdge(source, m1AcceptingState, e.getTransitionLabel());
                resultNFA.addEdge(newEdge);
            }
        }
        NFAVertexND newInitialVertex = new NFAVertexND("q0");
        while (resultNFA.containsVertex(newInitialVertex)) {
            newInitialVertex = new NFAVertexND("q" + i);
            ++i;
        }
        resultNFA.addVertex(newInitialVertex);
        resultNFA.setInitialState(newInitialVertex);
        NFAVertexND oldInitialVertex = m1.getInitialState();
        resultNFA.addEdge(new NFAEdge(newInitialVertex, oldInitialVertex, new EpsilonTransitionLabel("\u03b51")));
        for (NFAVertexND v : m2.getAcceptingStates()) {
            v = (NFAVertexND)stateMap.get(v);
            resultNFA.addAcceptingState(v);
        }
        return resultNFA;
    }

    @Override
    public NFAGraph starNFA(NFAGraph m, RegexQuantifiableOperator.RegexStarOperator starOperator) {
        EpsilonTransitionLabel finishTransitionLabel;
        EpsilonTransitionLabel loopBackTransitionLabel;
        RegexQuantifiableOperator.QuantifierType quantifierType = starOperator.getQuantifierType();
        switch (quantifierType) {
            case GREEDY: {
                loopBackTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                break;
            }
            case RELUCTANT: {
                loopBackTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                break;
            }
            case POSSESSIVE: {
                throw new UnsupportedOperationException("Possessive quantifiers not implemented: " + (Object)((Object)quantifierType) + " in " + starOperator);
            }
            default: {
                throw new RuntimeException("Unknown quantifier: " + (Object)((Object)quantifierType) + " in " + starOperator);
            }
        }
        NFAGraph resultNFA = new NFAGraph();
        for (NFAVertexND v : m.vertexSet()) {
            resultNFA.addVertex(v);
        }
        for (NFAEdge e : m.edgeSet()) {
            NFAVertexND source = e.getSourceVertex();
            NFAVertexND target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        NFAVertexND mInitialState = m.getInitialState();
        if (m.getAcceptingStates().size() != 1) {
            throw new RuntimeException("Star construction only allows for one accept state");
        }
        NFAVertexND mAcceptState = m.getAcceptingStates().iterator().next();
        resultNFA.setInitialState(mAcceptState);
        resultNFA.addEdge(new NFAEdge(mAcceptState, mInitialState, loopBackTransitionLabel));
        String newName = "q";
        int i = 0;
        NFAVertexND newAcceptVertex = new NFAVertexND("q" + resultNFA.vertexSet().size());
        while (resultNFA.containsVertex(newAcceptVertex)) {
            newAcceptVertex = new NFAVertexND(newName + i);
            ++i;
        }
        resultNFA.addVertex(newAcceptVertex);
        resultNFA.addAcceptingState(newAcceptVertex);
        resultNFA.addEdge(new NFAEdge(mAcceptState, newAcceptVertex, finishTransitionLabel));
        return resultNFA;
    }

    @Override
    public NFAGraph plusNFA(NFAGraph m, RegexQuantifiableOperator.RegexPlusOperator plusOperator) {
        EpsilonTransitionLabel finishTransitionLabel;
        EpsilonTransitionLabel loopBackTransitionLabel;
        RegexQuantifiableOperator.QuantifierType quantifierType = plusOperator.getQuantifierType();
        switch (quantifierType) {
            case GREEDY: {
                loopBackTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                break;
            }
            case RELUCTANT: {
                loopBackTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                break;
            }
            case POSSESSIVE: {
                throw new UnsupportedOperationException("Possessive quantifiers not implemented: " + (Object)((Object)quantifierType) + " in " + plusOperator);
            }
            default: {
                throw new RuntimeException("Unknown quantifier: " + (Object)((Object)quantifierType) + " in " + plusOperator);
            }
        }
        NFAGraph resultNFA = new NFAGraph();
        for (NFAVertexND v : m.vertexSet()) {
            resultNFA.addVertex(v);
        }
        for (NFAEdge e : m.edgeSet()) {
            NFAVertexND source = e.getSourceVertex();
            NFAVertexND target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        NFAVertexND mInitialState = m.getInitialState();
        NFAVertexND newInitialState = this.deriveVertex(resultNFA, new NFAVertexND("q0"));
        resultNFA.addVertex(newInitialState);
        resultNFA.setInitialState(newInitialState);
        resultNFA.addEdge(new NFAEdge(newInitialState, mInitialState, new EpsilonTransitionLabel("\u03b51")));
        if (m.getAcceptingStates().size() != 1) {
            throw new RuntimeException("Plus construction only allows for one accept state");
        }
        NFAVertexND mAcceptState = m.getAcceptingStates().iterator().next();
        resultNFA.addEdge(new NFAEdge(mAcceptState, newInitialState, loopBackTransitionLabel));
        NFAVertexND newAcceptVertex = this.deriveVertex(resultNFA, new NFAVertexND("q" + resultNFA.vertexSet().size()));
        resultNFA.addVertex(newAcceptVertex);
        resultNFA.addAcceptingState(newAcceptVertex);
        resultNFA.addEdge(new NFAEdge(mAcceptState, newAcceptVertex, finishTransitionLabel));
        return resultNFA;
    }

    @Override
    public NFAGraph countClosureNFA(NFAGraph m, RegexCountClosureOperator countClosureOperator) {
        int numRepetitions;
        EpsilonTransitionLabel finishTransitionLabel;
        EpsilonTransitionLabel continueTransitionLabel;
        RegexQuantifiableOperator.QuantifierType quantifierType = countClosureOperator.getQuantifierType();
        int cmin = countClosureOperator.getLow();
        int cmax = countClosureOperator.getHigh();
        boolean bounded = cmax < Integer.MAX_VALUE;
        switch (quantifierType) {
            case GREEDY: {
                continueTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                break;
            }
            case RELUCTANT: {
                continueTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                break;
            }
            case POSSESSIVE: {
                throw new UnsupportedOperationException("Possessive quantifiers not implemented: " + (Object)((Object)quantifierType) + " in " + countClosureOperator);
            }
            default: {
                throw new RuntimeException("Unknown quantifier: " + (Object)((Object)quantifierType) + " in " + countClosureOperator);
            }
        }
        NFAGraph resultNFA = new NFAGraph();
        NFAVertexND newInitialVertex = this.deriveVertex(resultNFA, new NFAVertexND("q0"));
        resultNFA.addVertex(newInitialVertex);
        resultNFA.setInitialState(newInitialVertex);
        NFAVertexND newAcceptVertex = this.deriveVertex(resultNFA, new NFAVertexND("q" + resultNFA.vertexSet().size()));
        resultNFA.addVertex(newAcceptVertex);
        resultNFA.addAcceptingState(newAcceptVertex);
        if (cmin == 0) {
            NFAEdge newEdge;
            if (cmax > 0) {
                newEdge = new NFAEdge(newInitialVertex, newAcceptVertex, finishTransitionLabel);
                resultNFA.addEdge(newEdge);
            } else {
                newEdge = new NFAEdge(newInitialVertex, newAcceptVertex, new EpsilonTransitionLabel("\u03b51"));
                resultNFA.addEdge(newEdge);
            }
        }
        int n = numRepetitions = bounded ? cmax : cmin;
        if (!bounded && cmin == 0) {
            numRepetitions = 1;
        }
        NFAVertexND lastConnectingVertex = newInitialVertex;
        for (int i = 1; i <= numRepetitions; ++i) {
            NFAVertexND repetitionInitialVertex = null;
            NFAVertexND repetitionAcceptVertex = null;
            HashMap<NFAVertexND, NFAVertexND> stateMap = new HashMap<NFAVertexND, NFAVertexND>();
            for (NFAVertexND originalVertex : m.vertexSet()) {
                NFAVertexND newVertex = this.deriveVertex(resultNFA, originalVertex);
                stateMap.put(originalVertex, newVertex);
                resultNFA.addVertex(newVertex);
                if (m.getInitialState().equals(originalVertex)) {
                    repetitionInitialVertex = newVertex;
                }
                if (!m.isAcceptingState(originalVertex)) continue;
                repetitionAcceptVertex = newVertex;
            }
            assert (repetitionInitialVertex != null && repetitionAcceptVertex != null) : "NFA must have an initial and accept state.";
            for (NFAEdge e : m.edgeSet()) {
                NFAVertexND source = (NFAVertexND)stateMap.get(e.getSourceVertex());
                NFAVertexND target = (NFAVertexND)stateMap.get(e.getTargetVertex());
                NFAEdge newEdge = new NFAEdge(source, target, e.getTransitionLabel());
                resultNFA.addEdge(newEdge);
            }
            NFAEdge newEdge = new NFAEdge(lastConnectingVertex, repetitionInitialVertex, continueTransitionLabel);
            resultNFA.addEdge(newEdge);
            if (i >= cmin) {
                if (!bounded) {
                    newEdge = new NFAEdge(repetitionAcceptVertex, lastConnectingVertex, continueTransitionLabel);
                    resultNFA.addEdge(newEdge);
                }
                if ((bounded || cmin != 0) && i == numRepetitions) {
                    newEdge = new NFAEdge(repetitionAcceptVertex, newAcceptVertex, new EpsilonTransitionLabel("\u03b51"));
                    resultNFA.addEdge(newEdge);
                } else if (i < numRepetitions) {
                    newEdge = new NFAEdge(repetitionAcceptVertex, newAcceptVertex, finishTransitionLabel);
                    resultNFA.addEdge(newEdge);
                }
            }
            lastConnectingVertex = repetitionAcceptVertex;
        }
        return resultNFA;
    }

    @Override
    public NFAGraph questionMarkNFA(NFAGraph m, RegexQuantifiableOperator.RegexQuestionMarkOperator questionMarkOperator) {
        EpsilonTransitionLabel finishTransitionLabel;
        EpsilonTransitionLabel continueTransitionLabel;
        NFAGraph resultNFA = new NFAGraph();
        RegexQuantifiableOperator.QuantifierType quantifierType = questionMarkOperator.getQuantifierType();
        switch (quantifierType) {
            case GREEDY: {
                continueTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                break;
            }
            case RELUCTANT: {
                continueTransitionLabel = new EpsilonTransitionLabel("\u03b52");
                finishTransitionLabel = new EpsilonTransitionLabel("\u03b51");
                break;
            }
            case POSSESSIVE: {
                throw new UnsupportedOperationException("Possessive quantifiers not implemented: " + (Object)((Object)quantifierType) + " in " + questionMarkOperator);
            }
            default: {
                throw new RuntimeException("Unknown quantifier: " + (Object)((Object)quantifierType) + " in " + questionMarkOperator);
            }
        }
        assert (m.getAcceptingStates().size() == 1) : "Construction assumes only one accept state";
        NFAVertexND mAcceptState = m.getAcceptingStates().iterator().next();
        for (NFAVertexND v : m.vertexSet()) {
            resultNFA.addVertex(v);
        }
        for (NFAEdge e : m.edgeSet()) {
            NFAVertexND source = e.getSourceVertex();
            NFAVertexND target = e.getTargetVertex();
            resultNFA.addEdge(new NFAEdge(source, target, e.getTransitionLabel()));
        }
        String newName = "q";
        int i = 0;
        NFAVertexND newInitialVertex = new NFAVertexND("q0");
        while (resultNFA.containsVertex(newInitialVertex)) {
            newInitialVertex = new NFAVertexND(newName + i);
            ++i;
        }
        resultNFA.addVertex(newInitialVertex);
        resultNFA.setInitialState(newInitialVertex);
        NFAVertexND m1InitialState = m.getInitialState();
        resultNFA.addEdge(new NFAEdge(newInitialVertex, m1InitialState, continueTransitionLabel));
        resultNFA.addEdge(new NFAEdge(newInitialVertex, mAcceptState, finishTransitionLabel));
        resultNFA.addAcceptingState(mAcceptState);
        return resultNFA;
    }
}

