/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartCurrentInstallationController;
import co.easimart.EasimartException;
import co.easimart.EasimartExecutors;
import co.easimart.EasimartInstallation;
import co.easimart.EasimartLog;
import co.easimart.EasimartObject;
import co.easimart.EasimartObjectStore;
import co.easimart.EasimartTaskUtils;
import co.easimart.InstallationId;
import co.easimart.TaskQueue;

class CachedCurrentInstallationController
implements EasimartCurrentInstallationController {
    static final String TAG = "co.easimart.CachedCurrentInstallationController";
    private final Object mutex = new Object();
    private final TaskQueue taskQueue = new TaskQueue();
    private final EasimartObjectStore<EasimartInstallation> store;
    private final InstallationId installationId;
    EasimartInstallation currentInstallation;

    public CachedCurrentInstallationController(EasimartObjectStore<EasimartInstallation> store, InstallationId installationId) {
        this.store = store;
        this.installationId = installationId;
    }

    @Override
    public Task<Void> setAsync(final EasimartInstallation installation) {
        if (!this.isCurrent(installation)) {
            return Task.forResult(null);
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return CachedCurrentInstallationController.this.store.setAsync(installation);
                    }
                }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        CachedCurrentInstallationController.this.installationId.set(installation.getInstallationId());
                        return task;
                    }
                }, EasimartExecutors.io());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task<EasimartInstallation> getAsync() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentInstallation != null) {
                return Task.forResult((Object)this.currentInstallation);
            }
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<EasimartInstallation>>(){

            public Task<EasimartInstallation> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<EasimartInstallation>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<EasimartInstallation> then(Task<Void> task) throws Exception {
                        Object object = CachedCurrentInstallationController.this.mutex;
                        synchronized (object) {
                            if (CachedCurrentInstallationController.this.currentInstallation != null) {
                                return Task.forResult((Object)CachedCurrentInstallationController.this.currentInstallation);
                            }
                        }
                        return CachedCurrentInstallationController.this.store.getAsync().continueWith((Continuation)new Continuation<EasimartInstallation, EasimartInstallation>(){

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            public EasimartInstallation then(Task<EasimartInstallation> task) throws Exception {
                                EasimartInstallation current = (EasimartInstallation)task.getResult();
                                if (current == null) {
                                    current = EasimartObject.create(EasimartInstallation.class);
                                    current.updateDeviceInfo(CachedCurrentInstallationController.this.installationId);
                                } else {
                                    CachedCurrentInstallationController.this.installationId.set(current.getInstallationId());
                                    EasimartLog.v(CachedCurrentInstallationController.TAG, "Successfully deserialized Installation object");
                                }
                                Object object = CachedCurrentInstallationController.this.mutex;
                                synchronized (object) {
                                    CachedCurrentInstallationController.this.currentInstallation = current;
                                }
                                return current;
                            }
                        }, EasimartExecutors.io());
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Task<Boolean> existsAsync() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.currentInstallation != null) {
                return Task.forResult((Object)true);
            }
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<Boolean>>(){

            public Task<Boolean> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Boolean>>(){

                    public Task<Boolean> then(Task<Void> task) throws Exception {
                        return CachedCurrentInstallationController.this.store.existsAsync();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFromMemory() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentInstallation = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFromDisk() {
        Object object = this.mutex;
        synchronized (object) {
            this.currentInstallation = null;
        }
        try {
            this.installationId.clear();
            EasimartTaskUtils.wait(this.store.deleteAsync());
        }
        catch (EasimartException easimartException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCurrent(EasimartInstallation installation) {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentInstallation == installation;
        }
    }
}

