/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.content.Intent;
import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartAnalyticsController;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartLog;
import co.easimart.EasimartTaskUtils;
import co.easimart.EasimartUser;
import co.easimart.NoObjectsEncoder;
import co.easimart.SaveCallback;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class EasimartAnalytics {
    private static final String TAG = "co.easimart.EasimartAnalytics";
    private static final Map<String, Boolean> lruSeenPushes = new LinkedHashMap<String, Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, Boolean> eldest) {
            return this.size() > 10;
        }
    };

    static EasimartAnalyticsController getAnalyticsController() {
        return EasimartCorePlugins.getInstance().getAnalyticsController();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Task<Void> trackAppOpenedInBackground(Intent intent) {
        String pushHashStr = EasimartAnalytics.getPushHashFromIntent(intent);
        final Capture pushHash = new Capture();
        if (pushHashStr != null && pushHashStr.length() > 0) {
            Map<String, Boolean> map = lruSeenPushes;
            synchronized (map) {
                if (lruSeenPushes.containsKey(pushHashStr)) {
                    return Task.forResult(null);
                }
                lruSeenPushes.put(pushHashStr, true);
                pushHash.set((Object)pushHashStr);
            }
        }
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return EasimartAnalytics.getAnalyticsController().trackAppOpenedInBackground((String)pushHash.get(), sessionToken);
            }
        });
    }

    @Deprecated
    public static void trackAppOpened(Intent intent) {
        EasimartAnalytics.trackAppOpenedInBackground(intent);
    }

    public static void trackAppOpenedInBackground(Intent intent, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartAnalytics.trackAppOpenedInBackground(intent), callback);
    }

    @Deprecated
    public static void trackEvent(String name) {
        EasimartAnalytics.trackEventInBackground(name);
    }

    public static void trackEventInBackground(String name, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartAnalytics.trackEventInBackground(name), callback);
    }

    @Deprecated
    public static void trackEvent(String name, Map<String, String> dimensions) {
        EasimartAnalytics.trackEventInBackground(name, dimensions);
    }

    public static void trackEventInBackground(String name, Map<String, String> dimensions, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartAnalytics.trackEventInBackground(name, dimensions), callback);
    }

    public static Task<Void> trackEventInBackground(String name) {
        return EasimartAnalytics.trackEventInBackground(name, (Map<String, String>)null);
    }

    public static Task<Void> trackEventInBackground(final String name, Map<String, String> dimensions) {
        if (name == null || name.trim().length() == 0) {
            throw new IllegalArgumentException("A name for the custom event must be provided.");
        }
        final JSONObject jsonDimensions = dimensions != null ? (JSONObject)NoObjectsEncoder.get().encode(dimensions) : null;
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return EasimartAnalytics.getAnalyticsController().trackEventInBackground(name, jsonDimensions, sessionToken);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void clear() {
        Map<String, Boolean> map = lruSeenPushes;
        synchronized (map) {
            lruSeenPushes.clear();
        }
    }

    static String getPushHashFromIntent(Intent intent) {
        String pushData = null;
        if (intent != null && intent.getExtras() != null) {
            pushData = intent.getExtras().getString("co.easimart.Data");
        }
        if (pushData == null) {
            return null;
        }
        String pushHash = null;
        try {
            JSONObject payload = new JSONObject(pushData);
            pushHash = payload.optString("push_hash");
        }
        catch (JSONException e) {
            EasimartLog.e(TAG, "Failed to parse push data: " + e.getMessage());
        }
        return pushHash;
    }
}

