/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.ConfigCallback;
import co.easimart.EasimartConfigController;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartException;
import co.easimart.EasimartFile;
import co.easimart.EasimartGeoPoint;
import co.easimart.EasimartTaskUtils;
import co.easimart.EasimartUser;
import co.easimart.PointerEncoder;
import co.easimart.TaskQueue;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

public class EasimartConfig {
    static final TaskQueue taskQueue = new TaskQueue();
    final Map<String, Object> params;

    static EasimartConfigController getConfigController() {
        return EasimartCorePlugins.getInstance().getConfigController();
    }

    public static EasimartConfig getCurrentConfig() {
        try {
            return EasimartTaskUtils.wait(EasimartConfig.getConfigController().getCurrentConfigController().getCurrentConfigAsync());
        }
        catch (EasimartException e) {
            return new EasimartConfig();
        }
    }

    public static EasimartConfig get() throws EasimartException {
        return EasimartTaskUtils.wait(EasimartConfig.getInBackground());
    }

    public static void getInBackground(ConfigCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartConfig.getInBackground(), callback);
    }

    public static Task<EasimartConfig> getInBackground() {
        return taskQueue.enqueue(new Continuation<Void, Task<EasimartConfig>>(){

            public Task<EasimartConfig> then(Task<Void> toAwait) throws Exception {
                return EasimartConfig.getAsync((Task<Void>)toAwait);
            }
        });
    }

    private static Task<EasimartConfig> getAsync(final Task<Void> toAwait) {
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<EasimartConfig>>(){

            public Task<EasimartConfig> then(Task<String> task) throws Exception {
                final String sessionToken = (String)task.getResult();
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<EasimartConfig>>(){

                    public Task<EasimartConfig> then(Task<Void> task) throws Exception {
                        return EasimartConfig.getConfigController().getAsync(sessionToken);
                    }
                });
            }
        });
    }

    EasimartConfig(JSONObject object, EasimartDecoder decoder) {
        Map decodedObject = (Map)decoder.decode(object);
        Map decodedParams = (Map)decodedObject.get("params");
        if (decodedParams == null) {
            throw new RuntimeException("Object did not contain the 'params' key.");
        }
        this.params = Collections.unmodifiableMap(decodedParams);
    }

    EasimartConfig() {
        this.params = Collections.unmodifiableMap(new HashMap());
    }

    Map<String, Object> getParams() {
        return Collections.unmodifiableMap(new HashMap<String, Object>(this.params));
    }

    public Object get(String key) {
        return this.get(key, null);
    }

    public Object get(String key, Object defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == JSONObject.NULL) {
            return null;
        }
        return this.params.get(key);
    }

    public boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public boolean getBoolean(String key, boolean defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        return value instanceof Boolean ? (Boolean)value : defaultValue;
    }

    public Date getDate(String key) {
        return this.getDate(key, null);
    }

    public Date getDate(String key, Date defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof Date ? (Date)value : defaultValue;
    }

    public double getDouble(String key) {
        return this.getDouble(key, 0.0);
    }

    public double getDouble(String key, double defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.doubleValue() : defaultValue;
    }

    public int getInt(String key) {
        return this.getInt(key, 0);
    }

    public int getInt(String key, int defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.intValue() : defaultValue;
    }

    public JSONArray getJSONArray(String key) {
        return this.getJSONArray(key, null);
    }

    public JSONArray getJSONArray(String key, JSONArray defaultValue) {
        List list = this.getList(key);
        Object encoded = list != null ? PointerEncoder.get().encode(list) : null;
        return encoded == null || encoded instanceof JSONArray ? (JSONArray)encoded : defaultValue;
    }

    public JSONObject getJSONObject(String key) {
        return this.getJSONObject(key, null);
    }

    public JSONObject getJSONObject(String key, JSONObject defaultValue) {
        Map map = this.getMap(key);
        Object encoded = map != null ? PointerEncoder.get().encode(map) : null;
        return encoded == null || encoded instanceof JSONObject ? (JSONObject)encoded : defaultValue;
    }

    public <T> List<T> getList(String key) {
        return this.getList(key, null);
    }

    public <T> List<T> getList(String key, List<T> defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        List returnValue = value instanceof List ? (List)value : defaultValue;
        return returnValue;
    }

    public long getLong(String key) {
        return this.getLong(key, 0L);
    }

    public long getLong(String key, long defaultValue) {
        Number number = this.getNumber(key);
        return number != null ? number.longValue() : defaultValue;
    }

    public <V> Map<String, V> getMap(String key) {
        return this.getMap(key, null);
    }

    public <V> Map<String, V> getMap(String key, Map<String, V> defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        Map returnValue = value instanceof Map ? (Map)value : defaultValue;
        return returnValue;
    }

    public Number getNumber(String key) {
        return this.getNumber(key, null);
    }

    public Number getNumber(String key, Number defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof Number ? (Number)((Number)value) : (Number)defaultValue;
    }

    public EasimartFile getEasimartFile(String key) {
        return this.getEasimartFile(key, null);
    }

    public EasimartFile getEasimartFile(String key, EasimartFile defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof EasimartFile ? (EasimartFile)value : defaultValue;
    }

    public EasimartGeoPoint getEasimartGeoPoint(String key) {
        return this.getEasimartGeoPoint(key, null);
    }

    public EasimartGeoPoint getEasimartGeoPoint(String key, EasimartGeoPoint defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof EasimartGeoPoint ? (EasimartGeoPoint)value : defaultValue;
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String defaultValue) {
        if (!this.params.containsKey(key)) {
            return defaultValue;
        }
        Object value = this.params.get(key);
        if (value == null || value == JSONObject.NULL) {
            return null;
        }
        return value instanceof String ? (String)value : defaultValue;
    }

    public String toString() {
        return "EasimartConfig[" + this.params.toString() + "]";
    }
}

