/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartConfig;
import co.easimart.EasimartCurrentConfigController;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartRESTConfigCommand;
import org.json.JSONObject;

class EasimartConfigController {
    private EasimartCurrentConfigController currentConfigController;
    private final EasimartHttpClient restClient;

    public EasimartConfigController(EasimartHttpClient restClient, EasimartCurrentConfigController currentConfigController) {
        this.restClient = restClient;
        this.currentConfigController = currentConfigController;
    }

    EasimartCurrentConfigController getCurrentConfigController() {
        return this.currentConfigController;
    }

    public Task<EasimartConfig> getAsync(String sessionToken) {
        EasimartRESTConfigCommand command = EasimartRESTConfigCommand.fetchConfigCommand(sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.restClient).onSuccessTask((Continuation)new Continuation<JSONObject, Task<EasimartConfig>>(){

            public Task<EasimartConfig> then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                final EasimartConfig config = new EasimartConfig(result, EasimartDecoder.get());
                return EasimartConfigController.this.currentConfigController.setCurrentConfigAsync(config).continueWith((Continuation)new Continuation<Void, EasimartConfig>(){

                    public EasimartConfig then(Task<Void> task) throws Exception {
                        return config;
                    }
                });
            }
        });
    }
}

