/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartByteArrayHttpBody;
import co.easimart.ProgressCallback;
import java.io.IOException;
import java.io.OutputStream;

class EasimartCountingByteArrayHttpBody
extends EasimartByteArrayHttpBody {
    private static final int DEFAULT_CHUNK_SIZE = 4096;
    private final ProgressCallback progressCallback;

    public EasimartCountingByteArrayHttpBody(byte[] content, String contentType, ProgressCallback progressCallback) {
        super(content, contentType);
        this.progressCallback = progressCallback;
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream may not be null");
        }
        int position = 0;
        int totalLength = this.content.length;
        while (position < totalLength) {
            int length = Math.min(totalLength - position, 4096);
            out.write(this.content, position, length);
            out.flush();
            if (this.progressCallback == null) continue;
            int progress = 100 * (position += length) / totalLength;
            this.progressCallback.done(progress);
        }
    }
}

