/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.util.Base64;
import co.easimart.EasimartACL;
import co.easimart.EasimartDateFormat;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartFile;
import co.easimart.EasimartGeoPoint;
import co.easimart.EasimartObject;
import co.easimart.EasimartQuery;
import co.easimart.EasimartRelation;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

abstract class EasimartEncoder {
    EasimartEncoder() {
    }

    static boolean isValidType(Object value) {
        return value instanceof JSONObject || value instanceof JSONArray || value instanceof String || value instanceof Number || value instanceof Boolean || value == JSONObject.NULL || value instanceof EasimartObject || value instanceof EasimartACL || value instanceof EasimartFile || value instanceof EasimartGeoPoint || value instanceof Date || value instanceof byte[] || value instanceof List || value instanceof Map || value instanceof EasimartRelation;
    }

    public Object encode(Object object) {
        try {
            if (object instanceof EasimartObject) {
                return this.encodeRelatedObject((EasimartObject)object);
            }
            if (object instanceof EasimartQuery.State.Builder) {
                EasimartQuery.State.Builder builder = (EasimartQuery.State.Builder)object;
                return this.encode(builder.build());
            }
            if (object instanceof EasimartQuery.State) {
                EasimartQuery.State state = (EasimartQuery.State)object;
                return state.toJSON(this);
            }
            if (object instanceof Date) {
                return this.encodeDate((Date)object);
            }
            if (object instanceof byte[]) {
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"Bytes");
                json.put("base64", (Object)Base64.encodeToString((byte[])((byte[])object), (int)2));
                return json;
            }
            if (object instanceof EasimartFile) {
                return ((EasimartFile)object).encode();
            }
            if (object instanceof EasimartGeoPoint) {
                EasimartGeoPoint point = (EasimartGeoPoint)object;
                JSONObject json = new JSONObject();
                json.put("__type", (Object)"GeoPoint");
                json.put("latitude", point.getLatitude());
                json.put("longitude", point.getLongitude());
                return json;
            }
            if (object instanceof EasimartACL) {
                EasimartACL acl = (EasimartACL)object;
                return acl.toJSONObject(this);
            }
            if (object instanceof Map) {
                Map map = (Map)object;
                JSONObject json = new JSONObject();
                for (Map.Entry pair : map.entrySet()) {
                    json.put((String)pair.getKey(), this.encode(pair.getValue()));
                }
                return json;
            }
            if (object instanceof JSONObject) {
                JSONObject map = (JSONObject)object;
                JSONObject json = new JSONObject();
                Iterator keys = map.keys();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    json.put(key, this.encode(map.opt(key)));
                }
                return json;
            }
            if (object instanceof Collection) {
                JSONArray array = new JSONArray();
                for (Object item : (Collection)object) {
                    array.put(this.encode(item));
                }
                return array;
            }
            if (object instanceof JSONArray) {
                JSONArray array = (JSONArray)object;
                JSONArray json = new JSONArray();
                for (int i = 0; i < array.length(); ++i) {
                    json.put(this.encode(array.opt(i)));
                }
                return json;
            }
            if (object instanceof EasimartRelation) {
                EasimartRelation relation = (EasimartRelation)object;
                return relation.encodeToJSON(this);
            }
            if (object instanceof EasimartFieldOperation) {
                return ((EasimartFieldOperation)object).encode(this);
            }
            if (object instanceof EasimartQuery.RelationConstraint) {
                return ((EasimartQuery.RelationConstraint)object).encode(this);
            }
            if (object == null) {
                return JSONObject.NULL;
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        if (EasimartEncoder.isValidType(object)) {
            return object;
        }
        throw new IllegalArgumentException("invalid type for EasimartObject: " + object.getClass().toString());
    }

    protected abstract JSONObject encodeRelatedObject(EasimartObject var1);

    protected JSONObject encodeDate(Date date) {
        JSONObject object = new JSONObject();
        String iso = EasimartDateFormat.getInstance().format(date);
        try {
            object.put("__type", (Object)"Date");
            object.put("iso", (Object)iso);
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        return object;
    }
}

