/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.text.TextUtils;
import bolts.Continuation;
import bolts.Task;
import co.easimart.Easimart;
import co.easimart.EasimartClassName;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartCurrentInstallationController;
import co.easimart.EasimartException;
import co.easimart.EasimartLog;
import co.easimart.EasimartObject;
import co.easimart.EasimartOperationSet;
import co.easimart.EasimartPlugins;
import co.easimart.EasimartQuery;
import co.easimart.EasimartTaskUtils;
import co.easimart.InstallationId;
import co.easimart.PushType;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;

@EasimartClassName(value="_Installation")
public class EasimartInstallation
extends EasimartObject {
    private static final String TAG = "co.easimart.EasimartInstallation";
    private static final String KEY_INSTALLATION_ID = "installationId";
    private static final String KEY_DEVICE_TYPE = "deviceType";
    private static final String KEY_APP_NAME = "appName";
    private static final String KEY_APP_IDENTIFIER = "appIdentifier";
    private static final String KEY_EASIMART_VERSION = "parseVersion";
    private static final String KEY_DEVICE_TOKEN = "deviceToken";
    private static final String KEY_PUSH_TYPE = "pushType";
    private static final String KEY_TIME_ZONE = "timeZone";
    private static final String KEY_LOCALE = "localeIdentifier";
    private static final String KEY_APP_VERSION = "appVersion";
    static final String KEY_CHANNELS = "channels";
    private static final List<String> READ_ONLY_FIELDS = Collections.unmodifiableList(Arrays.asList("deviceType", "installationId", "deviceToken", "pushType", "timeZone", "localeIdentifier", "appVersion", "appName", "parseVersion", "appIdentifier"));

    static EasimartCurrentInstallationController getCurrentInstallationController() {
        return EasimartCorePlugins.getInstance().getCurrentInstallationController();
    }

    public static EasimartInstallation getCurrentInstallation() {
        try {
            return (EasimartInstallation)EasimartTaskUtils.wait(EasimartInstallation.getCurrentInstallationController().getAsync());
        }
        catch (EasimartException e) {
            return null;
        }
    }

    public static EasimartQuery<EasimartInstallation> getQuery() {
        return EasimartQuery.getQuery(EasimartInstallation.class);
    }

    public String getInstallationId() {
        return this.getString(KEY_INSTALLATION_ID);
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_FIELDS.contains(key);
    }

    @Override
    void updateBeforeSave() {
        super.updateBeforeSave();
        if (EasimartInstallation.getCurrentInstallationController().isCurrent(this)) {
            this.updateTimezone();
            this.updateVersionInfo();
            this.updateDeviceInfo();
            this.updateLocaleIdentifier();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    <T extends EasimartObject> Task<T> fetchAsync(final String sessionToken, final Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            Task<Void> result = this.getObjectId() == null ? this.saveAsync(sessionToken, toAwait) : Task.forResult(null);
            return result.onSuccessTask(new Continuation<Void, Task<T>>(){

                public Task<T> then(Task<Void> task) throws Exception {
                    return EasimartInstallation.access$001(EasimartInstallation.this, sessionToken, toAwait);
                }
            });
        }
    }

    @Override
    Task<Void> handleSaveResultAsync(EasimartObject.State result, EasimartOperationSet operationsBeforeSave) {
        Task<Void> task = super.handleSaveResultAsync(result, operationsBeforeSave);
        if (result == null) {
            return task;
        }
        return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return EasimartInstallation.getCurrentInstallationController().setAsync(EasimartInstallation.this);
            }
        });
    }

    @Override
    Task<Void> handleFetchResultAsync(EasimartObject.State newState) {
        return super.handleFetchResultAsync(newState).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return EasimartInstallation.getCurrentInstallationController().setAsync(EasimartInstallation.this);
            }
        });
    }

    private void updateTimezone() {
        String zone = TimeZone.getDefault().getID();
        if ((zone.indexOf(47) > 0 || zone.equals("GMT")) && !zone.equals(this.get(KEY_TIME_ZONE))) {
            this.performPut(KEY_TIME_ZONE, zone);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateVersionInfo() {
        Object object = this.mutex;
        synchronized (object) {
            try {
                Context context = Easimart.getApplicationContext();
                String packageName = context.getPackageName();
                PackageManager pm = context.getPackageManager();
                PackageInfo pkgInfo = pm.getPackageInfo(packageName, 0);
                String appVersion = pkgInfo.versionName;
                String appName = pm.getApplicationLabel(pm.getApplicationInfo(packageName, 0)).toString();
                if (packageName != null && !packageName.equals(this.get(KEY_APP_IDENTIFIER))) {
                    this.performPut(KEY_APP_IDENTIFIER, packageName);
                }
                if (appName != null && !appName.equals(this.get(KEY_APP_NAME))) {
                    this.performPut(KEY_APP_NAME, appName);
                }
                if (appVersion != null && !appVersion.equals(this.get(KEY_APP_VERSION))) {
                    this.performPut(KEY_APP_VERSION, appVersion);
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                EasimartLog.w(TAG, "Cannot load package info; will not be saved to installation");
            }
            if (!"1.11.1-SNAPSHOT".equals(this.get(KEY_EASIMART_VERSION))) {
                this.performPut(KEY_EASIMART_VERSION, "1.11.1-SNAPSHOT");
            }
        }
    }

    private void updateLocaleIdentifier() {
        Locale locale = Locale.getDefault();
        String language = locale.getLanguage();
        String country = locale.getCountry();
        if (TextUtils.isEmpty((CharSequence)language)) {
            return;
        }
        if (language.equals("iw")) {
            language = "he";
        }
        if (language.equals("in")) {
            language = "id";
        }
        if (language.equals("ji")) {
            language = "yi";
        }
        String localeString = language;
        if (!TextUtils.isEmpty((CharSequence)country)) {
            localeString = String.format(Locale.US, "%s-%s", language, country);
        }
        if (!localeString.equals(this.get(KEY_LOCALE))) {
            this.performPut(KEY_LOCALE, localeString);
        }
    }

    void updateDeviceInfo() {
        this.updateDeviceInfo(EasimartPlugins.get().installationId());
    }

    void updateDeviceInfo(InstallationId installationId) {
        String deviceType;
        if (!this.has(KEY_INSTALLATION_ID)) {
            this.performPut(KEY_INSTALLATION_ID, installationId.get());
        }
        if (!(deviceType = "android").equals(this.get(KEY_DEVICE_TYPE))) {
            this.performPut(KEY_DEVICE_TYPE, deviceType);
        }
    }

    PushType getPushType() {
        return PushType.fromString(super.getString(KEY_PUSH_TYPE));
    }

    void setPushType(PushType pushType) {
        if (pushType != null) {
            this.performPut(KEY_PUSH_TYPE, pushType.toString());
        }
    }

    void removePushType() {
        this.performRemove(KEY_PUSH_TYPE);
    }

    String getDeviceToken() {
        return super.getString(KEY_DEVICE_TOKEN);
    }

    void setDeviceToken(String deviceToken) {
        if (deviceToken != null && deviceToken.length() > 0) {
            this.performPut(KEY_DEVICE_TOKEN, deviceToken);
        }
    }

    void removeDeviceToken() {
        this.performRemove(KEY_DEVICE_TOKEN);
    }

    static /* synthetic */ Task access$001(EasimartInstallation x0, String x1, Task x2) {
        return super.fetchAsync(x1, (Task<Void>)x2);
    }
}

