/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import bolts.Capture;
import co.easimart.EasimartByteArrayHttpBody;
import co.easimart.EasimartHttpClient;
import co.easimart.http.EasimartHttpBody;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import co.easimart.http.EasimartNetworkInterceptor;
import com.squareup.okhttp.Call;
import com.squareup.okhttp.Headers;
import com.squareup.okhttp.Interceptor;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import com.squareup.okhttp.Response;
import com.squareup.okhttp.ResponseBody;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import okio.BufferedSink;
import okio.BufferedSource;
import okio.Okio;
import okio.Source;

class EasimartOkHttpClient
extends EasimartHttpClient<Request, Response> {
    private static final String OKHTTP_GET = "GET";
    private static final String OKHTTP_POST = "POST";
    private static final String OKHTTP_PUT = "PUT";
    private static final String OKHTTP_DELETE = "DELETE";
    private OkHttpClient okHttpClient = new OkHttpClient();

    public EasimartOkHttpClient(int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        this.okHttpClient.setConnectTimeout((long)socketOperationTimeout, TimeUnit.MILLISECONDS);
        this.okHttpClient.setReadTimeout((long)socketOperationTimeout, TimeUnit.MILLISECONDS);
        this.okHttpClient.setFollowRedirects(false);
        this.okHttpClient.setSslSocketFactory(SSLCertificateSocketFactory.getDefault((int)socketOperationTimeout, (SSLSessionCache)sslSessionCache));
    }

    @Override
    EasimartHttpResponse executeInternal(EasimartHttpRequest parseRequest) throws IOException {
        Request okHttpRequest = this.getRequest(parseRequest);
        Call okHttpCall = this.okHttpClient.newCall(okHttpRequest);
        Response okHttpResponse = okHttpCall.execute();
        return this.getResponse(okHttpResponse);
    }

    @Override
    EasimartHttpResponse getResponse(Response okHttpResponse) throws IOException {
        int statusCode = okHttpResponse.code();
        InputStream content = okHttpResponse.body().byteStream();
        int totalSize = (int)okHttpResponse.body().contentLength();
        String reasonPhrase = okHttpResponse.message();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (String name : okHttpResponse.headers().names()) {
            headers.put(name, okHttpResponse.header(name));
        }
        String contentType = null;
        ResponseBody body = okHttpResponse.body();
        if (body != null && body.contentType() != null) {
            contentType = body.contentType().toString();
        }
        return new EasimartHttpResponse.Builder().setStatusCode(statusCode).setContent(content).setTotalSize(totalSize).setReasonPhrase(reasonPhrase).setHeaders(headers).setContentType(contentType).build();
    }

    @Override
    Request getRequest(EasimartHttpRequest httpRequest) throws IOException {
        Request.Builder okHttpRequestBuilder = new Request.Builder();
        EasimartHttpRequest.Method method = httpRequest.getMethod();
        switch (method) {
            case GET: {
                okHttpRequestBuilder.get();
                break;
            }
            case DELETE: {
                okHttpRequestBuilder.delete();
                break;
            }
            case POST: 
            case PUT: {
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported http method " + method.toString());
            }
        }
        okHttpRequestBuilder.url(httpRequest.getUrl());
        Headers.Builder okHttpHeadersBuilder = new Headers.Builder();
        for (Map.Entry<String, String> entry : httpRequest.getAllHeaders().entrySet()) {
            okHttpHeadersBuilder.add(entry.getKey(), entry.getValue());
        }
        Headers okHttpHeaders = okHttpHeadersBuilder.build();
        okHttpRequestBuilder.headers(okHttpHeaders);
        EasimartHttpBody parseBody = httpRequest.getBody();
        EasimartOkHttpRequestBody okHttpRequestBody = null;
        if (parseBody instanceof EasimartByteArrayHttpBody) {
            okHttpRequestBody = new EasimartOkHttpRequestBody(parseBody);
        }
        switch (method) {
            case PUT: {
                okHttpRequestBuilder.put((RequestBody)okHttpRequestBody);
                break;
            }
            case POST: {
                okHttpRequestBuilder.post((RequestBody)okHttpRequestBody);
            }
        }
        return okHttpRequestBuilder.build();
    }

    /*
     * WARNING - void declaration
     */
    private EasimartHttpRequest getEasimartHttpRequest(Request okHttpRequest) {
        void var4_9;
        EasimartHttpRequest.Builder parseRequestBuilder = new EasimartHttpRequest.Builder();
        String string = okHttpRequest.method();
        int n = -1;
        switch (string.hashCode()) {
            case 70454: {
                if (!string.equals(OKHTTP_GET)) break;
                boolean bl = false;
                break;
            }
            case 2012838315: {
                if (!string.equals(OKHTTP_DELETE)) break;
                boolean bl = true;
                break;
            }
            case 2461856: {
                if (!string.equals(OKHTTP_POST)) break;
                int n2 = 2;
                break;
            }
            case 79599: {
                if (!string.equals(OKHTTP_PUT)) break;
                int n3 = 3;
            }
        }
        switch (var4_9) {
            case 0: {
                parseRequestBuilder.setMethod(EasimartHttpRequest.Method.GET);
                break;
            }
            case 1: {
                parseRequestBuilder.setMethod(EasimartHttpRequest.Method.DELETE);
                break;
            }
            case 2: {
                parseRequestBuilder.setMethod(EasimartHttpRequest.Method.POST);
                break;
            }
            case 3: {
                parseRequestBuilder.setMethod(EasimartHttpRequest.Method.PUT);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid http method " + okHttpRequest.method());
            }
        }
        parseRequestBuilder.setUrl(okHttpRequest.urlString());
        for (Map.Entry entry : okHttpRequest.headers().toMultimap().entrySet()) {
            parseRequestBuilder.addHeader((String)entry.getKey(), (String)((List)entry.getValue()).get(0));
        }
        EasimartOkHttpRequestBody okHttpBody = (EasimartOkHttpRequestBody)okHttpRequest.body();
        if (okHttpBody != null) {
            parseRequestBuilder.setBody(okHttpBody.getEasimartHttpBody());
        }
        return parseRequestBuilder.build();
    }

    @Override
    void addExternalInterceptor(final EasimartNetworkInterceptor easimartNetworkInterceptor) {
        this.okHttpClient.networkInterceptors().add(new Interceptor(){

            public Response intercept(final Interceptor.Chain okHttpChain) throws IOException {
                Request okHttpRequest = okHttpChain.request();
                final EasimartHttpRequest parseRequest = EasimartOkHttpClient.this.getEasimartHttpRequest(okHttpRequest);
                final Capture okHttpResponseCapture = new Capture();
                final EasimartHttpResponse parseResponse = easimartNetworkInterceptor.intercept(new EasimartNetworkInterceptor.Chain(){

                    @Override
                    public EasimartHttpRequest getRequest() {
                        return parseRequest;
                    }

                    @Override
                    public EasimartHttpResponse proceed(EasimartHttpRequest request) throws IOException {
                        Request okHttpRequest = EasimartOkHttpClient.this.getRequest(request);
                        Response okHttpResponse = okHttpChain.proceed(okHttpRequest);
                        okHttpResponseCapture.set((Object)okHttpResponse);
                        return EasimartOkHttpClient.this.getResponse(okHttpResponse);
                    }
                });
                Response okHttpResponse = (Response)okHttpResponseCapture.get();
                Response.Builder newOkHttpResponseBuilder = okHttpResponse.newBuilder();
                newOkHttpResponseBuilder.code(parseResponse.getStatusCode()).message(parseResponse.getReasonPhrase());
                if (parseResponse.getAllHeaders() != null) {
                    for (Map.Entry<String, String> entry : parseResponse.getAllHeaders().entrySet()) {
                        newOkHttpResponseBuilder.header(entry.getKey(), entry.getValue());
                    }
                }
                newOkHttpResponseBuilder.body(new ResponseBody(){

                    public MediaType contentType() {
                        if (parseResponse.getContentType() == null) {
                            return null;
                        }
                        return MediaType.parse((String)parseResponse.getContentType());
                    }

                    public long contentLength() throws IOException {
                        return parseResponse.getTotalSize();
                    }

                    public BufferedSource source() throws IOException {
                        if (parseResponse.getContent() == null) {
                            return null;
                        }
                        return Okio.buffer((Source)Okio.source((InputStream)parseResponse.getContent()));
                    }
                });
                return newOkHttpResponseBuilder.build();
            }
        });
    }

    private static class EasimartOkHttpRequestBody
    extends RequestBody {
        private EasimartHttpBody parseBody;

        public EasimartOkHttpRequestBody(EasimartHttpBody parseBody) {
            this.parseBody = parseBody;
        }

        public long contentLength() throws IOException {
            return this.parseBody.getContentLength();
        }

        public MediaType contentType() {
            String contentType = this.parseBody.getContentType();
            return contentType == null ? null : MediaType.parse((String)this.parseBody.getContentType());
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            this.parseBody.writeTo(bufferedSink.outputStream());
        }

        public EasimartHttpBody getEasimartHttpBody() {
            return this.parseBody;
        }
    }
}

