/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.content.Context;
import android.content.Intent;
import bolts.Continuation;
import bolts.Task;
import co.easimart.ConnectivityNotifier;
import co.easimart.Easimart;
import co.easimart.EasimartEventuallyQueue;
import co.easimart.EasimartException;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartLog;
import co.easimart.EasimartObject;
import co.easimart.EasimartOperationSet;
import co.easimart.EasimartRESTCommand;
import co.easimart.EasimartTaskUtils;
import co.easimart.EventuallyPin;
import co.easimart.TaskQueue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.json.JSONObject;

class EasimartPinningEventuallyQueue
extends EasimartEventuallyQueue {
    private static final String TAG = "EasimartPinningEventuallyQueue";
    private HashMap<String, Task.TaskCompletionSource> pendingOperationSetUUIDTasks = new HashMap();
    private TaskQueue taskQueue = new TaskQueue();
    private TaskQueue operationSetTaskQueue = new TaskQueue();
    private ArrayList<String> eventuallyPinUUIDQueue = new ArrayList();
    private Task.TaskCompletionSource connectionTaskCompletionSource = Task.create();
    private final Object connectionLock = new Object();
    private final EasimartHttpClient httpClient;
    private ConnectivityNotifier notifier;
    private ConnectivityNotifier.ConnectivityListener listener = new ConnectivityNotifier.ConnectivityListener(){

        @Override
        public void networkConnectivityStatusChanged(Context context, Intent intent) {
            boolean connectionLost = intent.getBooleanExtra("noConnectivity", false);
            if (connectionLost) {
                EasimartPinningEventuallyQueue.this.setConnected(false);
            } else {
                EasimartPinningEventuallyQueue.this.setConnected(ConnectivityNotifier.isConnected(context));
            }
        }
    };
    private final Object taskQueueSyncLock = new Object();
    private HashMap<String, Task.TaskCompletionSource> pendingEventuallyTasks = new HashMap();
    private HashMap<String, EasimartOperationSet> uuidToOperationSet = new HashMap();
    private HashMap<String, EventuallyPin> uuidToEventuallyPin = new HashMap();

    public EasimartPinningEventuallyQueue(Context context, EasimartHttpClient client) {
        this.setConnected(ConnectivityNotifier.isConnected(context));
        this.httpClient = client;
        this.notifier = ConnectivityNotifier.getNotifier(context);
        this.notifier.addListener(this.listener);
        this.resume();
    }

    @Override
    public void onDestroy() {
        this.notifier.removeListener(this.listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setConnected(boolean connected) {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.isConnected() != connected) {
                super.setConnected(connected);
                if (connected) {
                    this.connectionTaskCompletionSource.trySetResult(null);
                    this.connectionTaskCompletionSource = Task.create();
                    this.connectionTaskCompletionSource.trySetResult(null);
                } else {
                    this.connectionTaskCompletionSource = Task.create();
                }
            }
        }
    }

    @Override
    public int pendingCount() {
        try {
            return EasimartTaskUtils.wait(this.pendingCountAsync());
        }
        catch (EasimartException e) {
            throw new IllegalStateException(e);
        }
    }

    public Task<Integer> pendingCountAsync() {
        final Task.TaskCompletionSource tcs = Task.create();
        this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return EasimartPinningEventuallyQueue.this.pendingCountAsync(toAwait).continueWithTask((Continuation)new Continuation<Integer, Task<Void>>(){

                    public Task<Void> then(Task<Integer> task) throws Exception {
                        int count = (Integer)task.getResult();
                        tcs.setResult((Object)count);
                        return Task.forResult(null);
                    }
                });
            }
        });
        return tcs.getTask();
    }

    public Task<Integer> pendingCountAsync(Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Integer>>(){

            public Task<Integer> then(Task<Void> task) throws Exception {
                return EventuallyPin.findAllPinned().continueWithTask((Continuation)new Continuation<List<EventuallyPin>, Task<Integer>>(){

                    public Task<Integer> then(Task<List<EventuallyPin>> task) throws Exception {
                        List pins = (List)task.getResult();
                        return Task.forResult((Object)pins.size());
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pause() {
        Object object = this.connectionLock;
        synchronized (object) {
            this.connectionTaskCompletionSource.trySetError((Exception)new PauseException());
            this.connectionTaskCompletionSource = Task.create();
            this.connectionTaskCompletionSource.trySetError((Exception)new PauseException());
        }
        object = this.taskQueueSyncLock;
        synchronized (object) {
            for (String key : this.pendingEventuallyTasks.keySet()) {
                this.pendingEventuallyTasks.get(key).trySetError((Exception)new PauseException());
            }
            this.pendingEventuallyTasks.clear();
            this.uuidToOperationSet.clear();
            this.uuidToEventuallyPin.clear();
        }
        try {
            EasimartTaskUtils.wait(this.whenAll(Arrays.asList(this.taskQueue, this.operationSetTaskQueue)));
        }
        catch (EasimartException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void resume() {
        if (this.isConnected()) {
            this.connectionTaskCompletionSource.trySetResult(null);
            this.connectionTaskCompletionSource = Task.create();
            this.connectionTaskCompletionSource.trySetResult(null);
        } else {
            this.connectionTaskCompletionSource = Task.create();
        }
        this.populateQueueAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> waitForConnectionAsync() {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.connectionTaskCompletionSource.getTask();
        }
    }

    @Override
    public Task<JSONObject> enqueueEventuallyAsync(final EasimartRESTCommand command, final EasimartObject object) {
        Easimart.requirePermission("android.permission.ACCESS_NETWORK_STATE");
        final Task.TaskCompletionSource tcs = Task.create();
        this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return EasimartPinningEventuallyQueue.this.enqueueEventuallyAsync(command, object, (Task<Void>)toAwait, tcs);
            }
        });
        return tcs.getTask();
    }

    private Task<Void> enqueueEventuallyAsync(final EasimartRESTCommand command, final EasimartObject object, Task<Void> toAwait, final Task.TaskCompletionSource tcs) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                Task<EventuallyPin> pinTask = EventuallyPin.pinEventuallyCommand(object, command);
                return pinTask.continueWithTask((Continuation)new Continuation<EventuallyPin, Task<Void>>(){

                    public Task<Void> then(Task<EventuallyPin> task) throws Exception {
                        EventuallyPin pin = (EventuallyPin)task.getResult();
                        Exception error = task.getError();
                        if (error != null) {
                            if (5 >= Easimart.getLogLevel()) {
                                EasimartLog.w(EasimartPinningEventuallyQueue.TAG, "Unable to save command for later.", error);
                            }
                            EasimartPinningEventuallyQueue.this.notifyTestHelper(4);
                            return Task.forResult(null);
                        }
                        EasimartPinningEventuallyQueue.this.pendingOperationSetUUIDTasks.put(pin.getUUID(), tcs);
                        EasimartPinningEventuallyQueue.this.populateQueueAsync().continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                EasimartPinningEventuallyQueue.this.notifyTestHelper(3);
                                return task;
                            }
                        });
                        return task.makeVoid();
                    }
                });
            }
        });
    }

    private Task<Void> populateQueueAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return EasimartPinningEventuallyQueue.this.populateQueueAsync((Task<Void>)toAwait);
            }
        });
    }

    private Task<Void> populateQueueAsync(Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<List<EventuallyPin>>>(){

            public Task<List<EventuallyPin>> then(Task<Void> task) throws Exception {
                return EventuallyPin.findAllPinned(EasimartPinningEventuallyQueue.this.eventuallyPinUUIDQueue);
            }
        }).onSuccessTask((Continuation)new Continuation<List<EventuallyPin>, Task<Void>>(){

            public Task<Void> then(Task<List<EventuallyPin>> task) throws Exception {
                List pins = (List)task.getResult();
                for (EventuallyPin pin : pins) {
                    EasimartPinningEventuallyQueue.this.runEventuallyAsync(pin);
                }
                return task.makeVoid();
            }
        });
    }

    private Task<Void> runEventuallyAsync(final EventuallyPin eventuallyPin) {
        final String uuid = eventuallyPin.getUUID();
        if (this.eventuallyPinUUIDQueue.contains(uuid)) {
            return Task.forResult(null);
        }
        this.eventuallyPinUUIDQueue.add(uuid);
        this.operationSetTaskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return EasimartPinningEventuallyQueue.this.runEventuallyAsync(eventuallyPin, (Task<Void>)toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        EasimartPinningEventuallyQueue.this.eventuallyPinUUIDQueue.remove(uuid);
                        return task;
                    }
                });
            }
        });
        return Task.forResult(null);
    }

    private Task<Void> runEventuallyAsync(final EventuallyPin eventuallyPin, Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return EasimartPinningEventuallyQueue.this.waitForConnectionAsync();
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return EasimartPinningEventuallyQueue.this.waitForOperationSetAndEventuallyPin(null, eventuallyPin).continueWithTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

                    public Task<Void> then(Task<JSONObject> task) throws Exception {
                        Exception error = task.getError();
                        if (error != null) {
                            if (error instanceof PauseException) {
                                return task.makeVoid();
                            }
                            if (6 >= Easimart.getLogLevel()) {
                                EasimartLog.e(EasimartPinningEventuallyQueue.TAG, "Failed to run command.", error);
                            }
                            EasimartPinningEventuallyQueue.this.notifyTestHelper(2, error);
                        } else {
                            EasimartPinningEventuallyQueue.this.notifyTestHelper(1);
                        }
                        Task.TaskCompletionSource tcs = (Task.TaskCompletionSource)EasimartPinningEventuallyQueue.this.pendingOperationSetUUIDTasks.remove(eventuallyPin.getUUID());
                        if (tcs != null) {
                            if (error != null) {
                                tcs.setError(error);
                            } else {
                                tcs.setResult(task.getResult());
                            }
                        }
                        return task.makeVoid();
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Task<JSONObject> waitForOperationSetAndEventuallyPin(EasimartOperationSet operationSet, EventuallyPin eventuallyPin) {
        Task.TaskCompletionSource tcs;
        String uuid;
        if (eventuallyPin != null && eventuallyPin.getType() != 1) {
            return this.process(eventuallyPin, null);
        }
        Object object = this.taskQueueSyncLock;
        synchronized (object) {
            if (operationSet != null && eventuallyPin == null) {
                uuid = operationSet.getUUID();
                this.uuidToOperationSet.put(uuid, operationSet);
            } else if (operationSet == null && eventuallyPin != null) {
                uuid = eventuallyPin.getOperationSetUUID();
                this.uuidToEventuallyPin.put(uuid, eventuallyPin);
            } else {
                throw new IllegalStateException("Either operationSet or eventuallyPin must be set.");
            }
            eventuallyPin = this.uuidToEventuallyPin.get(uuid);
            operationSet = this.uuidToOperationSet.get(uuid);
            if (eventuallyPin == null || operationSet == null) {
                Task.TaskCompletionSource tcs2;
                if (this.pendingEventuallyTasks.containsKey(uuid)) {
                    tcs2 = this.pendingEventuallyTasks.get(uuid);
                } else {
                    tcs2 = Task.create();
                    this.pendingEventuallyTasks.put(uuid, tcs2);
                }
                return tcs2.getTask();
            }
            tcs = this.pendingEventuallyTasks.get(uuid);
        }
        return this.process(eventuallyPin, operationSet).continueWithTask((Continuation)new Continuation<JSONObject, Task<JSONObject>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<JSONObject> then(Task<JSONObject> task) throws Exception {
                Object object = EasimartPinningEventuallyQueue.this.taskQueueSyncLock;
                synchronized (object) {
                    EasimartPinningEventuallyQueue.this.pendingEventuallyTasks.remove(uuid);
                    EasimartPinningEventuallyQueue.this.uuidToOperationSet.remove(uuid);
                    EasimartPinningEventuallyQueue.this.uuidToEventuallyPin.remove(uuid);
                }
                Exception error = task.getError();
                if (error != null) {
                    tcs.trySetError(error);
                } else if (task.isCancelled()) {
                    tcs.trySetCancelled();
                } else {
                    tcs.trySetResult(task.getResult());
                }
                return tcs.getTask();
            }
        });
    }

    private Task<JSONObject> process(final EventuallyPin eventuallyPin, final EasimartOperationSet operationSet) {
        return this.waitForConnectionAsync().onSuccessTask((Continuation)new Continuation<Void, Task<JSONObject>>(){

            public Task<JSONObject> then(Task<Void> task) throws Exception {
                Task executeTask;
                final int type = eventuallyPin.getType();
                final EasimartObject object = eventuallyPin.getObject();
                String sessionToken = eventuallyPin.getSessionToken();
                if (type == 1) {
                    executeTask = object.saveAsync(EasimartPinningEventuallyQueue.this.httpClient, operationSet, sessionToken);
                } else if (type == 2) {
                    executeTask = object.deleteAsync(sessionToken).cast();
                } else {
                    EasimartRESTCommand command = eventuallyPin.getCommand();
                    if (command == null) {
                        executeTask = Task.forResult(null);
                        EasimartPinningEventuallyQueue.this.notifyTestHelper(8);
                    } else {
                        executeTask = command.executeAsync(EasimartPinningEventuallyQueue.this.httpClient);
                    }
                }
                return executeTask.continueWithTask((Continuation)new Continuation<JSONObject, Task<JSONObject>>(){

                    public Task<JSONObject> then(final Task<JSONObject> executeTask) throws Exception {
                        Exception error = executeTask.getError();
                        if (error != null && error instanceof EasimartException && ((EasimartException)error).getCode() == 100) {
                            EasimartPinningEventuallyQueue.this.setConnected(false);
                            EasimartPinningEventuallyQueue.this.notifyTestHelper(7);
                            return EasimartPinningEventuallyQueue.this.process(eventuallyPin, operationSet);
                        }
                        return eventuallyPin.unpinInBackground("_eventuallyPin").continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(Task<Void> task) throws Exception {
                                JSONObject result = (JSONObject)executeTask.getResult();
                                if (type == 1) {
                                    return object.handleSaveEventuallyResultAsync(result, operationSet);
                                }
                                if (type == 2) {
                                    if (executeTask.isFaulted()) {
                                        return task;
                                    }
                                    return object.handleDeleteEventuallyResultAsync();
                                }
                                return task;
                            }
                        }).continueWithTask((Continuation)new Continuation<Void, Task<JSONObject>>(){

                            public Task<JSONObject> then(Task<Void> task) throws Exception {
                                return executeTask;
                            }
                        });
                    }
                });
            }
        });
    }

    @Override
    void simulateReboot() {
        this.pause();
        this.pendingOperationSetUUIDTasks.clear();
        this.pendingEventuallyTasks.clear();
        this.uuidToOperationSet.clear();
        this.uuidToEventuallyPin.clear();
        this.resume();
    }

    @Override
    public void clear() {
        this.pause();
        Task<Void> task = this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        return EventuallyPin.findAllPinned().onSuccessTask((Continuation)new Continuation<List<EventuallyPin>, Task<Void>>(){

                            public Task<Void> then(Task<List<EventuallyPin>> task) throws Exception {
                                List pins = (List)task.getResult();
                                ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
                                for (EventuallyPin pin : pins) {
                                    tasks.add(pin.unpinInBackground("_eventuallyPin"));
                                }
                                return Task.whenAll(tasks);
                            }
                        });
                    }
                });
            }
        });
        try {
            EasimartTaskUtils.wait(task);
        }
        catch (EasimartException e) {
            throw new IllegalStateException(e);
        }
        this.simulateReboot();
        this.resume();
    }

    private Task<Void> whenAll(Collection<TaskQueue> taskQueues) {
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
        for (TaskQueue taskQueue : taskQueues) {
            Task<Void> task = taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> toAwait) throws Exception {
                    return toAwait;
                }
            });
            tasks.add(task);
        }
        return Task.whenAll(tasks);
    }

    private static class PauseException
    extends Exception {
        private PauseException() {
        }
    }
}

