/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.content.Context;
import android.content.pm.PackageManager;
import android.net.SSLSessionCache;
import android.os.Build;
import co.easimart.Easimart;
import co.easimart.EasimartHttpClient;
import co.easimart.InstallationId;
import co.easimart.ManifestInfo;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import co.easimart.http.EasimartNetworkInterceptor;
import java.io.File;
import java.io.IOException;

class EasimartPlugins {
    private static final String INSTALLATION_ID_LOCATION = "installationId";
    private static final Object LOCK = new Object();
    private static EasimartPlugins instance;
    final Object lock = new Object();
    private final String applicationId;
    private final String clientKey;
    private EasimartHttpClient restClient;
    private InstallationId installationId;
    File parseDir;
    File cacheDir;
    File filesDir;

    static void initialize(String applicationId, String clientKey) {
        EasimartPlugins.set(new EasimartPlugins(applicationId, clientKey));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void set(EasimartPlugins plugins) {
        Object object = LOCK;
        synchronized (object) {
            if (instance != null) {
                throw new IllegalStateException("EasimartPlugins is already initialized");
            }
            instance = plugins;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static EasimartPlugins get() {
        Object object = LOCK;
        synchronized (object) {
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reset() {
        Object object = LOCK;
        synchronized (object) {
            instance = null;
        }
    }

    private EasimartPlugins(String applicationId, String clientKey) {
        this.applicationId = applicationId;
        this.clientKey = clientKey;
    }

    String applicationId() {
        return this.applicationId;
    }

    String clientKey() {
        return this.clientKey;
    }

    EasimartHttpClient newHttpClient() {
        int socketOperationTimeout = 10000;
        return EasimartHttpClient.createClient(socketOperationTimeout, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EasimartHttpClient restClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.restClient == null) {
                this.restClient = this.newHttpClient();
                this.restClient.addInternalInterceptor(new EasimartNetworkInterceptor(){

                    @Override
                    public EasimartHttpResponse intercept(EasimartNetworkInterceptor.Chain chain) throws IOException {
                        EasimartHttpRequest request = chain.getRequest();
                        EasimartHttpRequest.Builder builder = new EasimartHttpRequest.Builder(request).addHeader("X-Easimart-Application-Id", EasimartPlugins.this.applicationId).addHeader("X-Easimart-Client-Key", EasimartPlugins.this.clientKey).addHeader("X-Easimart-Client-Version", Easimart.externalVersionName()).addHeader("X-Easimart-App-Build-Version", String.valueOf(ManifestInfo.getVersionCode())).addHeader("X-Easimart-App-Display-Version", ManifestInfo.getVersionName()).addHeader("X-Easimart-OS-Version", Build.VERSION.RELEASE).addHeader("User-Agent", EasimartPlugins.this.userAgent());
                        if (request.getHeader("X-Easimart-Installation-Id") == null) {
                            builder.addHeader("X-Easimart-Installation-Id", EasimartPlugins.this.installationId().get());
                        }
                        return chain.proceed(builder.build());
                    }
                });
            }
            return this.restClient;
        }
    }

    String userAgent() {
        return "Easimart Java SDK";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstallationId installationId() {
        Object object = this.lock;
        synchronized (object) {
            if (this.installationId == null) {
                this.installationId = new InstallationId(new File(this.getEasimartDir(), INSTALLATION_ID_LOCATION));
            }
            return this.installationId;
        }
    }

    @Deprecated
    File getEasimartDir() {
        throw new IllegalStateException("Stub");
    }

    File getCacheDir() {
        throw new IllegalStateException("Stub");
    }

    File getFilesDir() {
        throw new IllegalStateException("Stub");
    }

    private static File createFileDir(File file) {
        if (!file.exists() && !file.mkdirs()) {
            return file;
        }
        return file;
    }

    static class Android
    extends EasimartPlugins {
        private final Context applicationContext;

        static void initialize(Context context, String applicationId, String clientKey) {
            EasimartPlugins.set(new Android(context, applicationId, clientKey));
        }

        static Android get() {
            return (Android)EasimartPlugins.get();
        }

        private Android(Context context, String applicationId, String clientKey) {
            super(applicationId, clientKey);
            this.applicationContext = context.getApplicationContext();
        }

        Context applicationContext() {
            return this.applicationContext;
        }

        @Override
        public EasimartHttpClient newHttpClient() {
            SSLSessionCache sslSessionCache = new SSLSessionCache(this.applicationContext);
            int socketOperationTimeout = 10000;
            return EasimartHttpClient.createClient(socketOperationTimeout, sslSessionCache);
        }

        @Override
        String userAgent() {
            String packageVersion = "unknown";
            try {
                String packageName = this.applicationContext.getPackageName();
                int versionCode = this.applicationContext.getPackageManager().getPackageInfo((String)packageName, (int)0).versionCode;
                packageVersion = packageName + "/" + versionCode;
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
            return "Easimart Android SDK 1.11.1-SNAPSHOT (" + packageVersion + ") API Level " + Build.VERSION.SDK_INT;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getEasimartDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.parseDir == null) {
                    this.parseDir = this.applicationContext.getDir("Easimart", 0);
                }
                return EasimartPlugins.createFileDir(this.parseDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getCacheDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.cacheDir == null) {
                    this.cacheDir = new File(this.applicationContext.getCacheDir(), "co.easimart");
                }
                return EasimartPlugins.createFileDir(this.cacheDir);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        File getFilesDir() {
            Object object = this.lock;
            synchronized (object) {
                if (this.filesDir == null) {
                    this.filesDir = new File(this.applicationContext.getFilesDir(), "co.easimart");
                }
                return EasimartPlugins.createFileDir(this.filesDir);
            }
        }
    }
}

