/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartByteArrayHttpBody;
import co.easimart.EasimartCountingByteArrayHttpBody;
import co.easimart.EasimartCountingFileHttpBody;
import co.easimart.EasimartFileHttpBody;
import co.easimart.EasimartRESTCommand;
import co.easimart.ProgressCallback;
import co.easimart.http.EasimartHttpBody;
import co.easimart.http.EasimartHttpRequest;
import java.io.File;

class EasimartRESTFileCommand
extends EasimartRESTCommand {
    private final byte[] data;
    private final String contentType;
    private final File file;

    public EasimartRESTFileCommand(Builder builder) {
        super(builder);
        if (builder.file != null && builder.data != null) {
            throw new IllegalArgumentException("File and data can not be set at the same time");
        }
        this.data = builder.data;
        this.contentType = builder.contentType;
        this.file = builder.file;
    }

    @Override
    protected EasimartHttpBody newBody(ProgressCallback progressCallback) {
        if (progressCallback == null) {
            return this.data != null ? new EasimartByteArrayHttpBody(this.data, this.contentType) : new EasimartFileHttpBody(this.file, this.contentType);
        }
        return this.data != null ? new EasimartCountingByteArrayHttpBody(this.data, this.contentType, progressCallback) : new EasimartCountingFileHttpBody(this.file, this.contentType, progressCallback);
    }

    public static class Builder
    extends EasimartRESTCommand.Init<Builder> {
        private byte[] data = null;
        private String contentType = null;
        private File file;

        public Builder() {
            this.method(EasimartHttpRequest.Method.POST);
        }

        public Builder fileName(String fileName) {
            return (Builder)this.httpPath(String.format("files/%s", fileName));
        }

        public Builder data(byte[] data) {
            this.data = data;
            return this;
        }

        public Builder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder file(File file) {
            this.file = file;
            return this;
        }

        @Override
        Builder self() {
            return this;
        }

        public EasimartRESTFileCommand build() {
            return new EasimartRESTFileCommand(this);
        }
    }
}

