/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.os.Build;
import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartException;
import co.easimart.EasimartExecutors;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartLog;
import co.easimart.ProgressCallback;
import co.easimart.http.EasimartHttpBody;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

abstract class EasimartRequest<Response> {
    private static final ThreadFactory sThreadFactory = new ThreadFactory(){
        private final AtomicInteger mCount = new AtomicInteger(1);

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "EasimartRequest.NETWORK_EXECUTOR-thread-" + this.mCount.getAndIncrement());
        }
    };
    private static final int CPU_COUNT = Runtime.getRuntime().availableProcessors();
    private static final int CORE_POOL_SIZE = CPU_COUNT * 2 + 1;
    private static final int MAX_POOL_SIZE = CPU_COUNT * 2 * 2 + 1;
    private static final long KEEP_ALIVE_TIME = 1L;
    private static final int MAX_QUEUE_SIZE = 128;
    static final ExecutorService NETWORK_EXECUTOR = EasimartRequest.newThreadPoolExecutor(CORE_POOL_SIZE, MAX_POOL_SIZE, 1L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), sThreadFactory);
    protected static final int DEFAULT_MAX_RETRIES = 4;
    static final long DEFAULT_INITIAL_RETRY_DELAY = 1000L;
    private static long defaultInitialRetryDelay = 1000L;
    private int maxRetries = 4;
    EasimartHttpRequest.Method method;
    String url;

    private static ThreadPoolExecutor newThreadPoolExecutor(int corePoolSize, int maxPoolSize, long keepAliveTime, TimeUnit timeUnit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        ThreadPoolExecutor executor = new ThreadPoolExecutor(corePoolSize, maxPoolSize, keepAliveTime, timeUnit, workQueue, threadFactory);
        if (Build.VERSION.SDK_INT >= 9) {
            executor.allowCoreThreadTimeOut(true);
        }
        return executor;
    }

    public static void setDefaultInitialRetryDelay(long delay) {
        defaultInitialRetryDelay = delay;
    }

    public static long getDefaultInitialRetryDelay() {
        return defaultInitialRetryDelay;
    }

    public EasimartRequest(String url) {
        this(EasimartHttpRequest.Method.GET, url);
    }

    public EasimartRequest(EasimartHttpRequest.Method method, String url) {
        this.method = method;
        this.url = url;
    }

    public void setMaxRetries(int max) {
        this.maxRetries = max;
    }

    protected EasimartHttpBody newBody(ProgressCallback uploadProgressCallback) {
        return null;
    }

    protected EasimartHttpRequest newRequest(EasimartHttpRequest.Method method, String url, ProgressCallback uploadProgressCallback) {
        EasimartHttpRequest.Builder requestBuilder = new EasimartHttpRequest.Builder().setMethod(method).setUrl(url);
        switch (method) {
            case GET: 
            case DELETE: {
                break;
            }
            case POST: 
            case PUT: {
                requestBuilder.setBody(this.newBody(uploadProgressCallback));
                break;
            }
            default: {
                throw new IllegalStateException("Invalid method " + (Object)((Object)method));
            }
        }
        return requestBuilder.build();
    }

    private Task<Response> sendOneRequestAsync(final EasimartHttpClient client, final EasimartHttpRequest request, final ProgressCallback downloadProgressCallback) {
        return Task.forResult(null).onSuccessTask(new Continuation<Void, Task<Response>>(){

            public Task<Response> then(Task<Void> task) throws Exception {
                EasimartHttpResponse response = client.execute(request);
                return EasimartRequest.this.onResponseAsync(response, downloadProgressCallback);
            }
        }, (Executor)NETWORK_EXECUTOR).continueWithTask(new Continuation<Response, Task<Response>>(){

            public Task<Response> then(Task<Response> task) throws Exception {
                Exception error;
                if (task.isFaulted() && (error = task.getError()) instanceof IOException) {
                    return Task.forError((Exception)EasimartRequest.this.newTemporaryException("i/o failure", error));
                }
                return task;
            }
        }, (Executor)Task.BACKGROUND_EXECUTOR);
    }

    protected abstract Task<Response> onResponseAsync(EasimartHttpResponse var1, ProgressCallback var2);

    public Task<Response> executeAsync(EasimartHttpClient client) {
        return this.executeAsync(client, (ProgressCallback)null, null, null);
    }

    public Task<Response> executeAsync(EasimartHttpClient client, Task<Void> cancellationToken) {
        return this.executeAsync(client, (ProgressCallback)null, null, cancellationToken);
    }

    public Task<Response> executeAsync(EasimartHttpClient client, ProgressCallback uploadProgressCallback, ProgressCallback downloadProgressCallback) {
        return this.executeAsync(client, uploadProgressCallback, downloadProgressCallback, null);
    }

    public Task<Response> executeAsync(EasimartHttpClient client, ProgressCallback uploadProgressCallback, ProgressCallback downloadProgressCallback, Task<Void> cancellationToken) {
        EasimartHttpRequest request = this.newRequest(this.method, this.url, uploadProgressCallback);
        return this.executeAsync(client, request, downloadProgressCallback, cancellationToken);
    }

    private Task<Response> executeAsync(EasimartHttpClient client, EasimartHttpRequest request, ProgressCallback downloadProgressCallback, Task<Void> cancellationToken) {
        long delay = defaultInitialRetryDelay + (long)((double)defaultInitialRetryDelay * Math.random());
        return this.executeAsync(client, request, 0, delay, downloadProgressCallback, cancellationToken);
    }

    private Task<Response> executeAsync(final EasimartHttpClient client, final EasimartHttpRequest request, final int attemptsMade, final long delay, final ProgressCallback downloadProgressCallback, final Task<Void> cancellationToken) {
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        return this.sendOneRequestAsync(client, request, downloadProgressCallback).continueWithTask(new Continuation<Response, Task<Response>>(){

            public Task<Response> then(Task<Response> task) throws Exception {
                Exception e = task.getError();
                if (task.isFaulted() && e instanceof EasimartException) {
                    if (cancellationToken != null && cancellationToken.isCancelled()) {
                        return Task.cancelled();
                    }
                    if (e instanceof EasimartRequestException && ((EasimartRequestException)e).isPermanentFailure) {
                        return task;
                    }
                    if (attemptsMade < EasimartRequest.this.maxRetries) {
                        EasimartLog.i("co.easimart.EasimartRequest", "Request failed. Waiting " + delay + " milliseconds before attempt #" + (attemptsMade + 1));
                        final Task.TaskCompletionSource retryTask = Task.create();
                        EasimartExecutors.scheduled().schedule(new Runnable(){

                            @Override
                            public void run() {
                                EasimartRequest.this.executeAsync(client, request, attemptsMade + 1, delay * 2L, downloadProgressCallback, (Task<Void>)cancellationToken).continueWithTask(new Continuation<Response, Task<Void>>(){

                                    public Task<Void> then(Task<Response> task) throws Exception {
                                        if (task.isCancelled()) {
                                            retryTask.setCancelled();
                                        } else if (task.isFaulted()) {
                                            retryTask.setError(task.getError());
                                        } else {
                                            retryTask.setResult(task.getResult());
                                        }
                                        return null;
                                    }
                                });
                            }
                        }, delay, TimeUnit.MILLISECONDS);
                        return retryTask.getTask();
                    }
                }
                return task;
            }
        });
    }

    protected EasimartException newPermanentException(int code, String message) {
        EasimartRequestException e = new EasimartRequestException(code, message);
        e.isPermanentFailure = true;
        return e;
    }

    protected EasimartException newTemporaryException(int code, String message) {
        EasimartRequestException e = new EasimartRequestException(code, message);
        e.isPermanentFailure = false;
        return e;
    }

    protected EasimartException newTemporaryException(String message, Throwable t) {
        EasimartRequestException e = new EasimartRequestException(100, message, t);
        e.isPermanentFailure = false;
        return e;
    }

    private static class EasimartRequestException
    extends EasimartException {
        boolean isPermanentFailure = false;

        public EasimartRequestException(int theCode, String theMessage) {
            super(theCode, theMessage);
        }

        public EasimartRequestException(int theCode, String message, Throwable cause) {
            super(theCode, message, cause);
        }
    }
}

