/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.AuthenticationCallback;
import co.easimart.Easimart;
import co.easimart.EasimartAnonymousUtils;
import co.easimart.EasimartAuthenticationManager;
import co.easimart.EasimartClassName;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartCurrentUserController;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartException;
import co.easimart.EasimartObject;
import co.easimart.EasimartOperationSet;
import co.easimart.EasimartPlugins;
import co.easimart.EasimartQuery;
import co.easimart.EasimartSession;
import co.easimart.EasimartTaskUtils;
import co.easimart.EasimartTextUtils;
import co.easimart.EasimartUserController;
import co.easimart.LogInCallback;
import co.easimart.LogOutCallback;
import co.easimart.NetworkUserController;
import co.easimart.RequestPasswordResetCallback;
import co.easimart.SignUpCallback;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.json.JSONObject;

@EasimartClassName(value="_User")
public class EasimartUser
extends EasimartObject {
    private static final String KEY_SESSION_TOKEN = "sessionToken";
    private static final String KEY_AUTH_DATA = "authData";
    private static final String KEY_USERNAME = "username";
    private static final String KEY_PASSWORD = "password";
    private static final String KEY_EMAIL = "email";
    private static final List<String> READ_ONLY_KEYS = Collections.unmodifiableList(Arrays.asList("sessionToken", "authData"));
    private boolean isCurrentUser = false;
    private static final Object isAutoUserEnabledMutex = new Object();
    private static boolean autoUserEnabled;

    public static EasimartQuery<EasimartUser> getQuery() {
        return EasimartQuery.getQuery(EasimartUser.class);
    }

    static EasimartUserController getUserController() {
        return EasimartCorePlugins.getInstance().getUserController();
    }

    static EasimartCurrentUserController getCurrentUserController() {
        return EasimartCorePlugins.getInstance().getCurrentUserController();
    }

    static EasimartAuthenticationManager getAuthenticationManager() {
        return EasimartCorePlugins.getInstance().getAuthenticationManager();
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_KEYS.contains(key);
    }

    State.Builder newStateBuilder(String className) {
        return new State.Builder();
    }

    @Override
    State getState() {
        return (State)super.getState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isLazy() {
        Object object = this.mutex;
        synchronized (object) {
            return this.getObjectId() == null && EasimartAnonymousUtils.isLinked(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAuthenticated() {
        Object object = this.mutex;
        synchronized (object) {
            EasimartUser current = EasimartUser.getCurrentUser();
            return this.isLazy() || this.getState().sessionToken() != null && current != null && this.getObjectId().equals(current.getObjectId());
        }
    }

    @Override
    public void remove(String key) {
        if (KEY_USERNAME.equals(key)) {
            throw new IllegalArgumentException("Can't remove the username key.");
        }
        super.remove(key);
    }

    @Override
    JSONObject toRest(EasimartObject.State state, List<EasimartOperationSet> operationSetQueue, EasimartEncoder objectEncoder) {
        List<EasimartOperationSet> cleanOperationSetQueue = operationSetQueue;
        for (int i = 0; i < operationSetQueue.size(); ++i) {
            EasimartOperationSet operations = operationSetQueue.get(i);
            if (!operations.containsKey(KEY_PASSWORD)) continue;
            if (cleanOperationSetQueue == operationSetQueue) {
                cleanOperationSetQueue = new LinkedList<EasimartOperationSet>(operationSetQueue);
            }
            EasimartOperationSet cleanOperations = new EasimartOperationSet(operations);
            cleanOperations.remove(KEY_PASSWORD);
            cleanOperationSetQueue.set(i, cleanOperations);
        }
        return super.toRest(state, cleanOperationSetQueue, objectEncoder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> cleanUpAuthDataAsync() {
        Map<String, Map<String, String>> authData;
        EasimartAuthenticationManager controller = EasimartUser.getAuthenticationManager();
        Object object = this.mutex;
        synchronized (object) {
            authData = this.getState().authData();
            if (authData.size() == 0) {
                return Task.forResult(null);
            }
        }
        ArrayList<Task> tasks = new ArrayList<Task>();
        Iterator<Map.Entry<String, Map<String, String>>> i = authData.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, Map<String, String>> entry = i.next();
            if (entry.getValue() != null) continue;
            i.remove();
            tasks.add(controller.restoreAuthenticationAsync(entry.getKey(), null).makeVoid());
        }
        State newState = this.getState().newBuilder().authData(authData).build();
        this.setState(newState);
        return Task.whenAll(tasks);
    }

    @Override
    Task<Void> handleSaveResultAsync(EasimartObject.State result, EasimartOperationSet operationsBeforeSave) {
        boolean success;
        boolean bl = success = result != null;
        if (success) {
            operationsBeforeSave.remove(KEY_PASSWORD);
        }
        return super.handleSaveResultAsync(result, operationsBeforeSave);
    }

    @Override
    void validateSaveEventually() throws EasimartException {
        if (this.isDirty(KEY_PASSWORD)) {
            throw new EasimartException(-1, "Unable to saveEventually on a EasimartUser with dirty password");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isCurrentUser() {
        Object object = this.mutex;
        synchronized (object) {
            return this.isCurrentUser;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setIsCurrentUser(boolean isCurrentUser) {
        Object object = this.mutex;
        synchronized (object) {
            this.isCurrentUser = isCurrentUser;
        }
    }

    public String getSessionToken() {
        return this.getState().sessionToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> setSessionTokenInBackground(String newSessionToken) {
        Object object = this.mutex;
        synchronized (object) {
            State state = this.getState();
            if (newSessionToken.equals(state.sessionToken())) {
                return Task.forResult(null);
            }
            State.Builder builder = state.newBuilder().sessionToken(newSessionToken);
            this.setState(builder.build());
            return EasimartUser.saveCurrentUserAsync(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Map<String, String>> getAuthData() {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> authData = this.getMap(KEY_AUTH_DATA);
            if (authData == null) {
                authData = new HashMap();
            }
            return authData;
        }
    }

    private Map<String, String> getAuthData(String authType) {
        return this.getAuthData().get(authType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putAuthData(String authType, Map<String, String> authData) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> newAuthData = this.getAuthData();
            newAuthData.put(authType, authData);
            this.performPut(KEY_AUTH_DATA, newAuthData);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeAuthData(String authType) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Map<String, String>> newAuthData = this.getAuthData();
            newAuthData.remove(authType);
            this.performPut(KEY_AUTH_DATA, newAuthData);
        }
    }

    public void setUsername(String username) {
        this.put(KEY_USERNAME, username);
    }

    public String getUsername() {
        return this.getString(KEY_USERNAME);
    }

    public void setPassword(String password) {
        this.put(KEY_PASSWORD, password);
    }

    String getPassword() {
        return this.getString(KEY_PASSWORD);
    }

    public void setEmail(String email) {
        this.put(KEY_EMAIL, email);
    }

    public String getEmail() {
        return this.getString(KEY_EMAIL);
    }

    public boolean isNew() {
        return this.getState().isNew();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(String key, Object value) {
        Object object = this.mutex;
        synchronized (object) {
            if (KEY_USERNAME.equals(key)) {
                this.stripAnonymity();
            }
            super.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stripAnonymity() {
        Object object = this.mutex;
        synchronized (object) {
            if (EasimartAnonymousUtils.isLinked(this)) {
                if (this.getObjectId() != null) {
                    this.putAuthData("anonymous", null);
                } else {
                    this.removeAuthData("anonymous");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void restoreAnonymity(Map<String, String> anonymousData) {
        Object object = this.mutex;
        synchronized (object) {
            if (anonymousData != null) {
                this.putAuthData("anonymous", anonymousData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateSave() {
        EasimartUser current;
        Object object = this.mutex;
        synchronized (object) {
            if (this.getObjectId() == null) {
                throw new IllegalArgumentException("Cannot save a EasimartUser until it has been signed up. Call signUp first.");
            }
            if (this.isAuthenticated() || !this.isDirty() || this.isCurrentUser()) {
                return;
            }
        }
        if (!Easimart.isLocalDatastoreEnabled() && (current = EasimartUser.getCurrentUser()) != null && this.getObjectId().equals(current.getObjectId())) {
            return;
        }
        throw new IllegalArgumentException("Cannot save a EasimartUser that is not authenticated.");
    }

    @Override
    Task<Void> saveAsync(String sessionToken, Task<Void> toAwait) {
        return this.saveAsync(sessionToken, this.isLazy(), toAwait);
    }

    Task<Void> saveAsync(String sessionToken, boolean isLazy, Task<Void> toAwait) {
        Task<Void> task = isLazy ? this.resolveLazinessAsync(toAwait) : super.saveAsync(sessionToken, toAwait);
        if (this.isCurrentUser()) {
            return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return EasimartUser.this.cleanUpAuthDataAsync();
                }
            }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return EasimartUser.saveCurrentUserAsync(EasimartUser.this);
                }
            });
        }
        return task;
    }

    @Override
    void setState(EasimartObject.State newState) {
        if (this.isCurrentUser() && this.getSessionToken() != null && newState.get(KEY_SESSION_TOKEN) == null) {
            newState = ((EasimartObject.State.Init)((EasimartObject.State.Init)newState.newBuilder()).put(KEY_SESSION_TOKEN, this.getSessionToken())).build();
        }
        super.setState(newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateDelete() {
        Object object = this.mutex;
        synchronized (object) {
            super.validateDelete();
            if (!this.isAuthenticated() && this.isDirty()) {
                throw new IllegalArgumentException("Cannot delete a EasimartUser that is not authenticated.");
            }
        }
    }

    public EasimartUser fetch() throws EasimartException {
        return (EasimartUser)super.fetch();
    }

    @Override
    <T extends EasimartObject> Task<T> fetchAsync(String sessionToken, Task<Void> toAwait) {
        if (this.isLazy()) {
            return Task.forResult((Object)this);
        }
        Task task = super.fetchAsync(sessionToken, toAwait);
        if (this.isCurrentUser()) {
            return task.onSuccessTask(new Continuation<T, Task<Void>>(){

                public Task<Void> then(Task<T> fetchAsyncTask) throws Exception {
                    return EasimartUser.this.cleanUpAuthDataAsync();
                }
            }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return EasimartUser.saveCurrentUserAsync(EasimartUser.this);
                }
            }).onSuccess(new Continuation<Void, T>(){

                public T then(Task<Void> task) throws Exception {
                    return EasimartUser.this;
                }
            });
        }
        return task;
    }

    public Task<Void> signUpInBackground() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return EasimartUser.this.signUpAsync(task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> signUpAsync(Task<Void> toAwait) {
        final EasimartUser user = EasimartUser.getCurrentUser();
        Object object = this.mutex;
        synchronized (object) {
            String sessionToken;
            String string = sessionToken = user != null ? user.getSessionToken() : null;
            if (EasimartTextUtils.isEmpty(this.getUsername())) {
                return Task.forError((Exception)new IllegalArgumentException("Username cannot be missing or blank"));
            }
            if (EasimartTextUtils.isEmpty(this.getPassword())) {
                return Task.forError((Exception)new IllegalArgumentException("Password cannot be missing or blank"));
            }
            if (this.getObjectId() != null) {
                Map<String, Map<String, String>> authData = this.getAuthData();
                if (authData.containsKey("anonymous") && authData.get("anonymous") == null) {
                    return this.saveAsync(sessionToken, toAwait);
                }
                return Task.forError((Exception)new IllegalArgumentException("Cannot sign up a user that has already signed up."));
            }
            if (this.operationSetQueue.size() > 1) {
                return Task.forError((Exception)new IllegalArgumentException("Cannot sign up a user that is already signing up."));
            }
            if (user != null && EasimartAnonymousUtils.isLinked(user)) {
                if (this == user) {
                    return Task.forError((Exception)new IllegalArgumentException("Attempt to merge currentUser with itself."));
                }
                boolean isLazy = user.isLazy();
                final String oldUsername = user.getUsername();
                final String oldPassword = user.getPassword();
                final Map<String, String> anonymousData = user.getAuthData("anonymous");
                user.copyChangesFrom(this);
                user.setUsername(this.getUsername());
                user.setPassword(this.getPassword());
                this.revert();
                return user.saveAsync(sessionToken, isLazy, toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (task.isCancelled() || task.isFaulted()) {
                            Object object = user.mutex;
                            synchronized (object) {
                                if (oldUsername != null) {
                                    user.setUsername(oldUsername);
                                } else {
                                    user.revert(EasimartUser.KEY_USERNAME);
                                }
                                if (oldPassword != null) {
                                    user.setPassword(oldPassword);
                                } else {
                                    user.revert(EasimartUser.KEY_PASSWORD);
                                }
                                user.restoreAnonymity(anonymousData);
                            }
                            return task;
                        }
                        user.revert(EasimartUser.KEY_PASSWORD);
                        EasimartUser.this.revert(EasimartUser.KEY_PASSWORD);
                        EasimartUser.this.mergeFromObject(user);
                        return EasimartUser.saveCurrentUserAsync(EasimartUser.this);
                    }
                });
            }
            final EasimartOperationSet operations = this.startSave();
            return toAwait.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return EasimartUser.getUserController().signUpAsync(EasimartUser.this.getState(), operations, sessionToken).continueWithTask((Continuation)new Continuation<State, Task<Void>>(){

                        public Task<Void> then(final Task<State> signUpTask) throws Exception {
                            State result = (State)signUpTask.getResult();
                            return EasimartUser.this.handleSaveResultAsync(result, operations).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                public Task<Void> then(Task<Void> task) throws Exception {
                                    if (!signUpTask.isCancelled() && !signUpTask.isFaulted()) {
                                        return EasimartUser.saveCurrentUserAsync(EasimartUser.this);
                                    }
                                    return signUpTask.makeVoid();
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    public void signUp() throws EasimartException {
        EasimartTaskUtils.wait(this.signUpInBackground());
    }

    public void signUpInBackground(SignUpCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.signUpInBackground(), callback);
    }

    public static Task<EasimartUser> logInInBackground(String username, String password) {
        if (username == null) {
            throw new IllegalArgumentException("Must specify a username for the user to log in with");
        }
        if (password == null) {
            throw new IllegalArgumentException("Must specify a password for the user to log in with");
        }
        return EasimartUser.getUserController().logInAsync(username, password).onSuccessTask((Continuation)new Continuation<State, Task<EasimartUser>>(){

            public Task<EasimartUser> then(Task<State> task) throws Exception {
                State result = (State)task.getResult();
                final EasimartUser newCurrent = (EasimartUser)EasimartObject.from(result);
                return EasimartUser.saveCurrentUserAsync(newCurrent).onSuccess((Continuation)new Continuation<Void, EasimartUser>(){

                    public EasimartUser then(Task<Void> task) throws Exception {
                        return newCurrent;
                    }
                });
            }
        });
    }

    public static EasimartUser logIn(String username, String password) throws EasimartException {
        return EasimartTaskUtils.wait(EasimartUser.logInInBackground(username, password));
    }

    public static void logInInBackground(String username, String password, LogInCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartUser.logInInBackground(username, password), callback);
    }

    public static Task<EasimartUser> becomeInBackground(String sessionToken) {
        if (sessionToken == null) {
            throw new IllegalArgumentException("Must specify a sessionToken for the user to log in with");
        }
        return EasimartUser.getUserController().getUserAsync(sessionToken).onSuccessTask((Continuation)new Continuation<State, Task<EasimartUser>>(){

            public Task<EasimartUser> then(Task<State> task) throws Exception {
                State result = (State)task.getResult();
                final EasimartUser user = (EasimartUser)EasimartObject.from(result);
                return EasimartUser.saveCurrentUserAsync(user).onSuccess((Continuation)new Continuation<Void, EasimartUser>(){

                    public EasimartUser then(Task<Void> task) throws Exception {
                        return user;
                    }
                });
            }
        });
    }

    public static EasimartUser become(String sessionToken) throws EasimartException {
        return EasimartTaskUtils.wait(EasimartUser.becomeInBackground(sessionToken));
    }

    public static void becomeInBackground(String sessionToken, LogInCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartUser.becomeInBackground(sessionToken), callback);
    }

    static Task<EasimartUser> getCurrentUserAsync() {
        return EasimartUser.getCurrentUserController().getAsync();
    }

    public static EasimartUser getCurrentUser() {
        return EasimartUser.getCurrentUser(EasimartUser.isAutomaticUserEnabled());
    }

    private static EasimartUser getCurrentUser(boolean shouldAutoCreateUser) {
        try {
            return EasimartTaskUtils.wait(EasimartUser.getCurrentUserController().getAsync(shouldAutoCreateUser));
        }
        catch (EasimartException e) {
            return null;
        }
    }

    static String getCurrentSessionToken() {
        EasimartUser current = EasimartUser.getCurrentUser();
        return current != null ? current.getSessionToken() : null;
    }

    static Task<String> getCurrentSessionTokenAsync() {
        return EasimartUser.getCurrentUserController().getCurrentSessionTokenAsync();
    }

    private static Task<Void> saveCurrentUserAsync(EasimartUser user) {
        return EasimartUser.getCurrentUserController().setAsync(user);
    }

    static Task<Void> pinCurrentUserIfNeededAsync(EasimartUser user) {
        if (!Easimart.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Easimart#enableLocalDatastore(Context)`.");
        }
        return EasimartUser.getCurrentUserController().setIfNeededAsync(user);
    }

    public static Task<Void> logOutInBackground() {
        return EasimartUser.getCurrentUserController().logOutAsync();
    }

    public static void logOutInBackground(LogOutCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartUser.logOutInBackground(), callback);
    }

    public static void logOut() {
        try {
            EasimartTaskUtils.wait(EasimartUser.logOutInBackground());
        }
        catch (EasimartException easimartException) {
            // empty catch block
        }
    }

    Task<Void> logOutAsync() {
        return this.logOutAsync(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> logOutAsync(boolean revoke) {
        String oldSessionToken;
        EasimartAuthenticationManager controller = EasimartUser.getAuthenticationManager();
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
        Object object = this.mutex;
        synchronized (object) {
            oldSessionToken = this.getState().sessionToken();
            for (Map.Entry<String, Map<String, String>> entry : this.getAuthData().entrySet()) {
                tasks.add(controller.deauthenticateAsync(entry.getKey()));
            }
            State newState = this.getState().newBuilder().sessionToken(null).isNew(false).build();
            this.isCurrentUser = false;
            this.setState(newState);
        }
        if (revoke) {
            tasks.add(EasimartSession.revokeAsync(oldSessionToken));
        }
        return Task.whenAll(tasks);
    }

    public static Task<Void> requestPasswordResetInBackground(String email) {
        return EasimartUser.getUserController().requestPasswordResetAsync(email);
    }

    public static void requestPasswordReset(String email) throws EasimartException {
        EasimartTaskUtils.wait(EasimartUser.requestPasswordResetInBackground(email));
    }

    public static void requestPasswordResetInBackground(String email, RequestPasswordResetCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartUser.requestPasswordResetInBackground(email), callback);
    }

    public EasimartUser fetchIfNeeded() throws EasimartException {
        return (EasimartUser)super.fetchIfNeeded();
    }

    public static void registerAuthenticationCallback(String authType, AuthenticationCallback callback) {
        EasimartUser.getAuthenticationManager().register(authType, callback);
    }

    public static Task<EasimartUser> logInWithInBackground(final String authType, final Map<String, String> authData) {
        if (authType == null) {
            throw new IllegalArgumentException("Invalid authType: " + null);
        }
        Continuation<Void, Task<EasimartUser>> logInWithTask = new Continuation<Void, Task<EasimartUser>>(){

            public Task<EasimartUser> then(Task<Void> task) throws Exception {
                return EasimartUser.getUserController().logInAsync(authType, authData).onSuccessTask((Continuation)new Continuation<State, Task<EasimartUser>>(){

                    public Task<EasimartUser> then(Task<State> task) throws Exception {
                        State result = (State)task.getResult();
                        final EasimartUser user = (EasimartUser)EasimartObject.from(result);
                        return EasimartUser.saveCurrentUserAsync(user).onSuccess((Continuation)new Continuation<Void, EasimartUser>(){

                            public EasimartUser then(Task<Void> task) throws Exception {
                                return user;
                            }
                        });
                    }
                });
            }
        };
        return EasimartUser.getCurrentUserAsync().onSuccessTask((Continuation)new Continuation<EasimartUser, Task<EasimartUser>>((Continuation)logInWithTask){
            final /* synthetic */ Continuation val$logInWithTask;
            {
                this.val$logInWithTask = continuation;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<EasimartUser> then(Task<EasimartUser> task) throws Exception {
                final EasimartUser user = (EasimartUser)task.getResult();
                if (user != null) {
                    Object object = user.mutex;
                    synchronized (object) {
                        if (EasimartAnonymousUtils.isLinked(user)) {
                            if (user.isLazy()) {
                                final Map oldAnonymousData = user.getAuthData("anonymous");
                                return user.taskQueue.enqueue(new Continuation<Void, Task<EasimartUser>>(){

                                    public Task<EasimartUser> then(Task<Void> toAwait) throws Exception {
                                        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public Task<Void> then(Task<Void> task) throws Exception {
                                                Object object = user.mutex;
                                                synchronized (object) {
                                                    user.stripAnonymity();
                                                    user.putAuthData(authType, authData);
                                                    return user.resolveLazinessAsync(task);
                                                }
                                            }
                                        }).continueWithTask((Continuation)new Continuation<Void, Task<EasimartUser>>(){

                                            /*
                                             * WARNING - Removed try catching itself - possible behaviour change.
                                             */
                                            public Task<EasimartUser> then(Task<Void> task) throws Exception {
                                                Object object = user.mutex;
                                                synchronized (object) {
                                                    if (task.isFaulted()) {
                                                        user.removeAuthData(authType);
                                                        user.restoreAnonymity(oldAnonymousData);
                                                        return Task.forError((Exception)task.getError());
                                                    }
                                                    if (task.isCancelled()) {
                                                        return Task.cancelled();
                                                    }
                                                    return Task.forResult((Object)user);
                                                }
                                            }
                                        });
                                    }
                                });
                            }
                            return user.linkWithInBackground(authType, authData).continueWithTask((Continuation)new Continuation<Void, Task<EasimartUser>>(){

                                public Task<EasimartUser> then(Task<Void> task) throws Exception {
                                    Exception error;
                                    if (task.isFaulted() && (error = task.getError()) instanceof EasimartException && ((EasimartException)error).getCode() == 208) {
                                        return Task.forResult(null).continueWithTask(val$logInWithTask);
                                    }
                                    if (task.isCancelled()) {
                                        return Task.cancelled();
                                    }
                                    return Task.forResult((Object)user);
                                }
                            });
                        }
                    }
                }
                return Task.forResult(null).continueWithTask(this.val$logInWithTask);
            }
        });
    }

    public boolean isLinked(String authType) {
        Map<String, Map<String, String>> authData = this.getAuthData();
        return authData.containsKey(authType) && authData.get(authType) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> synchronizeAllAuthDataAsync() {
        Map<String, Map<String, String>> authData;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isCurrentUser()) {
                return Task.forResult(null);
            }
            authData = this.getAuthData();
        }
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>(authData.size());
        for (String authType : authData.keySet()) {
            tasks.add(this.synchronizeAuthDataAsync(authType));
        }
        return Task.whenAll(tasks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> synchronizeAuthDataAsync(String authType) {
        Map<String, String> authData;
        Object object = this.mutex;
        synchronized (object) {
            if (!this.isCurrentUser()) {
                return Task.forResult(null);
            }
            authData = this.getAuthData(authType);
        }
        return this.synchronizeAuthDataAsync(EasimartUser.getAuthenticationManager(), authType, authData);
    }

    private Task<Void> synchronizeAuthDataAsync(EasimartAuthenticationManager manager, final String authType, Map<String, String> authData) {
        return manager.restoreAuthenticationAsync(authType, authData).continueWithTask((Continuation)new Continuation<Boolean, Task<Void>>(){

            public Task<Void> then(Task<Boolean> task) throws Exception {
                boolean success;
                boolean bl = success = !task.isFaulted() && (Boolean)task.getResult() != false;
                if (!success) {
                    return EasimartUser.this.unlinkFromInBackground(authType);
                }
                return task.makeVoid();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Task<Void> linkWithAsync(final String authType, Map<String, String> authData, Task<Void> toAwait, String sessionToken) {
        Object object = this.mutex;
        synchronized (object) {
            boolean isLazy = this.isLazy();
            final Map<String, String> oldAnonymousData = this.getAuthData("anonymous");
            this.stripAnonymity();
            this.putAuthData(authType, authData);
            return this.saveAsync(sessionToken, isLazy, toAwait).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = EasimartUser.this.mutex;
                    synchronized (object) {
                        if (task.isFaulted() || task.isCancelled()) {
                            EasimartUser.this.restoreAnonymity(oldAnonymousData);
                            return task;
                        }
                        return EasimartUser.this.synchronizeAuthDataAsync(authType);
                    }
                }
            });
        }
    }

    private Task<Void> linkWithAsync(final String authType, final Map<String, String> authData, final String sessionToken) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return EasimartUser.this.linkWithAsync(authType, authData, (Task<Void>)task, sessionToken);
            }
        });
    }

    public Task<Void> linkWithInBackground(String authType, Map<String, String> authData) {
        if (authType == null) {
            throw new IllegalArgumentException("Invalid authType: " + null);
        }
        return this.linkWithAsync(authType, authData, this.getSessionToken());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> unlinkFromInBackground(String authType) {
        if (authType == null) {
            return Task.forResult(null);
        }
        Object object = this.mutex;
        synchronized (object) {
            if (!this.getAuthData().containsKey(authType)) {
                return Task.forResult(null);
            }
            this.putAuthData(authType, null);
        }
        return this.saveInBackground();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> resolveLazinessAsync(Task<Void> toAwait) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.getAuthData().size() == 0) {
                return this.signUpAsync(toAwait);
            }
            final EasimartOperationSet operations = this.startSave();
            return toAwait.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return EasimartUser.getUserController().logInAsync(EasimartUser.this.getState(), operations).onSuccessTask((Continuation)new Continuation<State, Task<Void>>(){

                        public Task<Void> then(Task<State> task) throws Exception {
                            final State result = (State)task.getResult();
                            Task resultTask = Easimart.isLocalDatastoreEnabled() && !result.isNew() ? Task.forResult((Object)result) : EasimartUser.this.handleSaveResultAsync(result, operations).onSuccess((Continuation)new Continuation<Void, State>(){

                                public State then(Task<Void> task) throws Exception {
                                    return result;
                                }
                            });
                            return resultTask.onSuccessTask((Continuation)new Continuation<State, Task<Void>>(){

                                public Task<Void> then(Task<State> task) throws Exception {
                                    State result = (State)task.getResult();
                                    if (!result.isNew()) {
                                        EasimartUser newUser = (EasimartUser)EasimartObject.from(result);
                                        return EasimartUser.saveCurrentUserAsync(newUser);
                                    }
                                    return task.makeVoid();
                                }
                            });
                        }
                    });
                }
            });
        }
    }

    @Override
    <T extends EasimartObject> Task<T> fetchFromLocalDatastoreAsync() {
        if (this.isLazy()) {
            return Task.forResult((Object)this);
        }
        return super.fetchFromLocalDatastoreAsync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void enableAutomaticUser() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            autoUserEnabled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void disableAutomaticUser() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            autoUserEnabled = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isAutomaticUserEnabled() {
        Object object = isAutoUserEnabledMutex;
        synchronized (object) {
            return autoUserEnabled;
        }
    }

    public static Task<Void> enableRevocableSessionInBackground() {
        EasimartCorePlugins.getInstance().registerUserController(new NetworkUserController(EasimartPlugins.get().restClient(), true));
        return EasimartUser.getCurrentUserController().getAsync(false).onSuccessTask((Continuation)new Continuation<EasimartUser, Task<Void>>(){

            public Task<Void> then(Task<EasimartUser> task) throws Exception {
                EasimartUser user = (EasimartUser)task.getResult();
                if (user == null) {
                    return Task.forResult(null);
                }
                return user.upgradeToRevocableSessionAsync();
            }
        });
    }

    Task<Void> upgradeToRevocableSessionAsync() {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return EasimartUser.this.upgradeToRevocableSessionAsync((Task<Void>)toAwait);
            }
        });
    }

    private Task<Void> upgradeToRevocableSessionAsync(Task<Void> toAwait) {
        final String sessionToken = this.getSessionToken();
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<String>>(){

            public Task<String> then(Task<Void> task) throws Exception {
                return EasimartSession.upgradeToRevocableSessionAsync(sessionToken);
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String result = (String)task.getResult();
                return EasimartUser.this.setSessionTokenInBackground(result);
            }
        });
    }

    static class State
    extends EasimartObject.State {
        private final boolean isNew;

        private State(Builder builder) {
            super(builder);
            this.isNew = builder.isNew;
        }

        public Builder newBuilder() {
            return new Builder(this);
        }

        public String sessionToken() {
            return (String)this.get(EasimartUser.KEY_SESSION_TOKEN);
        }

        public Map<String, Map<String, String>> authData() {
            HashMap authData = (HashMap)this.get(EasimartUser.KEY_AUTH_DATA);
            if (authData == null) {
                authData = new HashMap();
            }
            return authData;
        }

        public boolean isNew() {
            return this.isNew;
        }

        static class Builder
        extends EasimartObject.State.Init<Builder> {
            private boolean isNew;

            public Builder() {
                super("_User");
            }

            Builder(State state) {
                super(state);
                this.isNew = state.isNew();
            }

            @Override
            Builder self() {
                return this;
            }

            @Override
            public State build() {
                return new State(this);
            }

            @Override
            public Builder apply(EasimartObject.State other) {
                this.isNew(((State)other).isNew());
                return (Builder)super.apply(other);
            }

            public Builder sessionToken(String sessionToken) {
                return (Builder)this.put(EasimartUser.KEY_SESSION_TOKEN, sessionToken);
            }

            public Builder authData(Map<String, Map<String, String>> authData) {
                return (Builder)this.put(EasimartUser.KEY_AUTH_DATA, authData);
            }

            public Builder putAuthData(String authType, Map<String, String> authData) {
                HashMap<String, Map<String, String>> newAuthData = (HashMap<String, Map<String, String>>)this.serverData.get(EasimartUser.KEY_AUTH_DATA);
                if (newAuthData == null) {
                    newAuthData = new HashMap<String, Map<String, String>>();
                }
                newAuthData.put(authType, authData);
                this.serverData.put(EasimartUser.KEY_AUTH_DATA, newAuthData);
                return this;
            }

            public Builder isNew(boolean isNew) {
                this.isNew = isNew;
                return this;
            }
        }
    }
}

