/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartDecoder;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartObject;
import co.easimart.EasimartObjectCurrentCoder;
import co.easimart.EasimartOperationSet;
import co.easimart.EasimartUser;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartUserCurrentCoder
extends EasimartObjectCurrentCoder {
    private static final String KEY_AUTH_DATA = "auth_data";
    private static final String KEY_SESSION_TOKEN = "session_token";
    private static final EasimartUserCurrentCoder INSTANCE = new EasimartUserCurrentCoder();

    public static EasimartUserCurrentCoder get() {
        return INSTANCE;
    }

    EasimartUserCurrentCoder() {
    }

    @Override
    public <T extends EasimartObject.State> JSONObject encode(T state, EasimartOperationSet operations, EasimartEncoder encoder) {
        Map<String, Map<String, String>> authData;
        JSONObject objectJSON = super.encode(state, operations, encoder);
        String sessionToken = ((EasimartUser.State)state).sessionToken();
        if (sessionToken != null) {
            try {
                objectJSON.put(KEY_SESSION_TOKEN, (Object)sessionToken);
            }
            catch (JSONException e) {
                throw new RuntimeException("could not encode value for key: session_token");
            }
        }
        if ((authData = ((EasimartUser.State)state).authData()).size() > 0) {
            try {
                objectJSON.put(KEY_AUTH_DATA, encoder.encode(authData));
            }
            catch (JSONException e) {
                throw new RuntimeException("could not attach key: auth_data");
            }
        }
        return objectJSON;
    }

    @Override
    public <T extends EasimartObject.State.Init<?>> T decode(T builder, JSONObject json, EasimartDecoder decoder) {
        JSONObject newAuthData;
        EasimartUser.State.Builder userBuilder = (EasimartUser.State.Builder)builder;
        String newSessionToken = json.optString(KEY_SESSION_TOKEN, null);
        if (newSessionToken != null) {
            userBuilder.sessionToken(newSessionToken);
            json.remove(KEY_SESSION_TOKEN);
        }
        if ((newAuthData = json.optJSONObject(KEY_AUTH_DATA)) != null) {
            try {
                Iterator i = newAuthData.keys();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    if (newAuthData.isNull(key)) continue;
                    userBuilder.putAuthData(key, (Map)EasimartDecoder.get().decode(newAuthData.getJSONObject(key)));
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            json.remove(KEY_AUTH_DATA);
        }
        return super.decode(builder, json, decoder);
    }
}

