/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Task;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartExecutors;
import co.easimart.EasimartFileUtils;
import co.easimart.EasimartObject;
import co.easimart.EasimartObjectCurrentCoder;
import co.easimart.EasimartObjectStore;
import co.easimart.PointerEncoder;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import org.json.JSONException;
import org.json.JSONObject;

class FileObjectStore<T extends EasimartObject>
implements EasimartObjectStore<T> {
    private final String className;
    private final File file;
    private final EasimartObjectCurrentCoder coder;

    private static void saveToDisk(EasimartObjectCurrentCoder coder, EasimartObject current, File file) {
        JSONObject json = coder.encode(current.getState(), null, PointerEncoder.get());
        try {
            EasimartFileUtils.writeJSONObjectToFile(file, json);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static <T extends EasimartObject> T getFromDisk(EasimartObjectCurrentCoder coder, File file, EasimartObject.State.Init builder) {
        JSONObject json;
        try {
            json = EasimartFileUtils.readFileToJSONObject(file);
        }
        catch (IOException | JSONException e) {
            return null;
        }
        Object newState = ((EasimartObject.State.Init)coder.decode(builder, json, EasimartDecoder.get()).isComplete(true)).build();
        return EasimartObject.from(newState);
    }

    public FileObjectStore(Class<T> clazz, File file, EasimartObjectCurrentCoder coder) {
        this(EasimartObject.getClassName(clazz), file, coder);
    }

    public FileObjectStore(String className, File file, EasimartObjectCurrentCoder coder) {
        this.className = className;
        this.file = file;
        this.coder = coder;
    }

    @Override
    public Task<Void> setAsync(final T object) {
        return Task.call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                FileObjectStore.saveToDisk(FileObjectStore.this.coder, object, FileObjectStore.this.file);
                return null;
            }
        }, (Executor)EasimartExecutors.io());
    }

    @Override
    public Task<T> getAsync() {
        return Task.call((Callable)new Callable<T>(){

            @Override
            public T call() throws Exception {
                if (!FileObjectStore.this.file.exists()) {
                    return null;
                }
                return FileObjectStore.getFromDisk(FileObjectStore.this.coder, FileObjectStore.this.file, EasimartObject.State.newBuilder(FileObjectStore.this.className));
            }
        }, (Executor)EasimartExecutors.io());
    }

    @Override
    public Task<Boolean> existsAsync() {
        return Task.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return FileObjectStore.this.file.exists();
            }
        }, (Executor)EasimartExecutors.io());
    }

    @Override
    public Task<Void> deleteAsync() {
        return Task.call((Callable)new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                if (FileObjectStore.this.file.exists() && !EasimartFileUtils.deleteQuietly(FileObjectStore.this.file)) {
                    throw new RuntimeException("Unable to delete");
                }
                return null;
            }
        }, (Executor)EasimartExecutors.io());
    }
}

