/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartFileUtils;
import co.easimart.EasimartLog;
import co.easimart.EasimartTextUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.UUID;

class InstallationId {
    private static final String TAG = "InstallationId";
    private final Object lock = new Object();
    private final File file;
    private String installationId;

    public InstallationId(File file) {
        this.file = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get() {
        Object object = this.lock;
        synchronized (object) {
            if (this.installationId == null) {
                try {
                    this.installationId = EasimartFileUtils.readFileToString(this.file, "UTF-8");
                }
                catch (FileNotFoundException e) {
                    EasimartLog.i(TAG, "Couldn't find existing installationId file. Creating one instead.");
                }
                catch (IOException e) {
                    EasimartLog.e(TAG, "Unexpected exception reading installation id from disk", e);
                }
            }
            if (this.installationId == null) {
                this.setInternal(UUID.randomUUID().toString());
            }
        }
        return this.installationId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void set(String newInstallationId) {
        Object object = this.lock;
        synchronized (object) {
            if (EasimartTextUtils.isEmpty(newInstallationId) || newInstallationId.equals(this.get())) {
                return;
            }
            this.setInternal(newInstallationId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInternal(String newInstallationId) {
        Object object = this.lock;
        synchronized (object) {
            try {
                EasimartFileUtils.writeStringToFile(this.file, newInstallationId, "UTF-8");
            }
            catch (IOException e) {
                EasimartLog.e(TAG, "Unexpected exception writing installation id to disk", e);
            }
            this.installationId = newInstallationId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.installationId = null;
            EasimartFileUtils.deleteQuietly(this.file);
        }
    }
}

