/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartObject;
import co.easimart.EasimartObjectCoder;
import co.easimart.EasimartRESTSessionCommand;
import co.easimart.EasimartSessionController;
import org.json.JSONObject;

class NetworkSessionController
implements EasimartSessionController {
    private final EasimartHttpClient client;
    private final EasimartObjectCoder coder;

    public NetworkSessionController(EasimartHttpClient client) {
        this.client = client;
        this.coder = EasimartObjectCoder.get();
    }

    @Override
    public Task<EasimartObject.State> getSessionAsync(String sessionToken) {
        EasimartRESTSessionCommand command = EasimartRESTSessionCommand.getCurrentSessionCommand(sessionToken);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartObject.State>(){

            public EasimartObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((EasimartObject.State.Builder)NetworkSessionController.this.coder.decode(new EasimartObject.State.Builder("_Session"), result, EasimartDecoder.get()).isComplete(true)).build();
            }
        });
    }

    @Override
    public Task<Void> revokeAsync(String sessionToken) {
        return EasimartRESTSessionCommand.revoke(sessionToken).executeAsync(this.client).makeVoid();
    }

    @Override
    public Task<EasimartObject.State> upgradeToRevocable(String sessionToken) {
        EasimartRESTSessionCommand command = EasimartRESTSessionCommand.upgradeToRevocableSessionCommand(sessionToken);
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartObject.State>(){

            public EasimartObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                return ((EasimartObject.State.Builder)NetworkSessionController.this.coder.decode(new EasimartObject.State.Builder("_Session"), result, EasimartDecoder.get()).isComplete(true)).build();
            }
        });
    }
}

