/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartObject;
import co.easimart.EasimartObjectStore;
import co.easimart.EasimartQuery;
import java.util.Arrays;
import java.util.List;

class OfflineObjectStore<T extends EasimartObject>
implements EasimartObjectStore<T> {
    private final String className;
    private final String pinName;
    private final EasimartObjectStore<T> legacy;

    private static <T extends EasimartObject> Task<T> migrate(final EasimartObjectStore<T> from, final EasimartObjectStore<T> to) {
        return from.getAsync().onSuccessTask(new Continuation<T, Task<T>>(){

            public Task<T> then(Task<T> task) throws Exception {
                final EasimartObject object = (EasimartObject)task.getResult();
                if (object == null) {
                    return task;
                }
                return Task.whenAll(Arrays.asList(from.deleteAsync(), to.setAsync(object))).continueWith(new Continuation<Void, T>(){

                    public T then(Task<Void> task) throws Exception {
                        return object;
                    }
                });
            }
        });
    }

    public OfflineObjectStore(Class<T> clazz, String pinName, EasimartObjectStore<T> legacy) {
        this(EasimartObject.getClassName(clazz), pinName, legacy);
    }

    public OfflineObjectStore(String className, String pinName, EasimartObjectStore<T> legacy) {
        this.className = className;
        this.pinName = pinName;
        this.legacy = legacy;
    }

    @Override
    public Task<Void> setAsync(final T object) {
        return EasimartObject.unpinAllInBackground(this.pinName).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return object.pinInBackground(OfflineObjectStore.this.pinName, false);
            }
        });
    }

    @Override
    public Task<T> getAsync() {
        EasimartQuery query = EasimartQuery.getQuery(this.className).fromPin(this.pinName).ignoreACLs();
        return query.findInBackground().onSuccessTask(new Continuation<List<T>, Task<T>>(){

            public Task<T> then(Task<List<T>> task) throws Exception {
                List results = (List)task.getResult();
                if (results != null) {
                    if (results.size() == 1) {
                        return Task.forResult(results.get(0));
                    }
                    return EasimartObject.unpinAllInBackground(OfflineObjectStore.this.pinName).cast();
                }
                return Task.forResult(null);
            }
        }).onSuccessTask(new Continuation<T, Task<T>>(){

            public Task<T> then(Task<T> task) throws Exception {
                EasimartObject ldsObject = (EasimartObject)task.getResult();
                if (ldsObject != null) {
                    return task;
                }
                return OfflineObjectStore.migrate(OfflineObjectStore.this.legacy, OfflineObjectStore.this).cast();
            }
        });
    }

    @Override
    public Task<Boolean> existsAsync() {
        EasimartQuery query = EasimartQuery.getQuery(this.className).fromPin(this.pinName).ignoreACLs();
        return query.countInBackground().onSuccessTask((Continuation)new Continuation<Integer, Task<Boolean>>(){

            public Task<Boolean> then(Task<Integer> task) throws Exception {
                boolean exists;
                boolean bl = exists = (Integer)task.getResult() == 1;
                if (exists) {
                    return Task.forResult((Object)true);
                }
                return OfflineObjectStore.this.legacy.existsAsync();
            }
        });
    }

    @Override
    public Task<Void> deleteAsync() {
        final Task<Void> ldsTask = EasimartObject.unpinAllInBackground(this.pinName);
        return Task.whenAll(Arrays.asList(this.legacy.deleteAsync(), ldsTask)).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return ldsTask;
            }
        });
    }
}

