/*
 * Decompiled with CFR 0.152.
 */
package co.easimart.http;

import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class EasimartHttpResponse {
    private final int statusCode;
    private final InputStream content;
    private final long totalSize;
    private final String reasonPhrase;
    private final Map<String, String> headers;
    private final String contentType;

    private EasimartHttpResponse(Builder builder) {
        this.statusCode = builder.statusCode;
        this.content = builder.content;
        this.totalSize = builder.totalSize;
        this.reasonPhrase = builder.reasonPhrase;
        this.headers = Collections.unmodifiableMap(new HashMap(builder.headers));
        this.contentType = builder.contentType;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public InputStream getContent() {
        return this.content;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public String getReasonPhrase() {
        return this.reasonPhrase;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Map<String, String> getAllHeaders() {
        return this.headers;
    }

    public static final class Builder {
        private int statusCode;
        private InputStream content;
        private long totalSize;
        private String reasonPhrase;
        private Map<String, String> headers;
        private String contentType;

        public Builder() {
            this.totalSize = -1L;
            this.headers = new HashMap<String, String>();
        }

        public Builder(EasimartHttpResponse response) {
            this.setStatusCode(response.getStatusCode());
            this.setContent(response.getContent());
            this.setTotalSize(response.getTotalSize());
            this.setContentType(response.getContentType());
            this.setHeaders(response.getAllHeaders());
            this.setReasonPhrase(response.getReasonPhrase());
        }

        public Builder setStatusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder setContent(InputStream content) {
            this.content = content;
            return this;
        }

        public Builder setTotalSize(long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public Builder setReasonPhrase(String reasonPhrase) {
            this.reasonPhrase = reasonPhrase;
            return this;
        }

        public Builder setHeaders(Map<String, String> headers) {
            this.headers = new HashMap<String, String>(headers);
            return this;
        }

        public Builder addHeaders(Map<String, String> headers) {
            this.headers.putAll(headers);
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.put(name, value);
            return this;
        }

        public Builder setContentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public EasimartHttpResponse build() {
            return new EasimartHttpResponse(this);
        }
    }
}

