/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Task;
import co.easimart.EasimartException;
import co.easimart.EasimartExecutors;
import co.easimart.EasimartFileUtils;
import co.easimart.EasimartIOUtils;
import co.easimart.EasimartRequest;
import co.easimart.ProgressCallback;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;

class EasimartAWSRequest
extends EasimartRequest<Void> {
    private final File tempFile;

    public EasimartAWSRequest(EasimartHttpRequest.Method method, String url, File tempFile) {
        super(method, url);
        this.tempFile = tempFile;
    }

    @Override
    protected Task<Void> onResponseAsync(final EasimartHttpResponse response, final ProgressCallback downloadProgressCallback) {
        int statusCode = response.getStatusCode();
        if ((statusCode < 200 || statusCode >= 300) && statusCode != 304) {
            String action = this.method == EasimartHttpRequest.Method.GET ? "Download from" : "Upload to";
            return Task.forError((Exception)new EasimartException(100, String.format("%s S3 failed. %s", action, response.getReasonPhrase())));
        }
        if (this.method != EasimartHttpRequest.Method.GET) {
            return null;
        }
        return Task.call((Callable)new Callable<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Void call() throws Exception {
                long totalSize = response.getTotalSize();
                long downloadedSize = 0L;
                InputStream responseStream = null;
                try {
                    int nRead;
                    responseStream = response.getContent();
                    FileOutputStream tempFileStream = EasimartFileUtils.openOutputStream(EasimartAWSRequest.this.tempFile);
                    byte[] data = new byte[32768];
                    while ((nRead = responseStream.read(data, 0, data.length)) != -1) {
                        tempFileStream.write(data, 0, nRead);
                        downloadedSize += (long)nRead;
                        if (downloadProgressCallback == null || totalSize == -1L) continue;
                        int progressToReport = Math.round((float)downloadedSize / (float)totalSize * 100.0f);
                        downloadProgressCallback.done(progressToReport);
                    }
                    Void void_ = null;
                    return void_;
                }
                finally {
                    EasimartIOUtils.closeQuietly(responseStream);
                }
            }
        }, (Executor)EasimartExecutors.io());
    }
}

