/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartDeleteOperation;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartFieldOperations;
import co.easimart.EasimartObject;
import co.easimart.EasimartSetOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartAddUniqueOperation
implements EasimartFieldOperation {
    protected final LinkedHashSet<Object> objects = new LinkedHashSet();

    public EasimartAddUniqueOperation(Collection<?> col) {
        this.objects.addAll(col);
    }

    public JSONObject encode(EasimartEncoder objectEncoder) throws JSONException {
        JSONObject output = new JSONObject();
        output.put("__op", (Object)"AddUnique");
        output.put("objects", objectEncoder.encode(new ArrayList<Object>(this.objects)));
        return output;
    }

    @Override
    public EasimartFieldOperation mergeWithPrevious(EasimartFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof EasimartDeleteOperation) {
            return new EasimartSetOperation(this.objects);
        }
        if (previous instanceof EasimartSetOperation) {
            Object value = ((EasimartSetOperation)previous).getValue();
            if (value instanceof JSONArray || value instanceof List) {
                return new EasimartSetOperation(this.apply(value, null));
            }
            throw new IllegalArgumentException("You can only add an item to a List or JSONArray.");
        }
        if (previous instanceof EasimartAddUniqueOperation) {
            ArrayList<Object> previousResult = new ArrayList<Object>(((EasimartAddUniqueOperation)previous).objects);
            return new EasimartAddUniqueOperation((List)this.apply(previousResult, null));
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, String key) {
        if (oldValue == null) {
            return new ArrayList<Object>(this.objects);
        }
        if (oldValue instanceof JSONArray) {
            ArrayList<Object> old = EasimartFieldOperations.jsonArrayAsArrayList((JSONArray)oldValue);
            ArrayList newValue = (ArrayList)this.apply(old, key);
            return new JSONArray((Collection)newValue);
        }
        if (oldValue instanceof List) {
            ArrayList result = new ArrayList((List)oldValue);
            HashMap<String, Integer> existingObjectIds = new HashMap<String, Integer>();
            for (int i = 0; i < result.size(); ++i) {
                if (!(result.get(i) instanceof EasimartObject)) continue;
                existingObjectIds.put(((EasimartObject)result.get(i)).getObjectId(), i);
            }
            for (Object e : this.objects) {
                if (e instanceof EasimartObject) {
                    String objectId = ((EasimartObject)e).getObjectId();
                    if (objectId != null && existingObjectIds.containsKey(objectId)) {
                        result.set((Integer)existingObjectIds.get(objectId), e);
                        continue;
                    }
                    if (result.contains(e)) continue;
                    result.add(e);
                    continue;
                }
                if (result.contains(e)) continue;
                result.add(e);
            }
            return result;
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }
}

