/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import android.net.http.AndroidHttpClient;
import co.easimart.EasimartHttpClient;
import co.easimart.http.EasimartHttpBody;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.scheme.PlainSocketFactory;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.conn.tsccm.ThreadSafeClientConnManager;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;

class EasimartApacheHttpClient
extends EasimartHttpClient<HttpUriRequest, HttpResponse> {
    private DefaultHttpClient apacheClient;

    public EasimartApacheHttpClient(int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setStaleCheckingEnabled((HttpParams)params, (boolean)false);
        HttpConnectionParams.setConnectionTimeout((HttpParams)params, (int)socketOperationTimeout);
        HttpConnectionParams.setSoTimeout((HttpParams)params, (int)socketOperationTimeout);
        HttpConnectionParams.setSocketBufferSize((HttpParams)params, (int)8192);
        HttpClientParams.setRedirecting((HttpParams)params, (boolean)false);
        SchemeRegistry schemeRegistry = new SchemeRegistry();
        schemeRegistry.register(new Scheme("http", (SocketFactory)PlainSocketFactory.getSocketFactory(), 80));
        schemeRegistry.register(new Scheme("https", (SocketFactory)SSLCertificateSocketFactory.getHttpSocketFactory((int)socketOperationTimeout, (SSLSessionCache)sslSessionCache), 443));
        String maxConnectionsStr = System.getProperty("http.maxConnections");
        if (maxConnectionsStr != null) {
            int maxConnections = Integer.parseInt(maxConnectionsStr);
            ConnManagerParams.setMaxConnectionsPerRoute((HttpParams)params, (ConnPerRoute)new ConnPerRouteBean(maxConnections));
            ConnManagerParams.setMaxTotalConnections((HttpParams)params, (int)maxConnections);
        }
        String host = System.getProperty("http.proxyHost");
        String portString = System.getProperty("http.proxyPort");
        if (host != null && host.length() != 0 && portString != null && portString.length() != 0) {
            int port = Integer.parseInt(portString);
            HttpHost proxy = new HttpHost(host, port, "http");
            params.setParameter("http.route.default-proxy", (Object)proxy);
        }
        ThreadSafeClientConnManager manager = new ThreadSafeClientConnManager((HttpParams)params, schemeRegistry);
        this.apacheClient = new DefaultHttpClient((ClientConnectionManager)manager, (HttpParams)params);
        this.apacheClient.setHttpRequestRetryHandler((HttpRequestRetryHandler)new DefaultHttpRequestRetryHandler(0, false));
    }

    @Override
    EasimartHttpResponse executeInternal(EasimartHttpRequest request) throws IOException {
        HttpUriRequest apacheRequest = this.getRequest(request);
        HttpResponse apacheResponse = this.apacheClient.execute(apacheRequest);
        return this.getResponse(apacheResponse);
    }

    @Override
    EasimartHttpResponse getResponse(HttpResponse apacheResponse) throws IOException {
        if (apacheResponse == null) {
            throw new IllegalArgumentException("HttpResponse passed to getResponse should not be null.");
        }
        int statusCode = apacheResponse.getStatusLine().getStatusCode();
        InputStream content = this.disableHttpLibraryAutoDecompress() ? apacheResponse.getEntity().getContent() : AndroidHttpClient.getUngzippedContent((HttpEntity)apacheResponse.getEntity());
        int totalSize = -1;
        Header[] contentLengthHeader = apacheResponse.getHeaders("Content-Length");
        if (contentLengthHeader.length > 0) {
            totalSize = Integer.parseInt(contentLengthHeader[0].getValue());
        }
        String reasonPhrase = apacheResponse.getStatusLine().getReasonPhrase();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Header header : apacheResponse.getAllHeaders()) {
            headers.put(header.getName(), header.getValue());
        }
        String contentType = null;
        HttpEntity entity = apacheResponse.getEntity();
        if (entity != null && entity.getContentType() != null) {
            contentType = entity.getContentType().getValue();
        }
        return new EasimartHttpResponse.Builder().setStatusCode(statusCode).setContent(content).setTotalSize(totalSize).setReasonPhrase(reasonPhrase).setHeaders(headers).setContentType(contentType).build();
    }

    @Override
    HttpUriRequest getRequest(EasimartHttpRequest httpRequest) throws IOException {
        HttpGet apacheRequest;
        if (httpRequest == null) {
            throw new IllegalArgumentException("EasimartHttpRequest passed to getApacheRequest should not be null.");
        }
        EasimartHttpRequest.Method method = httpRequest.getMethod();
        String url = httpRequest.getUrl();
        switch (method) {
            case GET: {
                apacheRequest = new HttpGet(url);
                break;
            }
            case DELETE: {
                apacheRequest = new HttpDelete(url);
                break;
            }
            case POST: {
                apacheRequest = new HttpPost(url);
                break;
            }
            case PUT: {
                apacheRequest = new HttpPut(url);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported http method " + method.toString());
            }
        }
        for (Map.Entry<String, String> entry : httpRequest.getAllHeaders().entrySet()) {
            apacheRequest.setHeader(entry.getKey(), entry.getValue());
        }
        AndroidHttpClient.modifyRequestToAcceptGzipResponse((HttpRequest)apacheRequest);
        EasimartHttpBody body = httpRequest.getBody();
        switch (method) {
            case POST: {
                ((HttpPost)apacheRequest).setEntity((HttpEntity)new EasimartApacheHttpEntity(body));
                break;
            }
            case PUT: {
                ((HttpPut)apacheRequest).setEntity((HttpEntity)new EasimartApacheHttpEntity(body));
                break;
            }
        }
        return apacheRequest;
    }

    private static class EasimartApacheHttpEntity
    extends InputStreamEntity {
        private EasimartHttpBody body;

        public EasimartApacheHttpEntity(EasimartHttpBody body) throws IOException {
            super(body.getContent(), body.getContentLength());
            super.setContentType(body.getContentType());
            this.body = body;
        }

        public void writeTo(OutputStream out) throws IOException {
            this.body.writeTo(out);
        }
    }
}

