/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartCloudCodeController;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartException;
import co.easimart.EasimartTaskUtils;
import co.easimart.EasimartUser;
import co.easimart.FunctionCallback;
import java.util.Map;

public final class EasimartCloud {
    static EasimartCloudCodeController getCloudCodeController() {
        return EasimartCorePlugins.getInstance().getCloudCodeController();
    }

    public static <T> Task<T> callFunctionInBackground(final String name, final Map<String, ?> params) {
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask(new Continuation<String, Task<T>>(){

            public Task<T> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return EasimartCloud.getCloudCodeController().callFunctionInBackground(name, params, sessionToken);
            }
        });
    }

    public static <T> T callFunction(String name, Map<String, ?> params) throws EasimartException {
        return EasimartTaskUtils.wait(EasimartCloud.callFunctionInBackground(name, params));
    }

    public static <T> void callFunctionInBackground(String name, Map<String, ?> params, FunctionCallback<T> callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartCloud.callFunctionInBackground(name, params), callback);
    }

    private EasimartCloud() {
    }
}

