/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.util.Base64;
import co.easimart.EasimartDateFormat;
import co.easimart.EasimartFieldOperations;
import co.easimart.EasimartFile;
import co.easimart.EasimartGeoPoint;
import co.easimart.EasimartObject;
import co.easimart.EasimartRelation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartDecoder {
    private static final EasimartDecoder INSTANCE = new EasimartDecoder();

    public static EasimartDecoder get() {
        return INSTANCE;
    }

    protected EasimartDecoder() {
    }

    List<Object> convertJSONArrayToList(JSONArray array) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            list.add(this.decode(array.opt(i)));
        }
        return list;
    }

    Map<String, Object> convertJSONObjectToMap(JSONObject object) {
        HashMap<String, Object> outputMap = new HashMap<String, Object>();
        Iterator it = object.keys();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = object.opt(key);
            outputMap.put(key, this.decode(value));
        }
        return outputMap;
    }

    protected EasimartObject decodePointer(String className, String objectId) {
        return EasimartObject.createWithoutData(className, objectId);
    }

    public Object decode(Object object) {
        if (object instanceof JSONArray) {
            return this.convertJSONArrayToList((JSONArray)object);
        }
        if (!(object instanceof JSONObject)) {
            return object;
        }
        JSONObject jsonObject = (JSONObject)object;
        String opString = jsonObject.optString("__op", null);
        if (opString != null) {
            try {
                return EasimartFieldOperations.decode(jsonObject, this);
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        String typeString = jsonObject.optString("__type", null);
        if (typeString == null) {
            return this.convertJSONObjectToMap(jsonObject);
        }
        if (typeString.equals("Date")) {
            String iso = jsonObject.optString("iso");
            return EasimartDateFormat.getInstance().parse(iso);
        }
        if (typeString.equals("Bytes")) {
            String base64 = jsonObject.optString("base64");
            return Base64.decode((String)base64, (int)2);
        }
        if (typeString.equals("Pointer")) {
            return this.decodePointer(jsonObject.optString("className"), jsonObject.optString("objectId"));
        }
        if (typeString.equals("File")) {
            return new EasimartFile(jsonObject, this);
        }
        if (typeString.equals("GeoPoint")) {
            double longitude;
            double latitude;
            try {
                latitude = jsonObject.getDouble("latitude");
                longitude = jsonObject.getDouble("longitude");
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return new EasimartGeoPoint(latitude, longitude);
        }
        if (typeString.equals("Object")) {
            return EasimartObject.fromJSON(jsonObject, null, true, this);
        }
        if (typeString.equals("Relation")) {
            return new EasimartRelation(jsonObject, this);
        }
        if (typeString.equals("OfflineObject")) {
            throw new RuntimeException("An unexpected offline pointer was encountered.");
        }
        return null;
    }
}

