/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import co.easimart.http.EasimartNetworkInterceptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.zip.GZIPInputStream;

class EasimartDecompressInterceptor
implements EasimartNetworkInterceptor {
    private static final String CONTENT_ENCODING_HEADER = "Content-Encoding";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String GZIP_ENCODING = "gzip";

    EasimartDecompressInterceptor() {
    }

    @Override
    public EasimartHttpResponse intercept(EasimartNetworkInterceptor.Chain chain) throws IOException {
        EasimartHttpRequest request = chain.getRequest();
        EasimartHttpResponse response = chain.proceed(request);
        if (GZIP_ENCODING.equalsIgnoreCase(response.getHeader(CONTENT_ENCODING_HEADER))) {
            HashMap<String, String> newHeaders = new HashMap<String, String>(response.getAllHeaders());
            newHeaders.remove(CONTENT_ENCODING_HEADER);
            newHeaders.put(CONTENT_LENGTH_HEADER, "-1");
            response = new EasimartHttpResponse.Builder(response).setTotalSize(-1L).setHeaders(newHeaders).setContent(new GZIPInputStream(response.getContent())).build();
        }
        return response;
    }
}

