/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartAWSRequest;
import co.easimart.EasimartExecutors;
import co.easimart.EasimartFile;
import co.easimart.EasimartFileUtils;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartPlugins;
import co.easimart.EasimartRESTFileCommand;
import co.easimart.ProgressCallback;
import co.easimart.http.EasimartHttpRequest;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Executor;
import org.json.JSONObject;

class EasimartFileController {
    private final Object lock = new Object();
    private final EasimartHttpClient restClient;
    private final File cachePath;
    private EasimartHttpClient awsClient;

    public EasimartFileController(EasimartHttpClient restClient, File cachePath) {
        this.restClient = restClient;
        this.cachePath = cachePath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EasimartHttpClient awsClient() {
        Object object = this.lock;
        synchronized (object) {
            if (this.awsClient == null) {
                this.awsClient = EasimartPlugins.get().newHttpClient();
            }
            return this.awsClient;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EasimartFileController awsClient(EasimartHttpClient awsClient) {
        Object object = this.lock;
        synchronized (object) {
            this.awsClient = awsClient;
        }
        return this;
    }

    public File getCacheFile(EasimartFile.State state) {
        return new File(this.cachePath, state.name());
    }

    File getTempFile(EasimartFile.State state) {
        if (state.url() == null) {
            return null;
        }
        return new File(this.cachePath, state.url() + ".tmp");
    }

    public boolean isDataAvailable(EasimartFile.State state) {
        return this.getCacheFile(state).exists();
    }

    public void clearCache() {
        File[] files = this.cachePath.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            EasimartFileUtils.deleteQuietly(file);
        }
    }

    public Task<EasimartFile.State> saveAsync(final EasimartFile.State state, final byte[] data, String sessionToken, ProgressCallback uploadProgressCallback, Task<Void> cancellationToken) {
        if (state.url() != null) {
            return Task.forResult((Object)state);
        }
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        EasimartRESTFileCommand command = ((EasimartRESTFileCommand.Builder)new EasimartRESTFileCommand.Builder().fileName(state.name()).data(data).contentType(state.mimeType()).sessionToken(sessionToken)).build();
        command.enableRetrying();
        return command.executeAsync(this.restClient, uploadProgressCallback, null, cancellationToken).onSuccess((Continuation)new Continuation<JSONObject, EasimartFile.State>(){

            public EasimartFile.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                EasimartFile.State newState = new EasimartFile.State.Builder(state).name(result.getString("name")).url(result.getString("url")).build();
                try {
                    EasimartFileUtils.writeByteArrayToFile(EasimartFileController.this.getCacheFile(newState), data);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return newState;
            }
        }, EasimartExecutors.io());
    }

    public Task<EasimartFile.State> saveAsync(final EasimartFile.State state, final File file, String sessionToken, ProgressCallback uploadProgressCallback, Task<Void> cancellationToken) {
        if (state.url() != null) {
            return Task.forResult((Object)state);
        }
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        EasimartRESTFileCommand command = ((EasimartRESTFileCommand.Builder)new EasimartRESTFileCommand.Builder().fileName(state.name()).file(file).contentType(state.mimeType()).sessionToken(sessionToken)).build();
        command.enableRetrying();
        return command.executeAsync(this.restClient, uploadProgressCallback, null, cancellationToken).onSuccess((Continuation)new Continuation<JSONObject, EasimartFile.State>(){

            public EasimartFile.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                EasimartFile.State newState = new EasimartFile.State.Builder(state).name(result.getString("name")).url(result.getString("url")).build();
                try {
                    EasimartFileUtils.copyFile(file, EasimartFileController.this.getCacheFile(newState));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return newState;
            }
        }, EasimartExecutors.io());
    }

    public Task<File> fetchAsync(final EasimartFile.State state, String sessionToken, final ProgressCallback downloadProgressCallback, final Task<Void> cancellationToken) {
        if (cancellationToken != null && cancellationToken.isCancelled()) {
            return Task.cancelled();
        }
        final File cacheFile = this.getCacheFile(state);
        return Task.call((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return cacheFile.exists();
            }
        }, (Executor)EasimartExecutors.io()).continueWithTask((Continuation)new Continuation<Boolean, Task<File>>(){

            public Task<File> then(Task<Boolean> task) throws Exception {
                boolean result = (Boolean)task.getResult();
                if (result) {
                    return Task.forResult((Object)cacheFile);
                }
                if (cancellationToken != null && cancellationToken.isCancelled()) {
                    return Task.cancelled();
                }
                final File tempFile = EasimartFileController.this.getTempFile(state);
                EasimartAWSRequest request = new EasimartAWSRequest(EasimartHttpRequest.Method.GET, state.url(), tempFile);
                return request.executeAsync(EasimartFileController.this.awsClient(), null, downloadProgressCallback, (Task<Void>)cancellationToken).continueWithTask((Continuation)new Continuation<Void, Task<File>>(){

                    public Task<File> then(Task<Void> task) throws Exception {
                        if (cancellationToken != null && cancellationToken.isCancelled()) {
                            throw new CancellationException();
                        }
                        if (task.isFaulted()) {
                            EasimartFileUtils.deleteQuietly(tempFile);
                            return task.cast();
                        }
                        EasimartFileUtils.deleteQuietly(cacheFile);
                        EasimartFileUtils.moveFile(tempFile, cacheFile);
                        return Task.forResult((Object)cacheFile);
                    }
                }, EasimartExecutors.io());
            }
        });
    }
}

