/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartIOUtils;
import co.easimart.http.EasimartHttpBody;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class EasimartFileHttpBody
extends EasimartHttpBody {
    final File file;

    public EasimartFileHttpBody(File file) {
        this(file, null);
    }

    public EasimartFileHttpBody(File file, String contentType) {
        super(contentType, file.length());
        this.file = file;
    }

    @Override
    public InputStream getContent() throws IOException {
        return new FileInputStream(this.file);
    }

    @Override
    public void writeTo(OutputStream out) throws IOException {
        if (out == null) {
            throw new IllegalArgumentException("Output stream can not be null");
        }
        FileInputStream fileInput = new FileInputStream(this.file);
        try {
            EasimartIOUtils.copy(fileInput, out);
        }
        finally {
            EasimartIOUtils.closeQuietly(fileInput);
        }
    }
}

