/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.net.SSLSessionCache;
import android.os.Build;
import co.easimart.EasimartApacheHttpClient;
import co.easimart.EasimartLog;
import co.easimart.EasimartOkHttpClient;
import co.easimart.EasimartURLConnectionHttpClient;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import co.easimart.http.EasimartNetworkInterceptor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

abstract class EasimartHttpClient<LibraryRequest, LibraryResponse> {
    private static final String TAG = "co.easimart.EasimartHttpClient";
    private static final String APACHE_HTTPCLIENT_NAME = "org.apache.http";
    private static final String URLCONNECTION_NAME = "net.java.URLConnection";
    private static final String OKHTTP_NAME = "com.squareup.okhttp";
    private static final String OKHTTPCLIENT_PATH = "com.squareup.okhttp.OkHttpClient";
    private static final String MAX_CONNECTIONS_PROPERTY_NAME = "http.maxConnections";
    private static final String KEEP_ALIVE_PROPERTY_NAME = "http.keepAlive";
    private boolean hasExecuted;
    private List<EasimartNetworkInterceptor> internalInterceptors;
    private List<EasimartNetworkInterceptor> externalInterceptors;

    EasimartHttpClient() {
    }

    public static EasimartHttpClient createClient(int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        EasimartHttpClient httpClient;
        String httpClientLibraryName;
        if (EasimartHttpClient.hasOkHttpOnClasspath()) {
            httpClientLibraryName = OKHTTP_NAME;
            httpClient = new EasimartOkHttpClient(socketOperationTimeout, sslSessionCache);
        } else if (Build.VERSION.SDK_INT >= 19) {
            httpClientLibraryName = URLCONNECTION_NAME;
            httpClient = new EasimartURLConnectionHttpClient(socketOperationTimeout, sslSessionCache);
        } else {
            httpClientLibraryName = APACHE_HTTPCLIENT_NAME;
            httpClient = new EasimartApacheHttpClient(socketOperationTimeout, sslSessionCache);
        }
        EasimartLog.i(TAG, "Using " + httpClientLibraryName + " library for networking communication.");
        return httpClient;
    }

    public static void setMaxConnections(int maxConnections) {
        if (maxConnections <= 0) {
            throw new IllegalArgumentException("Max connections should be large than 0");
        }
        System.setProperty(MAX_CONNECTIONS_PROPERTY_NAME, String.valueOf(maxConnections));
    }

    public static void setKeepAlive(boolean isKeepAlive) {
        System.setProperty(KEEP_ALIVE_PROPERTY_NAME, String.valueOf(isKeepAlive));
    }

    private static boolean hasOkHttpOnClasspath() {
        try {
            Class.forName(OKHTTPCLIENT_PATH);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    abstract EasimartHttpResponse executeInternal(EasimartHttpRequest var1) throws IOException;

    abstract LibraryRequest getRequest(EasimartHttpRequest var1) throws IOException;

    abstract EasimartHttpResponse getResponse(LibraryResponse var1) throws IOException;

    void addInternalInterceptor(EasimartNetworkInterceptor interceptor) {
        if (this.hasExecuted) {
            throw new IllegalStateException("`EasimartHttpClient#addInternalInterceptor(EasimartNetworkInterceptor)` can only be invoked before `EasimartHttpClient` execute any request");
        }
        if (this.internalInterceptors == null) {
            this.internalInterceptors = new ArrayList<EasimartNetworkInterceptor>();
        }
        this.internalInterceptors.add(interceptor);
    }

    void addExternalInterceptor(EasimartNetworkInterceptor interceptor) {
        if (this.externalInterceptors == null) {
            this.externalInterceptors = new ArrayList<EasimartNetworkInterceptor>();
        }
        this.externalInterceptors.add(interceptor);
    }

    public final EasimartHttpResponse execute(EasimartHttpRequest request) throws IOException {
        if (!this.hasExecuted) {
            this.hasExecuted = true;
        }
        EasimartNetworkInterceptorChain chain = new EasimartNetworkInterceptorChain(0, 0, request);
        return chain.proceed(request);
    }

    boolean disableHttpLibraryAutoDecompress() {
        return this.externalInterceptors != null && this.externalInterceptors.size() > 0;
    }

    private class EasimartNetworkInterceptorChain
    implements EasimartNetworkInterceptor.Chain {
        private final int internalIndex;
        private final int externalIndex;
        private final EasimartHttpRequest request;

        EasimartNetworkInterceptorChain(int internalIndex, int externalIndex, EasimartHttpRequest request) {
            this.internalIndex = internalIndex;
            this.externalIndex = externalIndex;
            this.request = request;
        }

        @Override
        public EasimartHttpRequest getRequest() {
            return this.request;
        }

        @Override
        public EasimartHttpResponse proceed(EasimartHttpRequest request) throws IOException {
            if (EasimartHttpClient.this.internalInterceptors != null && this.internalIndex < EasimartHttpClient.this.internalInterceptors.size()) {
                EasimartNetworkInterceptorChain chain = new EasimartNetworkInterceptorChain(this.internalIndex + 1, this.externalIndex, request);
                return ((EasimartNetworkInterceptor)EasimartHttpClient.this.internalInterceptors.get(this.internalIndex)).intercept(chain);
            }
            if (EasimartHttpClient.this.externalInterceptors != null && this.externalIndex < EasimartHttpClient.this.externalInterceptors.size()) {
                EasimartNetworkInterceptorChain chain = new EasimartNetworkInterceptorChain(this.internalIndex, this.externalIndex + 1, request);
                return ((EasimartNetworkInterceptor)EasimartHttpClient.this.externalInterceptors.get(this.externalIndex)).intercept(chain);
            }
            return EasimartHttpClient.this.executeInternal(request);
        }
    }
}

