/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Capture;
import bolts.Continuation;
import bolts.Task;
import co.easimart.DeleteCallback;
import co.easimart.Easimart;
import co.easimart.EasimartACL;
import co.easimart.EasimartAddOperation;
import co.easimart.EasimartAddUniqueOperation;
import co.easimart.EasimartClassName;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartDateFormat;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartDeleteOperation;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartEventuallyQueue;
import co.easimart.EasimartException;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartFile;
import co.easimart.EasimartGeoPoint;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartIncrementOperation;
import co.easimart.EasimartInstallation;
import co.easimart.EasimartJSONUtils;
import co.easimart.EasimartMulticastDelegate;
import co.easimart.EasimartObjectCoder;
import co.easimart.EasimartObjectController;
import co.easimart.EasimartOperationSet;
import co.easimart.EasimartPin;
import co.easimart.EasimartQuery;
import co.easimart.EasimartRESTObjectCommand;
import co.easimart.EasimartRelation;
import co.easimart.EasimartRemoveOperation;
import co.easimart.EasimartRole;
import co.easimart.EasimartSession;
import co.easimart.EasimartSetOperation;
import co.easimart.EasimartTaskUtils;
import co.easimart.EasimartTextUtils;
import co.easimart.EasimartTraverser;
import co.easimart.EasimartUser;
import co.easimart.EventuallyPin;
import co.easimart.FindCallback;
import co.easimart.GetCallback;
import co.easimart.KnownEasimartObjectDecoder;
import co.easimart.LocalIdManager;
import co.easimart.LockSet;
import co.easimart.OfflineStore;
import co.easimart.PointerEncoder;
import co.easimart.PointerOrLocalIdEncoder;
import co.easimart.RefreshCallback;
import co.easimart.SaveCallback;
import co.easimart.TaskQueue;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class EasimartObject {
    static String server = "https://api.parse.com";
    private static final String AUTO_CLASS_NAME = "_Automatic";
    static final String VERSION_NAME = "1.11.1-SNAPSHOT";
    private static final String KEY_OBJECT_ID = "objectId";
    private static final String KEY_CLASS_NAME = "className";
    private static final String KEY_ACL = "ACL";
    private static final String KEY_CREATED_AT = "createdAt";
    private static final String KEY_UPDATED_AT = "updatedAt";
    private static final String KEY_COMPLETE = "__complete";
    private static final String KEY_OPERATIONS = "__operations";
    static final String KEY_IS_DELETING_EVENTUALLY = "__isDeletingEventually";
    private static final String KEY_IS_DELETING_EVENTUALLY_OLD = "isDeletingEventually";
    private static final Map<Class<? extends EasimartObject>, String> classNames = new ConcurrentHashMap<Class<? extends EasimartObject>, String>();
    private static final Map<String, Class<? extends EasimartObject>> objectTypes = new ConcurrentHashMap<String, Class<? extends EasimartObject>>();
    final Object mutex = new Object();
    final TaskQueue taskQueue = new TaskQueue();
    private State state;
    final LinkedList<EasimartOperationSet> operationSetQueue;
    private final Map<String, Object> estimatedData;
    private String localId;
    private final EasimartMulticastDelegate<EasimartObject> saveEvent = new EasimartMulticastDelegate();
    boolean isDeleted;
    int isDeletingEventually;
    private static final ThreadLocal<String> isCreatingPointerForObjectId = new ThreadLocal<String>(){

        @Override
        protected String initialValue() {
            return null;
        }
    };
    private static final String NEW_OFFLINE_OBJECT_ID_PLACEHOLDER = "*** Offline Object ***";
    public static final String DEFAULT_PIN = "_default";

    private static EasimartObjectController getObjectController() {
        return EasimartCorePlugins.getInstance().getObjectController();
    }

    private static LocalIdManager getLocalIdManager() {
        return EasimartCorePlugins.getInstance().getLocalIdManager();
    }

    protected EasimartObject() {
        this(AUTO_CLASS_NAME);
    }

    public EasimartObject(String theClassName) {
        String objectIdForPointer = isCreatingPointerForObjectId.get();
        if (theClassName == null) {
            throw new IllegalArgumentException("You must specify a Easimart class name when creating a new EasimartObject.");
        }
        if (AUTO_CLASS_NAME.equals(theClassName)) {
            theClassName = EasimartObject.getClassName(this.getClass());
        }
        if (this.getClass().equals(EasimartObject.class) && objectTypes.containsKey(theClassName) && !objectTypes.get(theClassName).isInstance(this)) {
            throw new IllegalArgumentException("You must create this type of EasimartObject using EasimartObject.create() or the proper subclass.");
        }
        if (!this.getClass().equals(EasimartObject.class) && !this.getClass().equals(objectTypes.get(theClassName))) {
            throw new IllegalArgumentException("You must register this EasimartObject subclass before instantiating it.");
        }
        this.operationSetQueue = new LinkedList();
        this.operationSetQueue.add(new EasimartOperationSet());
        this.estimatedData = new HashMap<String, Object>();
        State.Init<?> builder = this.newStateBuilder(theClassName);
        if (objectIdForPointer == null) {
            this.setDefaultValues();
            builder.isComplete(true);
        } else {
            if (!objectIdForPointer.equals(NEW_OFFLINE_OBJECT_ID_PLACEHOLDER)) {
                builder.objectId(objectIdForPointer);
            }
            builder.isComplete(false);
        }
        this.state = builder.build();
        OfflineStore store = Easimart.getLocalDatastore();
        if (store != null) {
            store.registerNewObject(this);
        }
    }

    public static EasimartObject create(String className) {
        if (objectTypes.containsKey(className)) {
            try {
                return objectTypes.get(className).newInstance();
            }
            catch (Exception e) {
                if (e instanceof RuntimeException) {
                    throw (RuntimeException)e;
                }
                throw new RuntimeException("Failed to create instance of subclass.", e);
            }
        }
        return new EasimartObject(className);
    }

    public static <T extends EasimartObject> T create(Class<T> subclass) {
        return (T)EasimartObject.create(EasimartObject.getClassName(subclass));
    }

    public static EasimartObject createWithoutData(String className, String objectId) {
        OfflineStore store = Easimart.getLocalDatastore();
        try {
            if (objectId == null) {
                isCreatingPointerForObjectId.set(NEW_OFFLINE_OBJECT_ID_PLACEHOLDER);
            } else {
                isCreatingPointerForObjectId.set(objectId);
            }
            EasimartObject object = null;
            if (store != null && objectId != null) {
                object = store.getObject(className, objectId);
            }
            if (object == null && (object = EasimartObject.create(className)).hasChanges()) {
                throw new IllegalStateException("A EasimartObject subclass default constructor must not make changes to the object that cause it to be dirty.");
            }
            EasimartObject easimartObject = object;
            return easimartObject;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of subclass.", e);
        }
        finally {
            isCreatingPointerForObjectId.set(null);
        }
    }

    public static <T extends EasimartObject> T createWithoutData(Class<T> subclass, String objectId) {
        return (T)EasimartObject.createWithoutData(EasimartObject.getClassName(subclass), objectId);
    }

    private static boolean isAccessible(Member m) {
        return Modifier.isPublic(m.getModifiers()) || m.getDeclaringClass().getPackage().getName().equals("co.easimart") && !Modifier.isPrivate(m.getModifiers()) && !Modifier.isProtected(m.getModifiers());
    }

    public static void registerSubclass(Class<? extends EasimartObject> subclass) {
        Class<? extends EasimartObject> oldValue;
        String className = EasimartObject.getClassName(subclass);
        if (className == null) {
            throw new IllegalArgumentException("No EasimartClassName annotation provided on " + subclass);
        }
        if (subclass.getDeclaredConstructors().length > 0) {
            try {
                if (!EasimartObject.isAccessible(subclass.getDeclaredConstructor(new Class[0]))) {
                    throw new IllegalArgumentException("Default constructor for " + subclass + " is not accessible.");
                }
            }
            catch (NoSuchMethodException e) {
                throw new IllegalArgumentException("No default constructor provided for " + subclass);
            }
        }
        if ((oldValue = objectTypes.get(className)) != null && subclass.isAssignableFrom(oldValue)) {
            return;
        }
        objectTypes.put(className, subclass);
        if (oldValue != null && !subclass.equals(oldValue)) {
            if (className.equals(EasimartObject.getClassName(EasimartUser.class))) {
                EasimartUser.getCurrentUserController().clearFromMemory();
            } else if (className.equals(EasimartObject.getClassName(EasimartInstallation.class))) {
                EasimartInstallation.getCurrentInstallationController().clearFromMemory();
            }
        }
    }

    static void unregisterSubclass(Class<? extends EasimartObject> subclass) {
        EasimartObject.unregisterSubclass(EasimartObject.getClassName(subclass));
    }

    static void unregisterSubclass(String className) {
        objectTypes.remove(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Task<T> enqueueForAll(List<? extends EasimartObject> objects, Continuation<Void, Task<T>> taskStart) {
        final Task.TaskCompletionSource readyToStart = Task.create();
        ArrayList<Lock> locks = new ArrayList<Lock>(objects.size());
        for (EasimartObject easimartObject : objects) {
            locks.add(easimartObject.taskQueue.getLock());
        }
        LockSet lock = new LockSet(locks);
        lock.lock();
        try {
            Task task;
            try {
                task = (Task)taskStart.then(readyToStart.getTask());
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            final ArrayList childTasks = new ArrayList();
            for (EasimartObject easimartObject : objects) {
                easimartObject.taskQueue.enqueue(new Continuation<Void, Task<T>>(){

                    public Task<T> then(Task<Void> task2) throws Exception {
                        childTasks.add(task2);
                        return task;
                    }
                });
            }
            Task.whenAll(childTasks).continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    readyToStart.setResult(null);
                    return null;
                }
            });
            Task task2 = task;
            return task2;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T extends EasimartObject> T from(State state) {
        EasimartObject object = EasimartObject.createWithoutData(state.className(), state.objectId());
        Object object2 = object.mutex;
        synchronized (object2) {
            State newState = state.isComplete() ? state : ((State.Init)((State.Init)object.getState().newBuilder()).apply(state)).build();
            object.setState(newState);
        }
        return (T)object;
    }

    static <T extends EasimartObject> T fromJSON(JSONObject json, String defaultClassName, boolean isComplete) {
        return EasimartObject.fromJSON(json, defaultClassName, isComplete, EasimartDecoder.get());
    }

    static <T extends EasimartObject> T fromJSON(JSONObject json, String defaultClassName, boolean isComplete, EasimartDecoder decoder) {
        String className = json.optString(KEY_CLASS_NAME, defaultClassName);
        if (className == null) {
            return null;
        }
        String objectId = json.optString(KEY_OBJECT_ID, null);
        EasimartObject object = EasimartObject.createWithoutData(className, objectId);
        State newState = object.mergeFromServer(object.getState(), json, decoder, isComplete);
        object.setState(newState);
        return (T)object;
    }

    static <T extends EasimartObject> T fromJSONPayload(JSONObject json, EasimartDecoder decoder) {
        String className = json.optString(KEY_CLASS_NAME);
        if (className == null || EasimartTextUtils.isEmpty(className)) {
            return null;
        }
        String objectId = json.optString(KEY_OBJECT_ID, null);
        EasimartObject object = EasimartObject.createWithoutData(className, objectId);
        object.build(json, decoder);
        return (T)object;
    }

    State.Init<?> newStateBuilder(String className) {
        return new State.Builder(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    State getState() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setState(State newState) {
        Object object = this.mutex;
        synchronized (object) {
            this.setState(newState, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State newState, boolean notifyIfObjectIdChanges) {
        Object object = this.mutex;
        synchronized (object) {
            String oldObjectId = this.state.objectId();
            String newObjectId = newState.objectId();
            this.state = newState;
            if (notifyIfObjectIdChanges && !EasimartTextUtils.equals(oldObjectId, newObjectId)) {
                this.notifyObjectIdChanged(oldObjectId, newObjectId);
            }
            this.rebuildEstimatedData();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getClassName() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state.className();
        }
    }

    public Date getUpdatedAt() {
        long updatedAt = this.getState().updatedAt();
        return updatedAt > 0L ? new Date(updatedAt) : null;
    }

    public Date getCreatedAt() {
        long createdAt = this.getState().createdAt();
        return createdAt > 0L ? new Date(createdAt) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        Object object = this.mutex;
        synchronized (object) {
            return Collections.unmodifiableSet(this.estimatedData.keySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void copyChangesFrom(EasimartObject other) {
        Object object = this.mutex;
        synchronized (object) {
            EasimartOperationSet operations = other.operationSetQueue.getFirst();
            for (String key : operations.keySet()) {
                this.performOperation(key, (EasimartFieldOperation)operations.get(key));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeFromObject(EasimartObject other) {
        Object object = this.mutex;
        synchronized (object) {
            if (this == other) {
                return;
            }
            Object copy = ((State.Init)other.getState().newBuilder()).build();
            this.setState((State)copy, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert(String key) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isDirty(key)) {
                this.currentOperations().remove(key);
                this.rebuildEstimatedData();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void revert() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.isDirty()) {
                this.currentOperations().clear();
                this.rebuildEstimatedData();
            }
        }
    }

    private Map<String, EasimartObject> collectFetchedObjects() {
        final HashMap<String, EasimartObject> fetchedObjects = new HashMap<String, EasimartObject>();
        EasimartTraverser traverser = new EasimartTraverser(){

            @Override
            protected boolean visit(Object object) {
                EasimartObject easimartObject;
                State state;
                if (object instanceof EasimartObject && (state = (easimartObject = (EasimartObject)object).getState()).objectId() != null && state.isComplete()) {
                    fetchedObjects.put(state.objectId(), easimartObject);
                }
                return true;
            }
        };
        traverser.traverse(this.estimatedData);
        return fetchedObjects;
    }

    void build(JSONObject json, EasimartDecoder decoder) {
        try {
            State.Builder builder = (State.Builder)new State.Builder(this.state).isComplete(true);
            builder.clear();
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.equals(KEY_CLASS_NAME)) continue;
                if (key.equals(KEY_OBJECT_ID)) {
                    String newObjectId = json.getString(key);
                    builder.objectId(newObjectId);
                    continue;
                }
                if (key.equals(KEY_CREATED_AT)) {
                    builder.createdAt(EasimartDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_UPDATED_AT)) {
                    builder.updatedAt(EasimartDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                Object value = json.get(key);
                Object decodedObject = decoder.decode(value);
                if (decodedObject instanceof EasimartFieldOperation) {
                    this.performOperation(key, (EasimartFieldOperation)decodedObject);
                    continue;
                }
                this.put(key, decodedObject);
            }
            this.setState(builder.build());
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    State mergeFromServer(State state, JSONObject json, EasimartDecoder decoder, boolean completeData) {
        try {
            Object builder = state.newBuilder();
            if (completeData) {
                ((State.Init)builder).clear();
            }
            ((State.Init)builder).isComplete(state.isComplete() || completeData);
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.equals("__type") || key.equals(KEY_CLASS_NAME)) continue;
                if (key.equals(KEY_OBJECT_ID)) {
                    String newObjectId = json.getString(key);
                    ((State.Init)builder).objectId(newObjectId);
                    continue;
                }
                if (key.equals(KEY_CREATED_AT)) {
                    ((State.Init)builder).createdAt(EasimartDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_UPDATED_AT)) {
                    ((State.Init)builder).updatedAt(EasimartDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_ACL)) {
                    EasimartACL acl = EasimartACL.createACLFromJSONObject(json.getJSONObject(key), decoder);
                    ((State.Init)builder).put(KEY_ACL, acl);
                    continue;
                }
                Object value = json.get(key);
                Object decodedObject = decoder.decode(value);
                ((State.Init)builder).put(key, decodedObject);
            }
            return ((State.Init)builder).build();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject toRest(EasimartEncoder encoder) {
        ArrayList<EasimartOperationSet> operationSetQueueCopy;
        State state;
        Object object = this.mutex;
        synchronized (object) {
            state = this.getState();
            int operationSetQueueSize = this.operationSetQueue.size();
            operationSetQueueCopy = new ArrayList<EasimartOperationSet>(operationSetQueueSize);
            for (int i = 0; i < operationSetQueueSize; ++i) {
                EasimartOperationSet original = this.operationSetQueue.get(i);
                EasimartOperationSet copy = new EasimartOperationSet(original);
                operationSetQueueCopy.add(copy);
            }
        }
        return this.toRest(state, operationSetQueueCopy, encoder);
    }

    JSONObject toRest(State state, List<EasimartOperationSet> operationSetQueue, EasimartEncoder objectEncoder) {
        JSONObject json = new JSONObject();
        try {
            json.put(KEY_CLASS_NAME, (Object)state.className());
            if (state.objectId() != null) {
                json.put(KEY_OBJECT_ID, (Object)state.objectId());
            }
            if (state.createdAt() > 0L) {
                json.put(KEY_CREATED_AT, (Object)EasimartDateFormat.getInstance().format(new Date(state.createdAt())));
            }
            if (state.updatedAt() > 0L) {
                json.put(KEY_UPDATED_AT, (Object)EasimartDateFormat.getInstance().format(new Date(state.updatedAt())));
            }
            for (String key : state.keySet()) {
                Object value = state.get(key);
                json.put(key, objectEncoder.encode(value));
            }
            json.put(KEY_COMPLETE, state.isComplete());
            json.put(KEY_IS_DELETING_EVENTUALLY, this.isDeletingEventually);
            JSONArray operations = new JSONArray();
            for (EasimartOperationSet operationSet : operationSetQueue) {
                operations.put((Object)operationSet.toRest(objectEncoder));
            }
            json.put(KEY_OPERATIONS, (Object)operations);
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeREST(State state, JSONObject json, EasimartDecoder decoder) {
        ArrayList<EasimartOperationSet> saveEventuallyOperationSets = new ArrayList<EasimartOperationSet>();
        Iterator iterator = this.mutex;
        synchronized (iterator) {
            try {
                boolean isComplete = json.getBoolean(KEY_COMPLETE);
                this.isDeletingEventually = EasimartJSONUtils.getInt(json, Arrays.asList(KEY_IS_DELETING_EVENTUALLY, KEY_IS_DELETING_EVENTUALLY_OLD));
                JSONArray operations = json.getJSONArray(KEY_OPERATIONS);
                EasimartOperationSet newerOperations = this.currentOperations();
                this.operationSetQueue.clear();
                EasimartOperationSet current = null;
                for (int i = 0; i < operations.length(); ++i) {
                    JSONObject operationSetJSON = operations.getJSONObject(i);
                    EasimartOperationSet operationSet = EasimartOperationSet.fromRest(operationSetJSON, decoder);
                    if (operationSet.isSaveEventually()) {
                        if (current != null) {
                            this.operationSetQueue.add(current);
                            current = null;
                        }
                        saveEventuallyOperationSets.add(operationSet);
                        this.operationSetQueue.add(operationSet);
                        continue;
                    }
                    if (current != null) {
                        operationSet.mergeFrom(current);
                    }
                    current = operationSet;
                }
                if (current != null) {
                    this.operationSetQueue.add(current);
                }
                this.currentOperations().mergeFrom(newerOperations);
                boolean mergeServerData = false;
                if (state.updatedAt() < 0L) {
                    mergeServerData = true;
                } else if (json.has(KEY_UPDATED_AT)) {
                    Date otherUpdatedAt = EasimartDateFormat.getInstance().parse(json.getString(KEY_UPDATED_AT));
                    if (new Date(state.updatedAt()).compareTo(otherUpdatedAt) < 0) {
                        mergeServerData = true;
                    }
                }
                if (mergeServerData) {
                    JSONObject mergeJSON = EasimartJSONUtils.create(json, Arrays.asList(KEY_COMPLETE, KEY_IS_DELETING_EVENTUALLY, KEY_IS_DELETING_EVENTUALLY_OLD, KEY_OPERATIONS));
                    State newState = this.mergeFromServer(state, mergeJSON, decoder, isComplete);
                    this.setState(newState);
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
        }
        for (EasimartOperationSet operationSet : saveEventuallyOperationSets) {
            this.enqueueSaveEventuallyOperationAsync(operationSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean hasDirtyChildren() {
        Object object = this.mutex;
        synchronized (object) {
            ArrayList<EasimartObject> unsavedChildren = new ArrayList<EasimartObject>();
            EasimartObject.collectDirtyChildren(this.estimatedData, unsavedChildren, null);
            return unsavedChildren.size() > 0;
        }
    }

    public boolean isDirty() {
        return this.isDirty(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDirty(boolean considerChildren) {
        Object object = this.mutex;
        synchronized (object) {
            return this.isDeleted || this.getObjectId() == null || this.hasChanges() || considerChildren && this.hasDirtyChildren();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasChanges() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentOperations().size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasOutstandingOperations() {
        Object object = this.mutex;
        synchronized (object) {
            return this.operationSetQueue.size() > 1;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirty(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentOperations().containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getObjectId() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state.objectId();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setObjectId(String newObjectId) {
        Object object = this.mutex;
        synchronized (object) {
            String oldObjectId = this.state.objectId();
            if (EasimartTextUtils.equals(oldObjectId, newObjectId)) {
                return;
            }
            this.state = ((State.Init)((State.Init)this.state.newBuilder()).objectId(newObjectId)).build();
            this.notifyObjectIdChanged(oldObjectId, newObjectId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String getOrCreateLocalId() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.localId == null) {
                if (this.state.objectId() != null) {
                    throw new IllegalStateException("Attempted to get a localId for an object with an objectId.");
                }
                this.localId = EasimartObject.getLocalIdManager().createLocalId();
            }
            return this.localId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyObjectIdChanged(String oldObjectId, String newObjectId) {
        Object object = this.mutex;
        synchronized (object) {
            OfflineStore store = Easimart.getLocalDatastore();
            if (store != null) {
                store.updateObjectId(this, oldObjectId, newObjectId);
            }
            if (this.localId != null) {
                EasimartObject.getLocalIdManager().setObjectId(this.localId, newObjectId);
                this.localId = null;
            }
        }
    }

    private EasimartRESTObjectCommand currentSaveEventuallyCommand(EasimartOperationSet operations, EasimartEncoder objectEncoder, String sessionToken) throws EasimartException {
        State state = this.getState();
        JSONObject objectJSON = this.toJSONObjectForSaving(state, operations, objectEncoder);
        EasimartRESTObjectCommand command = EasimartRESTObjectCommand.saveObjectCommand(state, objectJSON, sessionToken);
        command.enableRetrying();
        return command;
    }

    <T extends State> JSONObject toJSONObjectForSaving(T state, EasimartOperationSet operations, EasimartEncoder objectEncoder) {
        JSONObject objectJSON = new JSONObject();
        try {
            for (String key : operations.keySet()) {
                EasimartFieldOperation operation = (EasimartFieldOperation)operations.get(key);
                objectJSON.put(key, objectEncoder.encode(operation));
            }
            if (state.objectId() != null) {
                objectJSON.put(KEY_OBJECT_ID, (Object)state.objectId());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> handleSaveResultAsync(JSONObject result, EasimartOperationSet operationsBeforeSave) {
        State newState = null;
        if (result != null) {
            Object object = this.mutex;
            synchronized (object) {
                Map<String, EasimartObject> fetchedObjects = this.collectFetchedObjects();
                KnownEasimartObjectDecoder decoder = new KnownEasimartObjectDecoder(fetchedObjects);
                newState = (State)((State.Init)((State.Init)EasimartObjectCoder.get().decode(((State.Init)this.getState().newBuilder()).clear(), result, decoder)).isComplete(false)).build();
            }
        }
        return this.handleSaveResultAsync(newState, operationsBeforeSave);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> handleSaveResultAsync(final State result, final EasimartOperationSet operationsBeforeSave) {
        Task task = Task.forResult((Object)null);
        boolean success = result != null;
        Object object = this.mutex;
        synchronized (object) {
            ListIterator<EasimartOperationSet> opIterator = this.operationSetQueue.listIterator(this.operationSetQueue.indexOf(operationsBeforeSave));
            opIterator.next();
            opIterator.remove();
            if (!success) {
                EasimartOperationSet nextOperation = opIterator.next();
                nextOperation.mergeFrom(operationsBeforeSave);
                return task;
            }
        }
        final OfflineStore store = Easimart.getLocalDatastore();
        if (store != null) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return store.fetchLocallyAsync(EasimartObject.this).makeVoid();
                }
            });
        }
        task = task.continueWith((Continuation)new Continuation<Void, Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void then(Task<Void> task) throws Exception {
                Object object = EasimartObject.this.mutex;
                synchronized (object) {
                    State newState = result.isComplete() ? result : ((State.Init)((State.Init)((State.Init)EasimartObject.this.getState().newBuilder()).apply(operationsBeforeSave)).apply(result)).build();
                    EasimartObject.this.setState(newState);
                }
                return null;
            }
        });
        if (store != null) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return store.updateDataForObjectAsync(EasimartObject.this);
                }
            });
        }
        task = task.onSuccess((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                EasimartObject.this.saveEvent.invoke(EasimartObject.this, null);
                return null;
            }
        });
        return task;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EasimartOperationSet startSave() {
        Object object = this.mutex;
        synchronized (object) {
            EasimartOperationSet currentOperations = this.currentOperations();
            this.operationSetQueue.addLast(new EasimartOperationSet());
            return currentOperations;
        }
    }

    void validateSave() {
    }

    public final void save() throws EasimartException {
        EasimartTaskUtils.wait(this.saveInBackground());
    }

    public final Task<Void> saveInBackground() {
        return EasimartUser.getCurrentUserAsync().onSuccessTask((Continuation)new Continuation<EasimartUser, Task<String>>(){

            public Task<String> then(Task<EasimartUser> task) throws Exception {
                EasimartUser current = (EasimartUser)task.getResult();
                if (current == null) {
                    return Task.forResult(null);
                }
                if (!current.isLazy()) {
                    return Task.forResult((Object)current.getSessionToken());
                }
                if (!EasimartObject.this.isDataAvailable(EasimartObject.KEY_ACL)) {
                    return Task.forResult(null);
                }
                final EasimartACL acl = EasimartObject.this.getACL(false);
                if (acl == null) {
                    return Task.forResult(null);
                }
                final EasimartUser user = acl.getUnresolvedUser();
                if (user == null || !user.isCurrentUser()) {
                    return Task.forResult(null);
                }
                return user.saveAsync(null).onSuccess((Continuation)new Continuation<Void, String>(){

                    public String then(Task<Void> task) throws Exception {
                        if (acl.hasUnresolvedUser()) {
                            throw new IllegalStateException("ACL has an unresolved EasimartUser. Save or sign up before attempting to serialize the ACL.");
                        }
                        return user.getSessionToken();
                    }
                });
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return EasimartObject.this.saveAsync(sessionToken);
            }
        });
    }

    Task<Void> saveAsync(final String sessionToken) {
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return EasimartObject.this.saveAsync(sessionToken, toAwait);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> saveAsync(final String sessionToken, Task<Void> toAwait) {
        Task<Void> task;
        EasimartOperationSet operations;
        if (!this.isDirty()) {
            return Task.forResult(null);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.updateBeforeSave();
            this.validateSave();
            operations = this.startSave();
        }
        Object object2 = this.mutex;
        synchronized (object2) {
            task = EasimartObject.deepSaveAsync(this.estimatedData, sessionToken);
        }
        return task.onSuccessTask(TaskQueue.waitFor(toAwait)).onSuccessTask((Continuation)new Continuation<Void, Task<State>>(){

            public Task<State> then(Task<Void> task) throws Exception {
                Map fetchedObjects = EasimartObject.this.collectFetchedObjects();
                KnownEasimartObjectDecoder decoder = new KnownEasimartObjectDecoder(fetchedObjects);
                return EasimartObject.getObjectController().saveAsync(EasimartObject.this.getState(), operations, sessionToken, decoder);
            }
        }).continueWithTask((Continuation)new Continuation<State, Task<Void>>(){

            public Task<Void> then(final Task<State> saveTask) throws Exception {
                State result = (State)saveTask.getResult();
                return EasimartObject.this.handleSaveResultAsync(result, operations).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        if (task.isFaulted() || task.isCancelled()) {
                            return task;
                        }
                        return saveTask.makeVoid();
                    }
                });
            }
        });
    }

    Task<JSONObject> saveAsync(EasimartHttpClient client, EasimartOperationSet operationSet, String sessionToken) throws EasimartException {
        EasimartRESTObjectCommand command = this.currentSaveEventuallyCommand(operationSet, PointerEncoder.get(), sessionToken);
        return command.executeAsync(client);
    }

    public final void saveInBackground(SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.saveInBackground(), callback);
    }

    void validateSaveEventually() throws EasimartException {
    }

    public final void saveEventually(SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.saveEventually(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task<Void> saveEventually() {
        EasimartRESTObjectCommand command;
        EasimartOperationSet operationSet;
        if (!this.isDirty()) {
            Easimart.getEventuallyQueue().fakeObjectUpdate();
            return Task.forResult(null);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.updateBeforeSave();
            try {
                this.validateSaveEventually();
            }
            catch (EasimartException e) {
                return Task.forError((Exception)e);
            }
            ArrayList<EasimartObject> unsavedChildren = new ArrayList<EasimartObject>();
            EasimartObject.collectDirtyChildren(this.estimatedData, unsavedChildren, null);
            String localId = null;
            if (this.getObjectId() == null) {
                localId = this.getOrCreateLocalId();
            }
            operationSet = this.startSave();
            operationSet.setIsSaveEventually(true);
            String sessionToken = EasimartUser.getCurrentSessionToken();
            try {
                command = this.currentSaveEventuallyCommand(operationSet, PointerOrLocalIdEncoder.get(), sessionToken);
                command.setLocalId(localId);
                command.setOperationSetUUID(operationSet.getUUID());
                command.retainLocalIds();
                for (EasimartObject object2 : unsavedChildren) {
                    object2.saveEventually();
                }
            }
            catch (EasimartException exception) {
                throw new IllegalStateException("Unable to saveEventually.", exception);
            }
        }
        EasimartEventuallyQueue cache = Easimart.getEventuallyQueue();
        Task<JSONObject> runEventuallyTask = cache.enqueueEventuallyAsync(command, this);
        this.enqueueSaveEventuallyOperationAsync(operationSet);
        command.releaseLocalIds();
        Task handleSaveResultTask = Easimart.isLocalDatastoreEnabled() ? runEventuallyTask.makeVoid() : runEventuallyTask.onSuccessTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

            public Task<Void> then(Task<JSONObject> task) throws Exception {
                JSONObject json = (JSONObject)task.getResult();
                return EasimartObject.this.handleSaveEventuallyResultAsync(json, operationSet);
            }
        });
        return handleSaveResultTask;
    }

    private Task<Void> enqueueSaveEventuallyOperationAsync(final EasimartOperationSet operationSet) {
        if (!operationSet.isSaveEventually()) {
            throw new IllegalStateException("This should only be used to enqueue saveEventually operation sets");
        }
        return this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> task) throws Exception {
                        EasimartEventuallyQueue cache = Easimart.getEventuallyQueue();
                        return cache.waitForOperationSetAndEventuallyPin(operationSet, null).makeVoid();
                    }
                });
            }
        });
    }

    Task<Void> handleSaveEventuallyResultAsync(JSONObject json, EasimartOperationSet operationSet) {
        final boolean success = json != null;
        Task<Void> handleSaveResultTask = this.handleSaveResultAsync(json, operationSet);
        return handleSaveResultTask.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                if (success) {
                    Easimart.getEventuallyQueue().notifyTestHelper(5);
                }
                return task;
            }
        });
    }

    void updateBeforeSave() {
    }

    public final void deleteEventually(DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.deleteEventually(), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Task<Void> deleteEventually() {
        Task<JSONObject> runEventuallyTask;
        Object object = this.mutex;
        synchronized (object) {
            this.validateDelete();
            ++this.isDeletingEventually;
            String localId = null;
            if (this.getObjectId() == null) {
                localId = this.getOrCreateLocalId();
            }
            String sessionToken = EasimartUser.getCurrentSessionToken();
            EasimartRESTObjectCommand command = EasimartRESTObjectCommand.deleteObjectCommand(this.getState(), sessionToken);
            command.enableRetrying();
            command.setLocalId(localId);
            runEventuallyTask = Easimart.getEventuallyQueue().enqueueEventuallyAsync(command, this);
        }
        Task handleDeleteResultTask = Easimart.isLocalDatastoreEnabled() ? runEventuallyTask.makeVoid() : runEventuallyTask.onSuccessTask((Continuation)new Continuation<JSONObject, Task<Void>>(){

            public Task<Void> then(Task<JSONObject> task) throws Exception {
                return EasimartObject.this.handleDeleteEventuallyResultAsync();
            }
        });
        return handleDeleteResultTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> handleDeleteEventuallyResultAsync() {
        Object object = this.mutex;
        synchronized (object) {
            --this.isDeletingEventually;
        }
        Task<Void> handleDeleteResultTask = this.handleDeleteResultAsync();
        return handleDeleteResultTask.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                Easimart.getEventuallyQueue().notifyTestHelper(6);
                return task;
            }
        });
    }

    Task<Void> handleFetchResultAsync(final State result) {
        Task task = Task.forResult((Object)null);
        final OfflineStore store = Easimart.getLocalDatastore();
        if (store != null) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return store.fetchLocallyAsync(EasimartObject.this).makeVoid();
                }
            }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    if (task.getError() instanceof EasimartException && ((EasimartException)task.getError()).getCode() == 120) {
                        return null;
                    }
                    return task;
                }
            });
        }
        task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<Void> then(Task<Void> task) throws Exception {
                Object object = EasimartObject.this.mutex;
                synchronized (object) {
                    State newState = result.isComplete() ? result : ((State.Init)((State.Init)EasimartObject.this.getState().newBuilder()).apply(result)).build();
                    EasimartObject.this.setState(newState);
                }
                return null;
            }
        });
        if (store != null) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return store.updateDataForObjectAsync(EasimartObject.this);
                }
            }).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    if (task.getError() instanceof EasimartException && ((EasimartException)task.getError()).getCode() == 120) {
                        return null;
                    }
                    return task;
                }
            });
        }
        return task;
    }

    @Deprecated
    public final void refresh() throws EasimartException {
        this.fetch();
    }

    @Deprecated
    public final void refreshInBackground(RefreshCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.fetchInBackground(), callback);
    }

    public <T extends EasimartObject> T fetch() throws EasimartException {
        return (T)((EasimartObject)EasimartTaskUtils.wait(this.fetchInBackground()));
    }

    <T extends EasimartObject> Task<T> fetchAsync(final String sessionToken, Task<Void> toAwait) {
        return toAwait.onSuccessTask((Continuation)new Continuation<Void, Task<State>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<State> then(Task<Void> task) throws Exception {
                Map fetchedObjects;
                State state;
                Object object = EasimartObject.this.mutex;
                synchronized (object) {
                    state = EasimartObject.this.getState();
                    fetchedObjects = EasimartObject.this.collectFetchedObjects();
                }
                KnownEasimartObjectDecoder decoder = new KnownEasimartObjectDecoder(fetchedObjects);
                return EasimartObject.getObjectController().fetchAsync(state, sessionToken, decoder);
            }
        }).onSuccessTask((Continuation)new Continuation<State, Task<Void>>(){

            public Task<Void> then(Task<State> task) throws Exception {
                State result = (State)task.getResult();
                return EasimartObject.this.handleFetchResultAsync(result);
            }
        }).onSuccess(new Continuation<Void, T>(){

            public T then(Task<Void> task) throws Exception {
                return EasimartObject.this;
            }
        });
    }

    public final <T extends EasimartObject> Task<T> fetchInBackground() {
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask(new Continuation<String, Task<T>>(){

            public Task<T> then(Task<String> task) throws Exception {
                final String sessionToken = (String)task.getResult();
                return EasimartObject.this.taskQueue.enqueue(new Continuation<Void, Task<T>>(){

                    public Task<T> then(Task<Void> toAwait) throws Exception {
                        return EasimartObject.this.fetchAsync(sessionToken, toAwait);
                    }
                });
            }
        });
    }

    public final <T extends EasimartObject> void fetchInBackground(GetCallback<T> callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.fetchInBackground(), callback);
    }

    public final <T extends EasimartObject> Task<T> fetchIfNeededInBackground() {
        if (this.isDataAvailable()) {
            return Task.forResult((Object)this);
        }
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask(new Continuation<String, Task<T>>(){

            public Task<T> then(Task<String> task) throws Exception {
                final String sessionToken = (String)task.getResult();
                return EasimartObject.this.taskQueue.enqueue(new Continuation<Void, Task<T>>(){

                    public Task<T> then(Task<Void> toAwait) throws Exception {
                        if (EasimartObject.this.isDataAvailable()) {
                            return Task.forResult((Object)EasimartObject.this);
                        }
                        return EasimartObject.this.fetchAsync(sessionToken, toAwait);
                    }
                });
            }
        });
    }

    public <T extends EasimartObject> T fetchIfNeeded() throws EasimartException {
        return (T)((EasimartObject)EasimartTaskUtils.wait(this.fetchIfNeededInBackground()));
    }

    public final <T extends EasimartObject> void fetchIfNeededInBackground(GetCallback<T> callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.fetchIfNeededInBackground(), callback);
    }

    void validateDelete() {
    }

    private Task<Void> deleteAsync(final String sessionToken, Task<Void> toAwait) {
        this.validateDelete();
        return toAwait.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                if (EasimartObject.this.state.objectId() == null) {
                    return task.cast();
                }
                return EasimartObject.this.deleteAsync(sessionToken);
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return EasimartObject.this.handleDeleteResultAsync();
            }
        });
    }

    Task<Void> deleteAsync(String sessionToken) throws EasimartException {
        return EasimartObject.getObjectController().deleteAsync(this.getState(), sessionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> handleDeleteResultAsync() {
        Task task = Task.forResult(null);
        Object object = this.mutex;
        synchronized (object) {
            this.isDeleted = true;
        }
        final OfflineStore store = Easimart.getLocalDatastore();
        if (store != null) {
            task = task.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public Task<Void> then(Task<Void> task) throws Exception {
                    Object object = EasimartObject.this.mutex;
                    synchronized (object) {
                        if (EasimartObject.this.isDeleted) {
                            store.unregisterObject(EasimartObject.this);
                            return store.deleteDataForObjectAsync(EasimartObject.this);
                        }
                        return store.updateDataForObjectAsync(EasimartObject.this);
                    }
                }
            });
        }
        return task;
    }

    public final Task<Void> deleteInBackground() {
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                final String sessionToken = (String)task.getResult();
                return EasimartObject.this.taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> toAwait) throws Exception {
                        return EasimartObject.this.deleteAsync(sessionToken, (Task<Void>)toAwait);
                    }
                });
            }
        });
    }

    public final void delete() throws EasimartException {
        EasimartTaskUtils.wait(this.deleteInBackground());
    }

    public final void deleteInBackground(DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.deleteInBackground(), callback);
    }

    private static <T extends EasimartObject> Task<Void> deleteAllAsync(List<T> objects, final String sessionToken) {
        if (objects.size() == 0) {
            return Task.forResult(null);
        }
        int objectCount = objects.size();
        final ArrayList<EasimartObject> uniqueObjects = new ArrayList<EasimartObject>(objectCount);
        HashSet<String> idSet = new HashSet<String>();
        for (int i = 0; i < objectCount; ++i) {
            EasimartObject obj = (EasimartObject)objects.get(i);
            if (idSet.contains(obj.getObjectId())) continue;
            idSet.add(obj.getObjectId());
            uniqueObjects.add(obj);
        }
        return EasimartObject.enqueueForAll(uniqueObjects, new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> toAwait) throws Exception {
                return EasimartObject.deleteAllAsync(uniqueObjects, sessionToken, (Task<Void>)toAwait);
            }
        });
    }

    private static <T extends EasimartObject> Task<Void> deleteAllAsync(final List<T> uniqueObjects, final String sessionToken, Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                int objectCount = uniqueObjects.size();
                ArrayList<State> states = new ArrayList<State>(objectCount);
                for (int i = 0; i < objectCount; ++i) {
                    EasimartObject object = (EasimartObject)uniqueObjects.get(i);
                    object.validateDelete();
                    states.add(object.getState());
                }
                List<Task<Void>> batchTasks = EasimartObject.getObjectController().deleteAllAsync(states, sessionToken);
                ArrayList<Task> tasks = new ArrayList<Task>(objectCount);
                for (int i = 0; i < objectCount; ++i) {
                    Task<Void> batchTask = batchTasks.get(i);
                    final EasimartObject object = (EasimartObject)uniqueObjects.get(i);
                    tasks.add(batchTask.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                        public Task<Void> then(final Task<Void> batchTask) throws Exception {
                            return object.handleDeleteResultAsync().continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                public Task<Void> then(Task<Void> task) throws Exception {
                                    return batchTask;
                                }
                            });
                        }
                    }));
                }
                return Task.whenAll(tasks);
            }
        });
    }

    public static <T extends EasimartObject> void deleteAll(List<T> objects) throws EasimartException {
        EasimartTaskUtils.wait(EasimartObject.deleteAllInBackground(objects));
    }

    public static <T extends EasimartObject> void deleteAllInBackground(List<T> objects, DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.deleteAllInBackground(objects), callback);
    }

    public static <T extends EasimartObject> Task<Void> deleteAllInBackground(final List<T> objects) {
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return EasimartObject.deleteAllAsync(objects, sessionToken);
            }
        });
    }

    private static void collectDirtyChildren(Object node, final Collection<EasimartObject> dirtyChildren, final Collection<EasimartFile> dirtyFiles, final Set<EasimartObject> alreadySeen, final Set<EasimartObject> alreadySeenNew) {
        new EasimartTraverser(){

            @Override
            protected boolean visit(Object node) {
                if (node instanceof EasimartFile) {
                    if (dirtyFiles == null) {
                        return true;
                    }
                    EasimartFile file = (EasimartFile)node;
                    if (file.getUrl() == null) {
                        dirtyFiles.add(file);
                    }
                    return true;
                }
                if (!(node instanceof EasimartObject)) {
                    return true;
                }
                if (dirtyChildren == null) {
                    return true;
                }
                EasimartObject object = (EasimartObject)node;
                HashSet<EasimartObject> seen = alreadySeen;
                HashSet<EasimartObject> seenNew = alreadySeenNew;
                if (object.getObjectId() != null) {
                    seenNew = new HashSet<EasimartObject>();
                } else {
                    if (seenNew.contains(object)) {
                        throw new RuntimeException("Found a circular dependency while saving.");
                    }
                    seenNew = new HashSet(seenNew);
                    seenNew.add(object);
                }
                if (seen.contains(object)) {
                    return true;
                }
                seen = new HashSet<EasimartObject>(seen);
                seen.add(object);
                EasimartObject.collectDirtyChildren(object.estimatedData, dirtyChildren, dirtyFiles, seen, seenNew);
                if (object.isDirty(false)) {
                    dirtyChildren.add(object);
                }
                return true;
            }
        }.setYieldRoot(true).traverse(node);
    }

    private static void collectDirtyChildren(Object node, Collection<EasimartObject> dirtyChildren, Collection<EasimartFile> dirtyFiles) {
        EasimartObject.collectDirtyChildren(node, dirtyChildren, dirtyFiles, new HashSet<EasimartObject>(), new HashSet<EasimartObject>());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean canBeSerialized() {
        Object object = this.mutex;
        synchronized (object) {
            final Capture result = new Capture((Object)true);
            new EasimartTraverser(){

                @Override
                protected boolean visit(Object value) {
                    EasimartObject object;
                    EasimartFile file;
                    if (value instanceof EasimartFile && (file = (EasimartFile)value).isDirty()) {
                        result.set((Object)false);
                    }
                    if (value instanceof EasimartObject && (object = (EasimartObject)value).getObjectId() == null) {
                        result.set((Object)false);
                    }
                    return (Boolean)result.get();
                }
            }.setYieldRoot(false).setTraverseEasimartObjects(true).traverse(this);
            return (Boolean)result.get();
        }
    }

    private static Task<Void> deepSaveAsync(Object object, final String sessionToken) {
        HashSet<EasimartObject> objects = new HashSet<EasimartObject>();
        HashSet<EasimartFile> files = new HashSet<EasimartFile>();
        EasimartObject.collectDirtyChildren(object, objects, files);
        HashSet<EasimartUser> users = new HashSet<EasimartUser>();
        for (EasimartObject o : objects) {
            Object user;
            if (!(o instanceof EasimartUser) || !((EasimartUser)(user = (EasimartUser)o)).isLazy()) continue;
            users.add((EasimartUser)o);
        }
        objects.removeAll(users);
        final AtomicBoolean filesComplete = new AtomicBoolean(false);
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>();
        for (EasimartFile file : files) {
            tasks.add(file.saveAsync(sessionToken, null, null));
        }
        Task filesTask = Task.whenAll(tasks).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                filesComplete.set(true);
                return null;
            }
        });
        final AtomicBoolean usersComplete = new AtomicBoolean(false);
        tasks = new ArrayList();
        for (EasimartUser user : users) {
            tasks.add(user.saveAsync(sessionToken));
        }
        Task usersTask = Task.whenAll(tasks).continueWith((Continuation)new Continuation<Void, Void>(){

            public Void then(Task<Void> task) throws Exception {
                usersComplete.set(true);
                return null;
            }
        });
        final Capture remaining = new Capture(objects);
        Task objectsTask = Task.forResult(null).continueWhile((Callable)new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                return ((Set)remaining.get()).size() > 0;
            }
        }, (Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                final ArrayList<EasimartObject> current = new ArrayList<EasimartObject>();
                HashSet<EasimartObject> nextBatch = new HashSet<EasimartObject>();
                for (EasimartObject obj : (Set)remaining.get()) {
                    if (obj.canBeSerialized()) {
                        current.add(obj);
                        continue;
                    }
                    nextBatch.add(obj);
                }
                remaining.set(nextBatch);
                if (current.size() == 0 && filesComplete.get() && usersComplete.get()) {
                    throw new RuntimeException("Unable to save a EasimartObject with a relation to a cycle.");
                }
                if (current.size() == 0) {
                    return Task.forResult(null);
                }
                return EasimartObject.enqueueForAll(current, new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(Task<Void> toAwait) throws Exception {
                        return EasimartObject.saveAllAsync(current, sessionToken, (Task<Void>)toAwait);
                    }
                });
            }
        });
        return Task.whenAll(Arrays.asList(filesTask, usersTask, objectsTask));
    }

    private static <T extends EasimartObject> Task<Void> saveAllAsync(final List<T> uniqueObjects, final String sessionToken, Task<Void> toAwait) {
        return toAwait.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                int objectCount = uniqueObjects.size();
                ArrayList<State> states = new ArrayList<State>(objectCount);
                ArrayList<EasimartOperationSet> operationsList = new ArrayList<EasimartOperationSet>(objectCount);
                ArrayList<EasimartDecoder> decoders = new ArrayList<EasimartDecoder>(objectCount);
                for (int i = 0; i < objectCount; ++i) {
                    EasimartObject object = (EasimartObject)uniqueObjects.get(i);
                    object.updateBeforeSave();
                    object.validateSave();
                    states.add(object.getState());
                    operationsList.add(object.startSave());
                    Map fetchedObjects = object.collectFetchedObjects();
                    decoders.add(new KnownEasimartObjectDecoder(fetchedObjects));
                }
                List<Task<State>> batchTasks = EasimartObject.getObjectController().saveAllAsync(states, operationsList, sessionToken, decoders);
                ArrayList<Task> tasks = new ArrayList<Task>(objectCount);
                for (int i = 0; i < objectCount; ++i) {
                    Task<State> batchTask = batchTasks.get(i);
                    final EasimartObject object = (EasimartObject)uniqueObjects.get(i);
                    final EasimartOperationSet operations = (EasimartOperationSet)operationsList.get(i);
                    tasks.add(batchTask.continueWithTask((Continuation)new Continuation<State, Task<Void>>(){

                        public Task<Void> then(final Task<State> batchTask) throws Exception {
                            State result = (State)batchTask.getResult();
                            return object.handleSaveResultAsync(result, operations).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                                public Task<Void> then(Task<Void> task) throws Exception {
                                    if (task.isFaulted() || task.isCancelled()) {
                                        return task;
                                    }
                                    return batchTask.makeVoid();
                                }
                            });
                        }
                    }));
                }
                return Task.whenAll(tasks);
            }
        });
    }

    public static <T extends EasimartObject> void saveAll(List<T> objects) throws EasimartException {
        EasimartTaskUtils.wait(EasimartObject.saveAllInBackground(objects));
    }

    public static <T extends EasimartObject> void saveAllInBackground(List<T> objects, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.saveAllInBackground(objects), callback);
    }

    public static <T extends EasimartObject> Task<Void> saveAllInBackground(final List<T> objects) {
        return EasimartUser.getCurrentUserAsync().onSuccessTask((Continuation)new Continuation<EasimartUser, Task<String>>(){

            public Task<String> then(Task<EasimartUser> task) throws Exception {
                EasimartUser current = (EasimartUser)task.getResult();
                if (current == null) {
                    return Task.forResult(null);
                }
                if (!current.isLazy()) {
                    return Task.forResult((Object)current.getSessionToken());
                }
                for (EasimartObject object : objects) {
                    EasimartUser user;
                    EasimartACL acl;
                    if (!object.isDataAvailable(EasimartObject.KEY_ACL) || (acl = object.getACL(false)) == null || (user = acl.getUnresolvedUser()) == null || !user.isCurrentUser()) continue;
                    return user.saveAsync(null).onSuccess((Continuation)new Continuation<Void, String>(){

                        public String then(Task<Void> task) throws Exception {
                            if (acl.hasUnresolvedUser()) {
                                throw new IllegalStateException("ACL has an unresolved EasimartUser. Save or sign up before attempting to serialize the ACL.");
                            }
                            return user.getSessionToken();
                        }
                    });
                }
                return Task.forResult(null);
            }
        }).onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return EasimartObject.deepSaveAsync(objects, sessionToken);
            }
        });
    }

    public static <T extends EasimartObject> Task<List<T>> fetchAllIfNeededInBackground(List<T> objects) {
        return EasimartObject.fetchAllAsync(objects, true);
    }

    public static <T extends EasimartObject> List<T> fetchAllIfNeeded(List<T> objects) throws EasimartException {
        return EasimartTaskUtils.wait(EasimartObject.fetchAllIfNeededInBackground(objects));
    }

    public static <T extends EasimartObject> void fetchAllIfNeededInBackground(List<T> objects, FindCallback<T> callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.fetchAllIfNeededInBackground(objects), callback);
    }

    private static <T extends EasimartObject> Task<List<T>> fetchAllAsync(final List<T> objects, final boolean onlyIfNeeded) {
        return EasimartUser.getCurrentUserAsync().onSuccessTask(new Continuation<EasimartUser, Task<List<T>>>(){

            public Task<List<T>> then(Task<EasimartUser> task) throws Exception {
                final EasimartUser user = (EasimartUser)task.getResult();
                return EasimartObject.enqueueForAll(objects, new Continuation<Void, Task<List<T>>>(){

                    public Task<List<T>> then(Task<Void> task) throws Exception {
                        return EasimartObject.fetchAllAsync(objects, user, onlyIfNeeded, (Task<Void>)task);
                    }
                });
            }
        });
    }

    private static <T extends EasimartObject> Task<List<T>> fetchAllAsync(final List<T> objects, final EasimartUser user, final boolean onlyIfNeeded, Task<Void> toAwait) {
        if (objects.size() == 0) {
            return Task.forResult(objects);
        }
        ArrayList<String> objectIds = new ArrayList<String>();
        String className = null;
        for (EasimartObject object : objects) {
            if (onlyIfNeeded && object.isDataAvailable()) continue;
            if (className != null && !object.getClassName().equals(className)) {
                throw new IllegalArgumentException("All objects should have the same class");
            }
            className = object.getClassName();
            String objectId = object.getObjectId();
            if (objectId != null) {
                objectIds.add(object.getObjectId());
                continue;
            }
            if (onlyIfNeeded) continue;
            throw new IllegalArgumentException("All objects must exist on the server");
        }
        if (objectIds.size() == 0) {
            return Task.forResult(objects);
        }
        final EasimartQuery query = EasimartQuery.getQuery(className).whereContainedIn(KEY_OBJECT_ID, objectIds);
        return toAwait.continueWithTask(new Continuation<Void, Task<List<T>>>(){

            public Task<List<T>> then(Task<Void> task) throws Exception {
                return query.findAsync(query.getBuilder().build(), user, null);
            }
        }).onSuccess(new Continuation<List<T>, List<T>>(){

            public List<T> then(Task<List<T>> task) throws Exception {
                HashMap<String, EasimartObject> resultMap = new HashMap<String, EasimartObject>();
                for (EasimartObject o : (List)task.getResult()) {
                    resultMap.put(o.getObjectId(), o);
                }
                for (EasimartObject object : objects) {
                    if (onlyIfNeeded && object.isDataAvailable()) continue;
                    EasimartObject newObject = (EasimartObject)resultMap.get(object.getObjectId());
                    if (newObject == null) {
                        throw new EasimartException(101, "Object id " + object.getObjectId() + " does not exist");
                    }
                    if (Easimart.isLocalDatastoreEnabled()) continue;
                    object.mergeFromObject(newObject);
                }
                return objects;
            }
        });
    }

    public static <T extends EasimartObject> Task<List<T>> fetchAllInBackground(List<T> objects) {
        return EasimartObject.fetchAllAsync(objects, false);
    }

    public static <T extends EasimartObject> List<T> fetchAll(List<T> objects) throws EasimartException {
        return EasimartTaskUtils.wait(EasimartObject.fetchAllInBackground(objects));
    }

    public static <T extends EasimartObject> void fetchAllInBackground(List<T> objects, FindCallback<T> callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.fetchAllInBackground(objects), callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EasimartOperationSet currentOperations() {
        Object object = this.mutex;
        synchronized (object) {
            return this.operationSetQueue.getLast();
        }
    }

    private void applyOperations(EasimartOperationSet operations, Map<String, Object> map) {
        for (String key : operations.keySet()) {
            Object oldValue;
            EasimartFieldOperation operation = (EasimartFieldOperation)operations.get(key);
            Object newValue = operation.apply(oldValue = map.get(key), key);
            if (newValue != null) {
                map.put(key, newValue);
                continue;
            }
            map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rebuildEstimatedData() {
        Object object = this.mutex;
        synchronized (object) {
            this.estimatedData.clear();
            for (String key : this.state.keySet()) {
                this.estimatedData.put(key, this.state.get(key));
            }
            for (EasimartOperationSet operations : this.operationSetQueue) {
                this.applyOperations(operations, this.estimatedData);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performOperation(String key, EasimartFieldOperation operation) {
        Object object = this.mutex;
        synchronized (object) {
            Object oldValue = this.estimatedData.get(key);
            Object newValue = operation.apply(oldValue, key);
            if (newValue != null) {
                this.estimatedData.put(key, newValue);
            } else {
                this.estimatedData.remove(key);
            }
            EasimartFieldOperation oldOperation = (EasimartFieldOperation)this.currentOperations().get(key);
            EasimartFieldOperation newOperation = operation.mergeWithPrevious(oldOperation);
            this.currentOperations().put(key, newOperation);
        }
    }

    public void put(String key, Object value) {
        this.checkKeyIsMutable(key);
        this.performPut(key, value);
    }

    void performPut(String key, Object value) {
        if (key == null) {
            throw new IllegalArgumentException("key may not be null.");
        }
        if (value == null) {
            throw new IllegalArgumentException("value may not be null.");
        }
        if (!EasimartEncoder.isValidType(value)) {
            throw new IllegalArgumentException("invalid type for value: " + value.getClass().toString());
        }
        this.performOperation(key, new EasimartSetOperation(value));
    }

    public boolean has(String key) {
        return this.containsKey(key);
    }

    public void increment(String key) {
        this.increment(key, 1);
    }

    public void increment(String key, Number amount) {
        EasimartIncrementOperation operation = new EasimartIncrementOperation(amount);
        this.performOperation(key, operation);
    }

    public void add(String key, Object value) {
        this.addAll(key, Arrays.asList(value));
    }

    public void addAll(String key, Collection<?> values) {
        EasimartAddOperation operation = new EasimartAddOperation(values);
        this.performOperation(key, operation);
    }

    public void addUnique(String key, Object value) {
        this.addAllUnique(key, Arrays.asList(value));
    }

    public void addAllUnique(String key, Collection<?> values) {
        EasimartAddUniqueOperation operation = new EasimartAddUniqueOperation(values);
        this.performOperation(key, operation);
    }

    public void remove(String key) {
        this.checkKeyIsMutable(key);
        this.performRemove(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void performRemove(String key) {
        Object object = this.mutex;
        synchronized (object) {
            Object object2 = this.get(key);
            if (object2 != null) {
                this.performOperation(key, EasimartDeleteOperation.getInstance());
            }
        }
    }

    public void removeAll(String key, Collection<?> values) {
        this.checkKeyIsMutable(key);
        EasimartRemoveOperation operation = new EasimartRemoveOperation(values);
        this.performOperation(key, operation);
    }

    private void checkKeyIsMutable(String key) {
        if (!this.isKeyMutable(key)) {
            throw new IllegalArgumentException("Cannot modify `" + key + "` property of an " + this.getClassName() + " object.");
        }
    }

    boolean isKeyMutable(String key) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsKey(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.estimatedData.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getString(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof String)) {
                return null;
            }
            return (String)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getBytes(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof byte[])) {
                return null;
            }
            return (byte[])value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Number getNumber(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Number)) {
                return null;
            }
            return (Number)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONArray getJSONArray(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (value instanceof List) {
                value = PointerOrLocalIdEncoder.get().encode(value);
                this.put(key, value);
            }
            if (!(value instanceof JSONArray)) {
                return null;
            }
            return (JSONArray)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> List<T> getList(String key) {
        Object object = this.mutex;
        synchronized (object) {
            List<Object> value = this.estimatedData.get(key);
            if (value instanceof JSONArray) {
                EasimartDecoder decoder = EasimartDecoder.get();
                value = decoder.convertJSONArrayToList((JSONArray)value);
                this.put(key, value);
            }
            if (!(value instanceof List)) {
                return null;
            }
            List returnValue = value;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <V> Map<String, V> getMap(String key) {
        Object object = this.mutex;
        synchronized (object) {
            Map<String, Object> value = this.estimatedData.get(key);
            if (value instanceof JSONObject) {
                EasimartDecoder decoder = EasimartDecoder.get();
                value = decoder.convertJSONObjectToMap((JSONObject)value);
                this.put(key, value);
            }
            if (!(value instanceof Map)) {
                return null;
            }
            Map returnValue = value;
            return returnValue;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getJSONObject(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (value instanceof Map) {
                value = PointerOrLocalIdEncoder.get().encode(value);
                this.put(key, value);
            }
            if (!(value instanceof JSONObject)) {
                return null;
            }
            return (JSONObject)value;
        }
    }

    public int getInt(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0;
        }
        return number.intValue();
    }

    public double getDouble(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0.0;
        }
        return number.doubleValue();
    }

    public long getLong(String key) {
        Number number = this.getNumber(key);
        if (number == null) {
            return 0L;
        }
        return number.longValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getBoolean(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Boolean)) {
                return false;
            }
            return (Boolean)value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date getDate(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof Date)) {
                return null;
            }
            return (Date)value;
        }
    }

    public EasimartObject getEasimartObject(String key) {
        Object value = this.get(key);
        if (!(value instanceof EasimartObject)) {
            return null;
        }
        return (EasimartObject)value;
    }

    public EasimartUser getEasimartUser(String key) {
        Object value = this.get(key);
        if (!(value instanceof EasimartUser)) {
            return null;
        }
        return (EasimartUser)value;
    }

    public EasimartFile getEasimartFile(String key) {
        Object value = this.get(key);
        if (!(value instanceof EasimartFile)) {
            return null;
        }
        return (EasimartFile)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EasimartGeoPoint getEasimartGeoPoint(String key) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (!(value instanceof EasimartGeoPoint)) {
                return null;
            }
            return (EasimartGeoPoint)value;
        }
    }

    public EasimartACL getACL() {
        return this.getACL(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EasimartACL getACL(boolean mayCopy) {
        Object object = this.mutex;
        synchronized (object) {
            this.checkGetAccess(KEY_ACL);
            Object acl = this.estimatedData.get(KEY_ACL);
            if (acl == null) {
                return null;
            }
            if (!(acl instanceof EasimartACL)) {
                throw new RuntimeException("only ACLs can be stored in the ACL key");
            }
            if (mayCopy && ((EasimartACL)acl).isShared()) {
                EasimartACL copy = ((EasimartACL)acl).copy();
                this.estimatedData.put(KEY_ACL, copy);
                return copy;
            }
            return (EasimartACL)acl;
        }
    }

    public void setACL(EasimartACL acl) {
        this.put(KEY_ACL, acl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDataAvailable() {
        Object object = this.mutex;
        synchronized (object) {
            return this.state.isComplete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isDataAvailable(String key) {
        Object object = this.mutex;
        synchronized (object) {
            return this.isDataAvailable() || this.estimatedData.containsKey(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends EasimartObject> EasimartRelation<T> getRelation(String key) {
        Object object = this.mutex;
        synchronized (object) {
            Object value = this.estimatedData.get(key);
            if (value instanceof EasimartRelation) {
                EasimartRelation relation = (EasimartRelation)value;
                relation.ensureParentAndKey(this, key);
                return relation;
            }
            EasimartRelation relation = new EasimartRelation(this, key);
            this.estimatedData.put(key, relation);
            return relation;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String key) {
        Object object = this.mutex;
        synchronized (object) {
            if (key.equals(KEY_ACL)) {
                return this.getACL();
            }
            this.checkGetAccess(key);
            Object value = this.estimatedData.get(key);
            if (value instanceof EasimartRelation) {
                ((EasimartRelation)value).ensureParentAndKey(this, key);
            }
            return value;
        }
    }

    private void checkGetAccess(String key) {
        if (!this.isDataAvailable(key)) {
            throw new IllegalStateException("EasimartObject has no data for '" + key + "'. Call fetchIfNeeded() to get the data.");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasSameId(EasimartObject other) {
        Object object = this.mutex;
        synchronized (object) {
            return this.getClassName() != null && this.getObjectId() != null && this.getClassName().equals(other.getClassName()) && this.getObjectId().equals(other.getObjectId());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerSaveListener(GetCallback<EasimartObject> callback) {
        Object object = this.mutex;
        synchronized (object) {
            this.saveEvent.subscribe(callback);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterSaveListener(GetCallback<EasimartObject> callback) {
        Object object = this.mutex;
        synchronized (object) {
            this.saveEvent.unsubscribe(callback);
        }
    }

    static String getClassName(Class<? extends EasimartObject> clazz) {
        String name = classNames.get(clazz);
        if (name == null) {
            EasimartClassName info = clazz.getAnnotation(EasimartClassName.class);
            if (info == null) {
                return null;
            }
            name = info.value();
            classNames.put(clazz, name);
        }
        return name;
    }

    void setDefaultValues() {
        if (this.needsDefaultACL() && EasimartACL.getDefaultACL() != null) {
            this.setACL(EasimartACL.getDefaultACL());
        }
    }

    boolean needsDefaultACL() {
        return true;
    }

    static void registerEasimartSubclasses() {
        EasimartObject.registerSubclass(EasimartUser.class);
        EasimartObject.registerSubclass(EasimartRole.class);
        EasimartObject.registerSubclass(EasimartInstallation.class);
        EasimartObject.registerSubclass(EasimartSession.class);
        EasimartObject.registerSubclass(EasimartPin.class);
        EasimartObject.registerSubclass(EventuallyPin.class);
    }

    static void unregisterEasimartSubclasses() {
        EasimartObject.unregisterSubclass(EasimartUser.class);
        EasimartObject.unregisterSubclass(EasimartRole.class);
        EasimartObject.unregisterSubclass(EasimartInstallation.class);
        EasimartObject.unregisterSubclass(EasimartSession.class);
        EasimartObject.unregisterSubclass(EasimartPin.class);
        EasimartObject.unregisterSubclass(EventuallyPin.class);
    }

    public static <T extends EasimartObject> void pinAllInBackground(String name, List<T> objects, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.pinAllInBackground(name, objects), callback);
    }

    public static <T extends EasimartObject> Task<Void> pinAllInBackground(String name, List<T> objects) {
        return EasimartObject.pinAllInBackground(name, objects, true);
    }

    private static <T extends EasimartObject> Task<Void> pinAllInBackground(final String name, final List<T> objects, final boolean includeAllChildren) {
        if (!Easimart.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Easimart#enableLocalDatastore(Context)`.");
        }
        Task task = Task.forResult(null);
        for (final EasimartObject object : objects) {
            task = task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    if (!object.isDataAvailable(EasimartObject.KEY_ACL)) {
                        return Task.forResult(null);
                    }
                    EasimartACL acl = object.getACL(false);
                    if (acl == null) {
                        return Task.forResult(null);
                    }
                    EasimartUser user = acl.getUnresolvedUser();
                    if (user == null || !user.isCurrentUser()) {
                        return Task.forResult(null);
                    }
                    return EasimartUser.pinCurrentUserIfNeededAsync(user);
                }
            });
        }
        return task.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                return Easimart.getLocalDatastore().pinAllObjectsAsync(name != null ? name : EasimartObject.DEFAULT_PIN, objects, includeAllChildren);
            }
        }).onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> then(Task<Void> task) throws Exception {
                if ("_currentUser".equals(name)) {
                    return task;
                }
                for (EasimartObject object : objects) {
                    EasimartUser user;
                    if (!(object instanceof EasimartUser) || !(user = (EasimartUser)object).isCurrentUser()) continue;
                    return EasimartUser.pinCurrentUserIfNeededAsync(user);
                }
                return task;
            }
        });
    }

    public static <T extends EasimartObject> void pinAll(String name, List<T> objects) throws EasimartException {
        EasimartTaskUtils.wait(EasimartObject.pinAllInBackground(name, objects));
    }

    public static <T extends EasimartObject> void pinAllInBackground(List<T> objects, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.pinAllInBackground(DEFAULT_PIN, objects), callback);
    }

    public static <T extends EasimartObject> Task<Void> pinAllInBackground(List<T> objects) {
        return EasimartObject.pinAllInBackground(DEFAULT_PIN, objects);
    }

    public static <T extends EasimartObject> void pinAll(List<T> objects) throws EasimartException {
        EasimartTaskUtils.wait(EasimartObject.pinAllInBackground(DEFAULT_PIN, objects));
    }

    public static <T extends EasimartObject> void unpinAllInBackground(String name, List<T> objects, DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.unpinAllInBackground(name, objects), callback);
    }

    public static <T extends EasimartObject> Task<Void> unpinAllInBackground(String name, List<T> objects) {
        if (!Easimart.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Easimart#enableLocalDatastore(Context)`.");
        }
        if (name == null) {
            name = DEFAULT_PIN;
        }
        return Easimart.getLocalDatastore().unpinAllObjectsAsync(name, objects);
    }

    public static <T extends EasimartObject> void unpinAll(String name, List<T> objects) throws EasimartException {
        EasimartTaskUtils.wait(EasimartObject.unpinAllInBackground(name, objects));
    }

    public static <T extends EasimartObject> void unpinAllInBackground(List<T> objects, DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.unpinAllInBackground(DEFAULT_PIN, objects), callback);
    }

    public static <T extends EasimartObject> Task<Void> unpinAllInBackground(List<T> objects) {
        return EasimartObject.unpinAllInBackground(DEFAULT_PIN, objects);
    }

    public static <T extends EasimartObject> void unpinAll(List<T> objects) throws EasimartException {
        EasimartTaskUtils.wait(EasimartObject.unpinAllInBackground(DEFAULT_PIN, objects));
    }

    public static void unpinAllInBackground(String name, DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.unpinAllInBackground(name), callback);
    }

    public static Task<Void> unpinAllInBackground(String name) {
        if (!Easimart.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Easimart#enableLocalDatastore(Context)`.");
        }
        if (name == null) {
            name = DEFAULT_PIN;
        }
        return Easimart.getLocalDatastore().unpinAllObjectsAsync(name);
    }

    public static void unpinAll(String name) throws EasimartException {
        EasimartTaskUtils.wait(EasimartObject.unpinAllInBackground(name));
    }

    public static void unpinAllInBackground(DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartObject.unpinAllInBackground(), callback);
    }

    public static Task<Void> unpinAllInBackground() {
        return EasimartObject.unpinAllInBackground(DEFAULT_PIN);
    }

    public static void unpinAll() throws EasimartException {
        EasimartTaskUtils.wait(EasimartObject.unpinAllInBackground());
    }

    <T extends EasimartObject> Task<T> fetchFromLocalDatastoreAsync() {
        if (!Easimart.isLocalDatastoreEnabled()) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Easimart#enableLocalDatastore(Context)`.");
        }
        return Easimart.getLocalDatastore().fetchLocallyAsync(this);
    }

    public <T extends EasimartObject> void fetchFromLocalDatastoreInBackground(GetCallback<T> callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.fetchFromLocalDatastoreAsync(), callback);
    }

    public void fetchFromLocalDatastore() throws EasimartException {
        EasimartTaskUtils.wait(this.fetchFromLocalDatastoreAsync());
    }

    public void pinInBackground(String name, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.pinInBackground(name), callback);
    }

    public Task<Void> pinInBackground(String name) {
        return EasimartObject.pinAllInBackground(name, Collections.singletonList(this));
    }

    Task<Void> pinInBackground(String name, boolean includeAllChildren) {
        return EasimartObject.pinAllInBackground(name, Collections.singletonList(this), includeAllChildren);
    }

    public void pin(String name) throws EasimartException {
        EasimartTaskUtils.wait(this.pinInBackground(name));
    }

    public void pinInBackground(SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.pinInBackground(), callback);
    }

    public Task<Void> pinInBackground() {
        return EasimartObject.pinAllInBackground(DEFAULT_PIN, Arrays.asList(this));
    }

    public void pin() throws EasimartException {
        EasimartTaskUtils.wait(this.pinInBackground());
    }

    public void unpinInBackground(String name, DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.unpinInBackground(name), callback);
    }

    public Task<Void> unpinInBackground(String name) {
        return EasimartObject.unpinAllInBackground(name, Arrays.asList(this));
    }

    public void unpin(String name) throws EasimartException {
        EasimartTaskUtils.wait(this.unpinInBackground(name));
    }

    public void unpinInBackground(DeleteCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.unpinInBackground(), callback);
    }

    public Task<Void> unpinInBackground() {
        return EasimartObject.unpinAllInBackground(DEFAULT_PIN, Arrays.asList(this));
    }

    public void unpin() throws EasimartException {
        EasimartTaskUtils.wait(this.unpinInBackground());
    }

    static class State {
        private final String className;
        private final String objectId;
        private final long createdAt;
        private final long updatedAt;
        private final Map<String, Object> serverData;
        private final boolean isComplete;

        public static Init<?> newBuilder(String className) {
            if ("_User".equals(className)) {
                return new EasimartUser.State.Builder();
            }
            return new Builder(className);
        }

        State(Init<?> builder) {
            this.className = ((Init)builder).className;
            this.objectId = ((Init)builder).objectId;
            this.createdAt = ((Init)builder).createdAt;
            this.updatedAt = ((Init)builder).updatedAt > 0L ? ((Init)builder).updatedAt : this.createdAt;
            this.serverData = Collections.unmodifiableMap(new HashMap<String, Object>(builder.serverData));
            this.isComplete = ((Init)builder).isComplete;
        }

        public <T extends Init<?>> T newBuilder() {
            return (T)new Builder(this);
        }

        public String className() {
            return this.className;
        }

        public String objectId() {
            return this.objectId;
        }

        public long createdAt() {
            return this.createdAt;
        }

        public long updatedAt() {
            return this.updatedAt;
        }

        public boolean isComplete() {
            return this.isComplete;
        }

        public Object get(String key) {
            return this.serverData.get(key);
        }

        public Set<String> keySet() {
            return this.serverData.keySet();
        }

        public String toString() {
            return String.format(Locale.US, "%s@%s[className=%s, objectId=%s, createdAt=%d, updatedAt=%d, isComplete=%s, serverData=%s]", this.getClass().getName(), Integer.toHexString(this.hashCode()), this.className, this.objectId, this.createdAt, this.updatedAt, this.isComplete, this.serverData);
        }

        static class Builder
        extends Init<Builder> {
            public Builder(String className) {
                super(className);
            }

            public Builder(State state) {
                super(state);
            }

            @Override
            Builder self() {
                return this;
            }

            @Override
            public State build() {
                return new State(this);
            }
        }

        static abstract class Init<T extends Init> {
            private final String className;
            private String objectId;
            private long createdAt = -1L;
            private long updatedAt = -1L;
            private boolean isComplete;
            Map<String, Object> serverData = new HashMap<String, Object>();

            public Init(String className) {
                this.className = className;
            }

            Init(State state) {
                this.className = state.className();
                this.objectId = state.objectId();
                this.createdAt = state.createdAt();
                this.updatedAt = state.updatedAt();
                for (String key : state.keySet()) {
                    this.serverData.put(key, state.get(key));
                }
                this.isComplete = state.isComplete();
            }

            abstract T self();

            abstract <S extends State> S build();

            public T objectId(String objectId) {
                this.objectId = objectId;
                return this.self();
            }

            public T createdAt(Date createdAt) {
                this.createdAt = createdAt.getTime();
                return this.self();
            }

            public T createdAt(long createdAt) {
                this.createdAt = createdAt;
                return this.self();
            }

            public T updatedAt(Date updatedAt) {
                this.updatedAt = updatedAt.getTime();
                return this.self();
            }

            public T updatedAt(long updatedAt) {
                this.updatedAt = updatedAt;
                return this.self();
            }

            public T isComplete(boolean complete) {
                this.isComplete = complete;
                return this.self();
            }

            public T put(String key, Object value) {
                this.serverData.put(key, value);
                return this.self();
            }

            public T remove(String key) {
                this.serverData.remove(key);
                return this.self();
            }

            public T clear() {
                this.objectId = null;
                this.createdAt = -1L;
                this.updatedAt = -1L;
                this.isComplete = false;
                this.serverData.clear();
                return this.self();
            }

            public T apply(State other) {
                if (other.objectId() != null) {
                    this.objectId(other.objectId());
                }
                if (other.createdAt() > 0L) {
                    this.createdAt(other.createdAt());
                }
                if (other.updatedAt() > 0L) {
                    this.updatedAt(other.updatedAt());
                }
                this.isComplete(this.isComplete || other.isComplete());
                for (String key : other.keySet()) {
                    this.put(key, other.get(key));
                }
                return this.self();
            }

            public T apply(EasimartOperationSet operations) {
                for (String key : operations.keySet()) {
                    Object oldValue;
                    EasimartFieldOperation operation = (EasimartFieldOperation)operations.get(key);
                    Object newValue = operation.apply(oldValue = this.serverData.get(key), key);
                    if (newValue != null) {
                        this.put(key, newValue);
                        continue;
                    }
                    this.remove(key);
                }
                return this.self();
            }
        }
    }
}

