/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartACL;
import co.easimart.EasimartDateFormat;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartObject;
import co.easimart.EasimartOperationSet;
import java.util.Iterator;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartObjectCoder {
    private static final String KEY_OBJECT_ID = "objectId";
    private static final String KEY_CLASS_NAME = "className";
    private static final String KEY_ACL = "ACL";
    private static final String KEY_CREATED_AT = "createdAt";
    private static final String KEY_UPDATED_AT = "updatedAt";
    private static final EasimartObjectCoder INSTANCE = new EasimartObjectCoder();

    public static EasimartObjectCoder get() {
        return INSTANCE;
    }

    EasimartObjectCoder() {
    }

    public <T extends EasimartObject.State> JSONObject encode(T state, EasimartOperationSet operations, EasimartEncoder encoder) {
        JSONObject objectJSON = new JSONObject();
        try {
            for (String key : operations.keySet()) {
                EasimartFieldOperation operation = (EasimartFieldOperation)operations.get(key);
                objectJSON.put(key, encoder.encode(operation));
            }
            if (state.objectId() != null) {
                objectJSON.put(KEY_OBJECT_ID, (Object)state.objectId());
            }
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return objectJSON;
    }

    public <T extends EasimartObject.State.Init<?>> T decode(T builder, JSONObject json, EasimartDecoder decoder) {
        try {
            Iterator keys = json.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if (key.equals("__type") || key.equals(KEY_CLASS_NAME)) continue;
                if (key.equals(KEY_OBJECT_ID)) {
                    String newObjectId = json.getString(key);
                    builder.objectId(newObjectId);
                    continue;
                }
                if (key.equals(KEY_CREATED_AT)) {
                    builder.createdAt(EasimartDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_UPDATED_AT)) {
                    builder.updatedAt(EasimartDateFormat.getInstance().parse(json.getString(key)));
                    continue;
                }
                if (key.equals(KEY_ACL)) {
                    EasimartACL acl = EasimartACL.createACLFromJSONObject(json.getJSONObject(key), decoder);
                    builder.put(KEY_ACL, acl);
                    continue;
                }
                Object value = json.get(key);
                Object decodedObject = decoder.decode(value);
                builder.put(key, decodedObject);
            }
            return builder;
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }
}

