/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartACL;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartSetOperation;
import java.util.HashMap;
import java.util.Iterator;
import java.util.UUID;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartOperationSet
extends HashMap<String, EasimartFieldOperation> {
    private static final long serialVersionUID = 1L;
    private static final String REST_KEY_IS_SAVE_EVENTUALLY = "__isSaveEventually";
    private static final String REST_KEY_UUID = "__uuid";
    private final String uuid;
    private boolean isSaveEventually = false;

    public EasimartOperationSet() {
        this(UUID.randomUUID().toString());
    }

    public EasimartOperationSet(EasimartOperationSet operations) {
        super(operations);
        this.uuid = operations.getUUID();
        this.isSaveEventually = operations.isSaveEventually;
    }

    private EasimartOperationSet(String uuid) {
        this.uuid = uuid;
    }

    public String getUUID() {
        return this.uuid;
    }

    public void setIsSaveEventually(boolean value) {
        this.isSaveEventually = value;
    }

    public boolean isSaveEventually() {
        return this.isSaveEventually;
    }

    public void mergeFrom(EasimartOperationSet other) {
        for (String key : other.keySet()) {
            EasimartFieldOperation operation1 = (EasimartFieldOperation)other.get(key);
            EasimartFieldOperation operation2 = (EasimartFieldOperation)this.get(key);
            operation2 = operation2 != null ? operation2.mergeWithPrevious(operation1) : operation1;
            this.put(key, operation2);
        }
    }

    public JSONObject toRest(EasimartEncoder objectEncoder) throws JSONException {
        JSONObject operationSetJSON = new JSONObject();
        for (String key : this.keySet()) {
            EasimartFieldOperation op = (EasimartFieldOperation)this.get(key);
            operationSetJSON.put(key, op.encode(objectEncoder));
        }
        operationSetJSON.put(REST_KEY_UUID, (Object)this.uuid);
        if (this.isSaveEventually) {
            operationSetJSON.put(REST_KEY_IS_SAVE_EVENTUALLY, true);
        }
        return operationSetJSON;
    }

    public static EasimartOperationSet fromRest(JSONObject json, EasimartDecoder decoder) throws JSONException {
        Iterator keysIter = json.keys();
        String[] keys = new String[json.length()];
        int index = 0;
        while (keysIter.hasNext()) {
            String key = (String)keysIter.next();
            keys[index++] = key;
        }
        JSONObject jsonCopy = new JSONObject(json, keys);
        String uuid = (String)jsonCopy.remove(REST_KEY_UUID);
        EasimartOperationSet operationSet = uuid == null ? new EasimartOperationSet() : new EasimartOperationSet(uuid);
        boolean isSaveEventually = jsonCopy.optBoolean(REST_KEY_IS_SAVE_EVENTUALLY);
        jsonCopy.remove(REST_KEY_IS_SAVE_EVENTUALLY);
        operationSet.setIsSaveEventually(isSaveEventually);
        Iterator opKeys = jsonCopy.keys();
        while (opKeys.hasNext()) {
            String opKey = (String)opKeys.next();
            Object value = decoder.decode(jsonCopy.get(opKey));
            if (opKey.equals("ACL")) {
                value = EasimartACL.createACLFromJSONObject(jsonCopy.getJSONObject(opKey), decoder);
            }
            EasimartFieldOperation fieldOp = value instanceof EasimartFieldOperation ? (EasimartFieldOperation)value : new EasimartSetOperation(value);
            operationSet.put(opKey, fieldOp);
        }
        return operationSet;
    }
}

