/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartException;
import co.easimart.EasimartInstallation;
import co.easimart.EasimartLog;
import co.easimart.EasimartObject;
import co.easimart.EasimartPushChannelsController;
import co.easimart.EasimartPushController;
import co.easimart.EasimartQuery;
import co.easimart.EasimartTaskUtils;
import co.easimart.EasimartUser;
import co.easimart.SaveCallback;
import co.easimart.SendCallback;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class EasimartPush {
    static String KEY_DATA_MESSAGE = "alert";
    private static final String TAG = "co.easimart.EasimartPush";
    final State.Builder builder;

    static EasimartPushController getPushController() {
        return EasimartCorePlugins.getInstance().getPushController();
    }

    static EasimartPushChannelsController getPushChannelsController() {
        return EasimartCorePlugins.getInstance().getPushChannelsController();
    }

    private static void checkArgument(boolean expression, Object errorMessage) {
        if (!expression) {
            throw new IllegalArgumentException(String.valueOf(errorMessage));
        }
    }

    public EasimartPush() {
        this(new State.Builder());
    }

    private EasimartPush(State.Builder builder) {
        this.builder = builder;
    }

    public static Task<Void> subscribeInBackground(String channel) {
        return EasimartPush.getPushChannelsController().subscribeInBackground(channel);
    }

    public static void subscribeInBackground(String channel, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartPush.subscribeInBackground(channel), callback);
    }

    public static Task<Void> unsubscribeInBackground(String channel) {
        return EasimartPush.getPushChannelsController().unsubscribeInBackground(channel);
    }

    public static void unsubscribeInBackground(String channel, SaveCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartPush.unsubscribeInBackground(channel), callback);
    }

    public static Task<Void> sendMessageInBackground(String message, EasimartQuery<EasimartInstallation> query) {
        EasimartPush push = new EasimartPush();
        push.setQuery(query);
        push.setMessage(message);
        return push.sendInBackground();
    }

    public static void sendMessageInBackground(String message, EasimartQuery<EasimartInstallation> query, SendCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartPush.sendMessageInBackground(message, query), callback);
    }

    public static Task<Void> sendDataInBackground(JSONObject data, EasimartQuery<EasimartInstallation> query) {
        EasimartPush push = new EasimartPush();
        push.setQuery(query);
        push.setData(data);
        return push.sendInBackground();
    }

    public static void sendDataInBackground(JSONObject data, EasimartQuery<EasimartInstallation> query, SendCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartPush.sendDataInBackground(data, query), callback);
    }

    public void setChannel(String channel) {
        this.builder.channelSet(Collections.singletonList(channel));
    }

    public void setChannels(Collection<String> channels) {
        this.builder.channelSet(channels);
    }

    public void setQuery(EasimartQuery<EasimartInstallation> query) {
        this.builder.query(query);
    }

    public void setExpirationTime(long time) {
        this.builder.expirationTime(time);
    }

    public void setExpirationTimeInterval(long timeInterval) {
        this.builder.expirationTimeInterval(timeInterval);
    }

    public void clearExpiration() {
        this.builder.expirationTime(null);
        this.builder.expirationTimeInterval(null);
    }

    @Deprecated
    public void setPushToIOS(boolean pushToIOS) {
        this.builder.pushToIOS(pushToIOS);
    }

    @Deprecated
    public void setPushToAndroid(boolean pushToAndroid) {
        this.builder.pushToAndroid(pushToAndroid);
    }

    public void setData(JSONObject data) {
        this.builder.data(data);
    }

    public void setMessage(String message) {
        JSONObject data = new JSONObject();
        try {
            data.put(KEY_DATA_MESSAGE, (Object)message);
        }
        catch (JSONException e) {
            EasimartLog.e(TAG, "JSONException in setMessage", e);
        }
        this.setData(data);
    }

    public Task<Void> sendInBackground() {
        final State state = this.builder.build();
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<Void>>(){

            public Task<Void> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                return EasimartPush.getPushController().sendInBackground(state, sessionToken);
            }
        });
    }

    public void send() throws EasimartException {
        EasimartTaskUtils.wait(this.sendInBackground());
    }

    public void sendInBackground(SendCallback callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(this.sendInBackground(), callback);
    }

    static class State {
        private final Set<String> channelSet;
        private final EasimartQuery.State<EasimartInstallation> queryState;
        private final Long expirationTime;
        private final Long expirationTimeInterval;
        private final Boolean pushToIOS;
        private final Boolean pushToAndroid;
        private final JSONObject data;

        private State(Builder builder) {
            this.channelSet = builder.channelSet == null ? null : Collections.unmodifiableSet(new HashSet(builder.channelSet));
            this.queryState = builder.query == null ? null : builder.query.getBuilder().build();
            this.expirationTime = builder.expirationTime;
            this.expirationTimeInterval = builder.expirationTimeInterval;
            this.pushToIOS = builder.pushToIOS;
            this.pushToAndroid = builder.pushToAndroid;
            JSONObject copyData = null;
            try {
                copyData = new JSONObject(builder.data.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.data = copyData;
        }

        public Set<String> channelSet() {
            return this.channelSet;
        }

        public EasimartQuery.State<EasimartInstallation> queryState() {
            return this.queryState;
        }

        public Long expirationTime() {
            return this.expirationTime;
        }

        public Long expirationTimeInterval() {
            return this.expirationTimeInterval;
        }

        public Boolean pushToIOS() {
            return this.pushToIOS;
        }

        public Boolean pushToAndroid() {
            return this.pushToAndroid;
        }

        public JSONObject data() {
            JSONObject copyData = null;
            try {
                copyData = new JSONObject(this.data.toString());
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            return copyData;
        }

        static class Builder {
            private Set<String> channelSet;
            private EasimartQuery<EasimartInstallation> query;
            private Long expirationTime;
            private Long expirationTimeInterval;
            private Boolean pushToIOS;
            private Boolean pushToAndroid;
            private JSONObject data;

            Builder() {
            }

            public Builder expirationTime(Long expirationTime) {
                this.expirationTime = expirationTime;
                this.expirationTimeInterval = null;
                return this;
            }

            public Builder expirationTimeInterval(Long expirationTimeInterval) {
                this.expirationTimeInterval = expirationTimeInterval;
                this.expirationTime = null;
                return this;
            }

            public Builder pushToIOS(Boolean pushToIOS) {
                EasimartPush.checkArgument(this.query == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
                this.pushToIOS = pushToIOS;
                return this;
            }

            public Builder pushToAndroid(Boolean pushToAndroid) {
                EasimartPush.checkArgument(this.query == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
                this.pushToAndroid = pushToAndroid;
                return this;
            }

            public Builder data(JSONObject data) {
                this.data = data;
                return this;
            }

            public Builder channelSet(Collection<String> channelSet) {
                EasimartPush.checkArgument(channelSet != null, "channels collection cannot be null");
                for (String channel : channelSet) {
                    EasimartPush.checkArgument(channel != null, "channel cannot be null");
                }
                this.channelSet = new HashSet<String>(channelSet);
                this.query = null;
                return this;
            }

            public Builder query(EasimartQuery<EasimartInstallation> query) {
                EasimartPush.checkArgument(query != null, "Cannot target a null query");
                EasimartPush.checkArgument(this.pushToIOS == null && this.pushToAndroid == null, "Cannot set push targets (i.e. setPushToAndroid or setPushToIOS) when pushing to a query");
                EasimartPush.checkArgument(query.getClassName().equals(EasimartObject.getClassName(EasimartInstallation.class)), "Can only push to a query for Installations");
                this.channelSet = null;
                this.query = query;
                return this;
            }

            public State build() {
                if (this.data == null) {
                    throw new IllegalArgumentException("Cannot send a push without calling either setMessage or setData");
                }
                return new State(this);
            }
        }
    }
}

