/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.CountCallback;
import co.easimart.Easimart;
import co.easimart.EasimartCallback2;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartException;
import co.easimart.EasimartGeoPoint;
import co.easimart.EasimartKeyValueCache;
import co.easimart.EasimartObject;
import co.easimart.EasimartQueryController;
import co.easimart.EasimartRESTQueryCommand;
import co.easimart.EasimartRelation;
import co.easimart.EasimartTaskUtils;
import co.easimart.EasimartTextUtils;
import co.easimart.EasimartUser;
import co.easimart.FindCallback;
import co.easimart.GetCallback;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.regex.Pattern;
import org.json.JSONException;
import org.json.JSONObject;

public class EasimartQuery<T extends EasimartObject> {
    private final State.Builder<T> builder;
    private EasimartUser user;
    private final Object lock = new Object();
    private boolean isRunning = false;
    private Task.TaskCompletionSource cts;

    private static EasimartQueryController getQueryController() {
        return EasimartCorePlugins.getInstance().getQueryController();
    }

    public static <T extends EasimartObject> EasimartQuery<T> or(List<EasimartQuery<T>> queries) {
        if (queries.isEmpty()) {
            throw new IllegalArgumentException("Can't take an or of an empty list of queries");
        }
        ArrayList builders = new ArrayList();
        for (EasimartQuery<T> query : queries) {
            builders.add(query.getBuilder());
        }
        return new EasimartQuery(State.Builder.or(builders));
    }

    public static <T extends EasimartObject> EasimartQuery<T> getQuery(Class<T> subclass) {
        return new EasimartQuery<T>(subclass);
    }

    public static <T extends EasimartObject> EasimartQuery<T> getQuery(String className) {
        return new EasimartQuery<T>(className);
    }

    @Deprecated
    public static EasimartQuery<EasimartUser> getUserQuery() {
        return EasimartUser.getQuery();
    }

    private static void throwIfLDSEnabled() {
        EasimartQuery.throwIfLDSEnabled(false);
    }

    private static void throwIfLDSDisabled() {
        EasimartQuery.throwIfLDSEnabled(true);
    }

    private static void throwIfLDSEnabled(boolean enabled) {
        boolean ldsEnabled = Easimart.isLocalDatastoreEnabled();
        if (enabled && !ldsEnabled) {
            throw new IllegalStateException("Method requires Local Datastore. Please refer to `Easimart#enableLocalDatastore(Context)`.");
        }
        if (!enabled && ldsEnabled) {
            throw new IllegalStateException("Unsupported method when Local Datastore is enabled.");
        }
    }

    public EasimartQuery(Class<T> subclass) {
        this(EasimartObject.getClassName(subclass));
    }

    public EasimartQuery(String theClassName) {
        this(new State.Builder(theClassName));
    }

    EasimartQuery(State.Builder<T> builder) {
        this.builder = builder;
    }

    State.Builder<T> getBuilder() {
        return this.builder;
    }

    EasimartQuery<T> setUser(EasimartUser user) {
        this.user = user;
        return this;
    }

    Task<EasimartUser> getUserAsync(State<T> state) {
        if (state.ignoreACLs()) {
            return Task.forResult(null);
        }
        if (this.user != null) {
            return Task.forResult((Object)this.user);
        }
        return EasimartUser.getCurrentUserAsync();
    }

    private void checkIfRunning() {
        this.checkIfRunning(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkIfRunning(boolean grabLock) {
        Object object = this.lock;
        synchronized (object) {
            if (this.isRunning) {
                throw new RuntimeException("This query has an outstanding network connection. You have to wait until it's done.");
            }
            if (grabLock) {
                this.isRunning = true;
                this.cts = Task.create();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        Object object = this.lock;
        synchronized (object) {
            if (this.cts != null) {
                this.cts.trySetCancelled();
                this.cts = null;
            }
            this.isRunning = false;
        }
    }

    public List<T> find() throws EasimartException {
        return EasimartTaskUtils.wait(this.findInBackground());
    }

    public T getFirst() throws EasimartException {
        return (T)((EasimartObject)EasimartTaskUtils.wait(this.getFirstInBackground()));
    }

    public EasimartQuery<T> setCachePolicy(CachePolicy newCachePolicy) {
        this.checkIfRunning();
        this.builder.setCachePolicy(newCachePolicy);
        return this;
    }

    public CachePolicy getCachePolicy() {
        return this.builder.getCachePolicy();
    }

    EasimartQuery<T> fromNetwork() {
        this.checkIfRunning();
        this.builder.fromNetwork();
        return this;
    }

    boolean isFromNetwork() {
        return this.builder.isFromNetwork();
    }

    public EasimartQuery<T> fromLocalDatastore() {
        this.builder.fromLocalDatastore();
        return this;
    }

    public EasimartQuery<T> fromPin() {
        this.checkIfRunning();
        this.builder.fromPin();
        return this;
    }

    public EasimartQuery<T> fromPin(String name) {
        this.checkIfRunning();
        this.builder.fromPin(name);
        return this;
    }

    public EasimartQuery<T> ignoreACLs() {
        this.checkIfRunning();
        this.builder.ignoreACLs();
        return this;
    }

    public EasimartQuery<T> setMaxCacheAge(long maxAgeInMilliseconds) {
        this.checkIfRunning();
        this.builder.setMaxCacheAge(maxAgeInMilliseconds);
        return this;
    }

    public long getMaxCacheAge() {
        return this.builder.getMaxCacheAge();
    }

    private <TResult> Task<TResult> doWithRunningCheck(Callable<Task<TResult>> runnable) {
        Task task;
        this.checkIfRunning(true);
        try {
            task = runnable.call();
        }
        catch (Exception e) {
            task = Task.forError((Exception)e);
        }
        return task.continueWithTask(new Continuation<TResult, Task<TResult>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<TResult> then(Task<TResult> task) throws Exception {
                Object object = EasimartQuery.this.lock;
                synchronized (object) {
                    EasimartQuery.this.isRunning = false;
                    if (EasimartQuery.this.cts != null) {
                        EasimartQuery.this.cts.trySetResult(null);
                    }
                    EasimartQuery.this.cts = null;
                }
                return task;
            }
        });
    }

    public Task<List<T>> findInBackground() {
        return this.findAsync(this.builder.build());
    }

    public void findInBackground(FindCallback<T> callback) {
        State<T> state = this.builder.build();
        Object task = state.cachePolicy() != CachePolicy.CACHE_THEN_NETWORK || state.isFromLocalDatastore() ? this.findAsync(state) : this.doCacheThenNetwork(state, callback, new CacheThenNetworkCallable<T, Task<List<T>>>(){

            @Override
            public Task<List<T>> call(State<T> state, EasimartUser user, Task<Void> cancellationToken) {
                return EasimartQuery.this.findAsync(state, user, cancellationToken);
            }
        });
        EasimartTaskUtils.callbackOnMainThreadAsync(task, callback);
    }

    private Task<List<T>> findAsync(final State<T> state) {
        return this.doWithRunningCheck(new Callable<Task<List<T>>>(){

            @Override
            public Task<List<T>> call() throws Exception {
                return EasimartQuery.this.getUserAsync(state).onSuccessTask(new Continuation<EasimartUser, Task<List<T>>>(){

                    public Task<List<T>> then(Task<EasimartUser> task) throws Exception {
                        EasimartUser user = (EasimartUser)task.getResult();
                        return EasimartQuery.this.findAsync(state, user, (Task<Void>)EasimartQuery.this.cts.getTask());
                    }
                });
            }
        });
    }

    Task<List<T>> findAsync(State<T> state, EasimartUser user, Task<Void> cancellationToken) {
        return EasimartQuery.getQueryController().findAsync(state, user, cancellationToken);
    }

    public Task<T> getFirstInBackground() {
        State<T> state = this.builder.setLimit(1).build();
        return this.getFirstAsync(state);
    }

    public void getFirstInBackground(GetCallback<T> callback) {
        State<T> state = this.builder.setLimit(1).build();
        Object task = state.cachePolicy() != CachePolicy.CACHE_THEN_NETWORK || state.isFromLocalDatastore() ? this.getFirstAsync(state) : this.doCacheThenNetwork(state, callback, new CacheThenNetworkCallable<T, Task<T>>(){

            @Override
            public Task<T> call(State<T> state, EasimartUser user, Task<Void> cancellationToken) {
                return EasimartQuery.this.getFirstAsync(state, user, (Task<Void>)cancellationToken);
            }
        });
        EasimartTaskUtils.callbackOnMainThreadAsync(task, callback);
    }

    private Task<T> getFirstAsync(final State<T> state) {
        return this.doWithRunningCheck(new Callable<Task<T>>(){

            @Override
            public Task<T> call() throws Exception {
                return EasimartQuery.this.getUserAsync(state).onSuccessTask(new Continuation<EasimartUser, Task<T>>(){

                    public Task<T> then(Task<EasimartUser> task) throws Exception {
                        EasimartUser user = (EasimartUser)task.getResult();
                        return EasimartQuery.this.getFirstAsync(state, user, (Task<Void>)EasimartQuery.this.cts.getTask());
                    }
                });
            }
        });
    }

    private Task<T> getFirstAsync(State<T> state, EasimartUser user, Task<Void> cancellationToken) {
        return EasimartQuery.getQueryController().getFirstAsync(state, user, cancellationToken);
    }

    public int count() throws EasimartException {
        return EasimartTaskUtils.wait(this.countInBackground());
    }

    public Task<Integer> countInBackground() {
        State.Builder<T> copy = new State.Builder<T>(this.builder);
        State<T> state = copy.setLimit(0).build();
        return this.countAsync(state);
    }

    public void countInBackground(final CountCallback callback) {
        State.Builder<T> copy = new State.Builder<T>(this.builder);
        State<T> state = copy.setLimit(0).build();
        EasimartCallback2<Integer, EasimartException> c = callback != null ? new EasimartCallback2<Integer, EasimartException>(){

            @Override
            public void done(Integer integer, EasimartException e) {
                callback.done(e == null ? integer : -1, e);
            }
        } : null;
        Task<Integer> task = state.cachePolicy() != CachePolicy.CACHE_THEN_NETWORK || state.isFromLocalDatastore() ? this.countAsync(state) : this.doCacheThenNetwork(state, c, new CacheThenNetworkCallable<T, Task<Integer>>(){

            @Override
            public Task<Integer> call(State<T> state, EasimartUser user, Task<Void> cancellationToken) {
                return EasimartQuery.this.countAsync(state, user, (Task<Void>)cancellationToken);
            }
        });
        EasimartTaskUtils.callbackOnMainThreadAsync(task, c);
    }

    private Task<Integer> countAsync(final State<T> state) {
        return this.doWithRunningCheck(new Callable<Task<Integer>>(){

            @Override
            public Task<Integer> call() throws Exception {
                return EasimartQuery.this.getUserAsync(state).onSuccessTask((Continuation)new Continuation<EasimartUser, Task<Integer>>(){

                    public Task<Integer> then(Task<EasimartUser> task) throws Exception {
                        EasimartUser user = (EasimartUser)task.getResult();
                        return EasimartQuery.this.countAsync(state, user, (Task<Void>)EasimartQuery.this.cts.getTask());
                    }
                });
            }
        });
    }

    private Task<Integer> countAsync(State<T> state, EasimartUser user, Task<Void> cancellationToken) {
        return EasimartQuery.getQueryController().countAsync(state, user, cancellationToken);
    }

    public T get(String objectId) throws EasimartException {
        return (T)((EasimartObject)EasimartTaskUtils.wait(this.getInBackground(objectId)));
    }

    public boolean hasCachedResult() {
        EasimartQuery.throwIfLDSEnabled();
        State<T> state = this.builder.build();
        EasimartUser user = null;
        try {
            user = EasimartTaskUtils.wait(this.getUserAsync(state));
        }
        catch (EasimartException easimartException) {
            // empty catch block
        }
        String sessionToken = user != null ? user.getSessionToken() : null;
        String raw = EasimartKeyValueCache.loadFromKeyValueCache(EasimartRESTQueryCommand.findCommand(state, sessionToken).getCacheKey(), state.maxCacheAge());
        return raw != null;
    }

    public void clearCachedResult() {
        EasimartQuery.throwIfLDSEnabled();
        State<T> state = this.builder.build();
        EasimartUser user = null;
        try {
            user = EasimartTaskUtils.wait(this.getUserAsync(state));
        }
        catch (EasimartException easimartException) {
            // empty catch block
        }
        String sessionToken = user != null ? user.getSessionToken() : null;
        EasimartKeyValueCache.clearFromKeyValueCache(EasimartRESTQueryCommand.findCommand(state, sessionToken).getCacheKey());
    }

    public static void clearAllCachedResults() {
        EasimartQuery.throwIfLDSEnabled();
        EasimartKeyValueCache.clearKeyValueCacheDir();
    }

    public Task<T> getInBackground(String objectId) {
        State<T> state = this.builder.setSkip(-1).whereObjectIdEquals(objectId).build();
        return this.getFirstAsync(state);
    }

    public void getInBackground(String objectId, GetCallback<T> callback) {
        State<T> state = this.builder.setSkip(-1).whereObjectIdEquals(objectId).build();
        Object task = state.cachePolicy() != CachePolicy.CACHE_THEN_NETWORK || state.isFromLocalDatastore() ? this.getFirstAsync(state) : this.doCacheThenNetwork(state, callback, new CacheThenNetworkCallable<T, Task<T>>(){

            @Override
            public Task<T> call(State<T> state, EasimartUser user, Task<Void> cancellationToken) {
                return EasimartQuery.this.getFirstAsync(state, user, (Task<Void>)cancellationToken);
            }
        });
        EasimartTaskUtils.callbackOnMainThreadAsync(task, callback);
    }

    private <TResult> Task<TResult> doCacheThenNetwork(final State<T> state, final EasimartCallback2<TResult, EasimartException> callback, final CacheThenNetworkCallable<T, Task<TResult>> delegate) {
        return this.doWithRunningCheck(new Callable<Task<TResult>>(){

            @Override
            public Task<TResult> call() throws Exception {
                return EasimartQuery.this.getUserAsync(state).onSuccessTask(new Continuation<EasimartUser, Task<TResult>>(){

                    public Task<TResult> then(Task<EasimartUser> task) throws Exception {
                        final EasimartUser user = (EasimartUser)task.getResult();
                        State cacheState = new State.Builder(state).setCachePolicy(CachePolicy.CACHE_ONLY).build();
                        final State networkState = new State.Builder(state).setCachePolicy(CachePolicy.NETWORK_ONLY).build();
                        Task executionTask = (Task)delegate.call(cacheState, user, (Task<Void>)EasimartQuery.this.cts.getTask());
                        executionTask = EasimartTaskUtils.callbackOnMainThreadAsync(executionTask, callback);
                        return executionTask.continueWithTask(new Continuation<TResult, Task<TResult>>(){

                            public Task<TResult> then(Task<TResult> task) throws Exception {
                                if (task.isCancelled()) {
                                    return task;
                                }
                                return (Task)delegate.call(networkState, user, (Task<Void>)EasimartQuery.this.cts.getTask());
                            }
                        });
                    }
                });
            }
        });
    }

    public EasimartQuery<T> whereEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.builder.whereEqualTo(key, value);
        return this;
    }

    public EasimartQuery<T> whereLessThan(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$lt", value);
        return this;
    }

    public EasimartQuery<T> whereNotEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$ne", value);
        return this;
    }

    public EasimartQuery<T> whereGreaterThan(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$gt", value);
        return this;
    }

    public EasimartQuery<T> whereLessThanOrEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$lte", value);
        return this;
    }

    public EasimartQuery<T> whereGreaterThanOrEqualTo(String key, Object value) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$gte", value);
        return this;
    }

    public EasimartQuery<T> whereContainedIn(String key, Collection<? extends Object> values) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$in", values);
        return this;
    }

    public EasimartQuery<T> whereContainsAll(String key, Collection<?> values) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$all", values);
        return this;
    }

    public EasimartQuery<T> whereMatchesQuery(String key, EasimartQuery<?> query) {
        this.checkIfRunning();
        this.builder.whereMatchesQuery(key, query.getBuilder());
        return this;
    }

    public EasimartQuery<T> whereDoesNotMatchQuery(String key, EasimartQuery<?> query) {
        this.checkIfRunning();
        this.builder.whereDoesNotMatchQuery(key, query.getBuilder());
        return this;
    }

    public EasimartQuery<T> whereMatchesKeyInQuery(String key, String keyInQuery, EasimartQuery<?> query) {
        this.checkIfRunning();
        this.builder.whereMatchesKeyInQuery(key, keyInQuery, query.getBuilder());
        return this;
    }

    public EasimartQuery<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, EasimartQuery<?> query) {
        this.checkIfRunning();
        this.builder.whereDoesNotMatchKeyInQuery(key, keyInQuery, query.getBuilder());
        return this;
    }

    public EasimartQuery<T> whereNotContainedIn(String key, Collection<? extends Object> values) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$nin", values);
        return this;
    }

    public EasimartQuery<T> whereNear(String key, EasimartGeoPoint point) {
        this.checkIfRunning();
        this.builder.whereNear(key, point);
        return this;
    }

    public EasimartQuery<T> whereWithinMiles(String key, EasimartGeoPoint point, double maxDistance) {
        this.checkIfRunning();
        return this.whereWithinRadians(key, point, maxDistance / EasimartGeoPoint.EARTH_MEAN_RADIUS_MILE);
    }

    public EasimartQuery<T> whereWithinKilometers(String key, EasimartGeoPoint point, double maxDistance) {
        this.checkIfRunning();
        return this.whereWithinRadians(key, point, maxDistance / EasimartGeoPoint.EARTH_MEAN_RADIUS_KM);
    }

    public EasimartQuery<T> whereWithinRadians(String key, EasimartGeoPoint point, double maxDistance) {
        this.checkIfRunning();
        this.builder.whereNear(key, point).maxDistance(key, maxDistance);
        return this;
    }

    public EasimartQuery<T> whereWithinGeoBox(String key, EasimartGeoPoint southwest, EasimartGeoPoint northeast) {
        this.checkIfRunning();
        this.builder.whereWithin(key, southwest, northeast);
        return this;
    }

    public EasimartQuery<T> whereMatches(String key, String regex) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$regex", regex);
        return this;
    }

    public EasimartQuery<T> whereMatches(String key, String regex, String modifiers) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$regex", regex);
        if (modifiers.length() != 0) {
            this.builder.addCondition(key, "$options", modifiers);
        }
        return this;
    }

    public EasimartQuery<T> whereContains(String key, String substring) {
        String regex = Pattern.quote(substring);
        this.whereMatches(key, regex);
        return this;
    }

    public EasimartQuery<T> whereStartsWith(String key, String prefix) {
        String regex = "^" + Pattern.quote(prefix);
        this.whereMatches(key, regex);
        return this;
    }

    public EasimartQuery<T> whereEndsWith(String key, String suffix) {
        String regex = Pattern.quote(suffix) + "$";
        this.whereMatches(key, regex);
        return this;
    }

    public EasimartQuery<T> include(String key) {
        this.checkIfRunning();
        this.builder.include(key);
        return this;
    }

    public EasimartQuery<T> selectKeys(Collection<String> keys) {
        this.checkIfRunning();
        this.builder.selectKeys(keys);
        return this;
    }

    public EasimartQuery<T> whereExists(String key) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$exists", true);
        return this;
    }

    public EasimartQuery<T> whereDoesNotExist(String key) {
        this.checkIfRunning();
        this.builder.addCondition(key, "$exists", false);
        return this;
    }

    public EasimartQuery<T> orderByAscending(String key) {
        this.checkIfRunning();
        this.builder.orderByAscending(key);
        return this;
    }

    public EasimartQuery<T> addAscendingOrder(String key) {
        this.checkIfRunning();
        this.builder.addAscendingOrder(key);
        return this;
    }

    public EasimartQuery<T> orderByDescending(String key) {
        this.checkIfRunning();
        this.builder.orderByDescending(key);
        return this;
    }

    public EasimartQuery<T> addDescendingOrder(String key) {
        this.checkIfRunning();
        this.builder.addDescendingOrder(key);
        return this;
    }

    public EasimartQuery<T> setLimit(int newLimit) {
        this.checkIfRunning();
        this.builder.setLimit(newLimit);
        return this;
    }

    public int getLimit() {
        return this.builder.getLimit();
    }

    public EasimartQuery<T> setSkip(int newSkip) {
        this.checkIfRunning();
        this.builder.setSkip(newSkip);
        return this;
    }

    public int getSkip() {
        return this.builder.getSkip();
    }

    public String getClassName() {
        return this.builder.getClassName();
    }

    public EasimartQuery<T> setTrace(boolean shouldTrace) {
        this.checkIfRunning();
        this.builder.setTracingEnabled(shouldTrace);
        return this;
    }

    private static interface CacheThenNetworkCallable<T extends EasimartObject, TResult> {
        public TResult call(State<T> var1, EasimartUser var2, Task<Void> var3);
    }

    static class State<T extends EasimartObject> {
        private final String className;
        private final QueryConstraints where;
        private final Set<String> include;
        private final Set<String> selectedKeys;
        private final int limit;
        private final int skip;
        private final List<String> order;
        private final Map<String, Object> extraOptions;
        private final boolean trace;
        private final CachePolicy cachePolicy;
        private final long maxCacheAge;
        private final boolean isFromLocalDatastore;
        private final String pinName;
        private final boolean ignoreACLs;

        private State(Builder<T> builder) {
            this.className = ((Builder)builder).className;
            this.where = new QueryConstraints(((Builder)builder).where);
            this.include = Collections.unmodifiableSet(new HashSet(((Builder)builder).includes));
            this.selectedKeys = ((Builder)builder).selectedKeys != null ? Collections.unmodifiableSet(new HashSet(((Builder)builder).selectedKeys)) : null;
            this.limit = ((Builder)builder).limit;
            this.skip = ((Builder)builder).skip;
            this.order = Collections.unmodifiableList(new ArrayList(((Builder)builder).order));
            this.extraOptions = Collections.unmodifiableMap(new HashMap(((Builder)builder).extraOptions));
            this.trace = ((Builder)builder).trace;
            this.cachePolicy = ((Builder)builder).cachePolicy;
            this.maxCacheAge = ((Builder)builder).maxCacheAge;
            this.isFromLocalDatastore = ((Builder)builder).isFromLocalDatastore;
            this.pinName = ((Builder)builder).pinName;
            this.ignoreACLs = ((Builder)builder).ignoreACLs;
        }

        public String className() {
            return this.className;
        }

        public QueryConstraints constraints() {
            return this.where;
        }

        public Set<String> includes() {
            return this.include;
        }

        public Set<String> selectedKeys() {
            return this.selectedKeys;
        }

        public int limit() {
            return this.limit;
        }

        public int skip() {
            return this.skip;
        }

        public List<String> order() {
            return this.order;
        }

        public Map<String, Object> extraOptions() {
            return this.extraOptions;
        }

        public boolean isTracingEnabled() {
            return this.trace;
        }

        public CachePolicy cachePolicy() {
            return this.cachePolicy;
        }

        public long maxCacheAge() {
            return this.maxCacheAge;
        }

        public boolean isFromLocalDatastore() {
            return this.isFromLocalDatastore;
        }

        public String pinName() {
            return this.pinName;
        }

        public boolean ignoreACLs() {
            return this.ignoreACLs;
        }

        JSONObject toJSON(EasimartEncoder encoder) {
            JSONObject params = new JSONObject();
            try {
                params.put("className", (Object)this.className);
                params.put("where", encoder.encode(this.where));
                if (this.limit >= 0) {
                    params.put("limit", this.limit);
                }
                if (this.skip > 0) {
                    params.put("skip", this.skip);
                }
                if (!this.order.isEmpty()) {
                    params.put("order", (Object)EasimartTextUtils.join(",", this.order));
                }
                if (!this.include.isEmpty()) {
                    params.put("include", (Object)EasimartTextUtils.join(",", this.include));
                }
                if (this.selectedKeys != null) {
                    params.put("fields", (Object)EasimartTextUtils.join(",", this.selectedKeys));
                }
                if (this.trace) {
                    params.put("trace", 1);
                }
                for (String key : this.extraOptions.keySet()) {
                    params.put(key, encoder.encode(this.extraOptions.get(key)));
                }
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return params;
        }

        public String toString() {
            return String.format(Locale.US, "%s[className=%s, where=%s, include=%s, selectedKeys=%s, limit=%s, skip=%s, order=%s, extraOptions=%s, cachePolicy=%s, maxCacheAge=%s, trace=%s]", new Object[]{this.getClass().getName(), this.className, this.where, this.include, this.selectedKeys, this.limit, this.skip, this.order, this.extraOptions, this.cachePolicy, this.maxCacheAge, this.trace});
        }

        static class Builder<T extends EasimartObject> {
            private final String className;
            private final QueryConstraints where = new QueryConstraints();
            private final Set<String> includes = new HashSet<String>();
            private Set<String> selectedKeys;
            private int limit = -1;
            private int skip = 0;
            private List<String> order = new ArrayList<String>();
            private final Map<String, Object> extraOptions = new HashMap<String, Object>();
            private boolean trace;
            private CachePolicy cachePolicy = CachePolicy.IGNORE_CACHE;
            private long maxCacheAge = Long.MAX_VALUE;
            private boolean isFromLocalDatastore = false;
            private String pinName;
            private boolean ignoreACLs;

            public static <T extends EasimartObject> Builder<T> or(List<Builder<T>> builders) {
                if (builders.isEmpty()) {
                    throw new IllegalArgumentException("Can't take an or of an empty list of queries");
                }
                String className = null;
                ArrayList<QueryConstraints> constraints = new ArrayList<QueryConstraints>();
                for (Builder<T> builder : builders) {
                    if (className != null && !builder.className.equals(className)) {
                        throw new IllegalArgumentException("All of the queries in an or query must be on the same class ");
                    }
                    if (builder.limit >= 0) {
                        throw new IllegalArgumentException("Cannot have limits in sub queries of an 'OR' query");
                    }
                    if (builder.skip > 0) {
                        throw new IllegalArgumentException("Cannot have skips in sub queries of an 'OR' query");
                    }
                    if (!builder.order.isEmpty()) {
                        throw new IllegalArgumentException("Cannot have an order in sub queries of an 'OR' query");
                    }
                    if (!builder.includes.isEmpty()) {
                        throw new IllegalArgumentException("Cannot have an include in sub queries of an 'OR' query");
                    }
                    if (builder.selectedKeys != null) {
                        throw new IllegalArgumentException("Cannot have an selectKeys in sub queries of an 'OR' query");
                    }
                    className = builder.className;
                    constraints.add(builder.where);
                }
                return super.whereSatifiesAnyOf(constraints);
            }

            public Builder(String className) {
                this.className = className;
            }

            public Builder(Class<T> subclass) {
                this(EasimartObject.getClassName(subclass));
            }

            public Builder(State state) {
                this.className = state.className();
                this.where.putAll(state.constraints());
                this.includes.addAll(state.includes());
                this.selectedKeys = state.selectedKeys() != null ? new HashSet<String>(state.selectedKeys()) : null;
                this.limit = state.limit();
                this.skip = state.skip();
                this.order.addAll(state.order());
                this.extraOptions.putAll(state.extraOptions());
                this.trace = state.isTracingEnabled();
                this.cachePolicy = state.cachePolicy();
                this.maxCacheAge = state.maxCacheAge();
                this.isFromLocalDatastore = state.isFromLocalDatastore();
                this.pinName = state.pinName();
                this.ignoreACLs = state.ignoreACLs();
            }

            public Builder(Builder<T> builder) {
                this.className = builder.className;
                this.where.putAll(builder.where);
                this.includes.addAll(builder.includes);
                this.selectedKeys = builder.selectedKeys != null ? new HashSet<String>(builder.selectedKeys) : null;
                this.limit = builder.limit;
                this.skip = builder.skip;
                this.order.addAll(builder.order);
                this.extraOptions.putAll(builder.extraOptions);
                this.trace = builder.trace;
                this.cachePolicy = builder.cachePolicy;
                this.maxCacheAge = builder.maxCacheAge;
                this.isFromLocalDatastore = builder.isFromLocalDatastore;
                this.pinName = builder.pinName;
                this.ignoreACLs = builder.ignoreACLs;
            }

            public String getClassName() {
                return this.className;
            }

            public Builder<T> whereEqualTo(String key, Object value) {
                this.where.put(key, value);
                return this;
            }

            public Builder<T> whereDoesNotMatchKeyInQuery(String key, String keyInQuery, Builder<?> builder) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("key", keyInQuery);
                condition.put("query", builder);
                return this.addConditionInternal(key, "$dontSelect", Collections.unmodifiableMap(condition));
            }

            public Builder<T> whereMatchesKeyInQuery(String key, String keyInQuery, Builder<?> builder) {
                HashMap<String, Object> condition = new HashMap<String, Object>();
                condition.put("key", keyInQuery);
                condition.put("query", builder);
                return this.addConditionInternal(key, "$select", Collections.unmodifiableMap(new HashMap(condition)));
            }

            public Builder<T> whereDoesNotMatchQuery(String key, Builder<?> builder) {
                return this.addConditionInternal(key, "$notInQuery", builder);
            }

            public Builder<T> whereMatchesQuery(String key, Builder<?> builder) {
                return this.addConditionInternal(key, "$inQuery", builder);
            }

            public Builder<T> whereNear(String key, EasimartGeoPoint point) {
                return this.addCondition(key, "$nearSphere", point);
            }

            public Builder<T> maxDistance(String key, double maxDistance) {
                return this.addCondition(key, "$maxDistance", maxDistance);
            }

            public Builder<T> whereWithin(String key, EasimartGeoPoint southwest, EasimartGeoPoint northeast) {
                ArrayList<EasimartGeoPoint> array = new ArrayList<EasimartGeoPoint>();
                array.add(southwest);
                array.add(northeast);
                HashMap<String, ArrayList<EasimartGeoPoint>> dictionary = new HashMap<String, ArrayList<EasimartGeoPoint>>();
                dictionary.put("$box", array);
                return this.addCondition(key, "$within", dictionary);
            }

            public Builder<T> addCondition(String key, String condition, Collection<? extends Object> value) {
                return this.addConditionInternal(key, condition, Collections.unmodifiableCollection(value));
            }

            public Builder<T> addCondition(String key, String condition, Object value) {
                return this.addConditionInternal(key, condition, value);
            }

            private Builder<T> addConditionInternal(String key, String condition, Object value) {
                Object existingValue;
                KeyConstraints whereValue = null;
                if (this.where.containsKey(key) && (existingValue = this.where.get(key)) instanceof KeyConstraints) {
                    whereValue = (KeyConstraints)existingValue;
                }
                if (whereValue == null) {
                    whereValue = new KeyConstraints();
                }
                whereValue.put(condition, value);
                this.where.put(key, whereValue);
                return this;
            }

            Builder<T> whereRelatedTo(EasimartObject parent, String key) {
                this.where.put("$relatedTo", new RelationConstraint(key, parent));
                return this;
            }

            private Builder<T> whereSatifiesAnyOf(List<QueryConstraints> constraints) {
                this.where.put("$or", constraints);
                return this;
            }

            Builder<T> whereObjectIdEquals(String objectId) {
                this.where.clear();
                this.where.put("objectId", objectId);
                return this;
            }

            private Builder<T> setOrder(String key) {
                this.order.clear();
                this.order.add(key);
                return this;
            }

            private Builder<T> addOrder(String key) {
                this.order.add(key);
                return this;
            }

            public Builder<T> orderByAscending(String key) {
                return this.setOrder(key);
            }

            public Builder<T> addAscendingOrder(String key) {
                return this.addOrder(key);
            }

            public Builder<T> orderByDescending(String key) {
                return this.setOrder(String.format("-%s", key));
            }

            public Builder<T> addDescendingOrder(String key) {
                return this.addOrder(String.format("-%s", key));
            }

            public Builder<T> include(String key) {
                this.includes.add(key);
                return this;
            }

            public Builder<T> selectKeys(Collection<String> keys) {
                if (this.selectedKeys == null) {
                    this.selectedKeys = new HashSet<String>();
                }
                this.selectedKeys.addAll(keys);
                return this;
            }

            public int getLimit() {
                return this.limit;
            }

            public Builder<T> setLimit(int limit) {
                this.limit = limit;
                return this;
            }

            public int getSkip() {
                return this.skip;
            }

            public Builder<T> setSkip(int skip) {
                this.skip = skip;
                return this;
            }

            Builder<T> redirectClassNameForKey(String key) {
                this.extraOptions.put("redirectClassNameForKey", key);
                return this;
            }

            public Builder<T> setTracingEnabled(boolean trace) {
                this.trace = trace;
                return this;
            }

            public CachePolicy getCachePolicy() {
                EasimartQuery.throwIfLDSEnabled();
                return this.cachePolicy;
            }

            public Builder<T> setCachePolicy(CachePolicy cachePolicy) {
                EasimartQuery.throwIfLDSEnabled();
                this.cachePolicy = cachePolicy;
                return this;
            }

            public long getMaxCacheAge() {
                EasimartQuery.throwIfLDSEnabled();
                return this.maxCacheAge;
            }

            public Builder<T> setMaxCacheAge(long maxCacheAge) {
                EasimartQuery.throwIfLDSEnabled();
                this.maxCacheAge = maxCacheAge;
                return this;
            }

            public boolean isFromNetwork() {
                EasimartQuery.throwIfLDSDisabled();
                return !this.isFromLocalDatastore;
            }

            public Builder<T> fromNetwork() {
                EasimartQuery.throwIfLDSDisabled();
                this.isFromLocalDatastore = false;
                this.pinName = null;
                return this;
            }

            public Builder<T> fromLocalDatastore() {
                return this.fromPin(null);
            }

            public boolean isFromLocalDatstore() {
                return this.isFromLocalDatastore;
            }

            public Builder<T> fromPin() {
                return this.fromPin("_default");
            }

            public Builder<T> fromPin(String pinName) {
                EasimartQuery.throwIfLDSDisabled();
                this.isFromLocalDatastore = true;
                this.pinName = pinName;
                return this;
            }

            public Builder<T> ignoreACLs() {
                EasimartQuery.throwIfLDSDisabled();
                this.ignoreACLs = true;
                return this;
            }

            public State<T> build() {
                if (!this.isFromLocalDatastore && this.ignoreACLs) {
                    throw new IllegalStateException("`ignoreACLs` cannot be combined with network queries");
                }
                return new State(this);
            }
        }
    }

    public static enum CachePolicy {
        IGNORE_CACHE,
        CACHE_ONLY,
        NETWORK_ONLY,
        CACHE_ELSE_NETWORK,
        NETWORK_ELSE_CACHE,
        CACHE_THEN_NETWORK;

    }

    static class RelationConstraint {
        private String key;
        private EasimartObject object;

        public RelationConstraint(String key, EasimartObject object) {
            if (key == null || object == null) {
                throw new IllegalArgumentException("Arguments must not be null.");
            }
            this.key = key;
            this.object = object;
        }

        public String getKey() {
            return this.key;
        }

        public EasimartObject getObject() {
            return this.object;
        }

        public EasimartRelation<EasimartObject> getRelation() {
            return this.object.getRelation(this.key);
        }

        public JSONObject encode(EasimartEncoder objectEncoder) {
            JSONObject json = new JSONObject();
            try {
                json.put("key", (Object)this.key);
                json.put("object", (Object)objectEncoder.encodeRelatedObject(this.object));
            }
            catch (JSONException e) {
                throw new RuntimeException(e);
            }
            return json;
        }
    }

    static class KeyConstraints
    extends HashMap<String, Object> {
        KeyConstraints() {
        }
    }

    static class QueryConstraints
    extends HashMap<String, Object> {
        public QueryConstraints() {
        }

        public QueryConstraints(Map<? extends String, ?> map) {
            super(map);
        }
    }
}

