/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartException;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartIOUtils;
import co.easimart.EasimartRESTCommand;
import co.easimart.EasimartRESTObjectCommand;
import co.easimart.Lists;
import co.easimart.ProgressCallback;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartRESTObjectBatchCommand
extends EasimartRESTCommand {
    public static final int COMMAND_OBJECT_BATCH_MAX_SIZE = 50;
    private static final String KEY_RESULTS = "results";

    public static List<Task<JSONObject>> executeBatch(EasimartHttpClient client, List<EasimartRESTObjectCommand> commands, String sessionToken) {
        final int batchSize = commands.size();
        ArrayList<Task<JSONObject>> tasks = new ArrayList<Task<JSONObject>>(batchSize);
        if (batchSize == 1) {
            tasks.add(commands.get(0).executeAsync(client));
            return tasks;
        }
        if (batchSize > 50) {
            List<List<EasimartRESTObjectCommand>> batches = Lists.partition(commands, 50);
            int size = batches.size();
            for (int i = 0; i < size; ++i) {
                List<EasimartRESTObjectCommand> list = batches.get(i);
                tasks.addAll(EasimartRESTObjectBatchCommand.executeBatch(client, list, sessionToken));
            }
            return tasks;
        }
        final ArrayList<Task.TaskCompletionSource> tcss = new ArrayList<Task.TaskCompletionSource>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            Task.TaskCompletionSource tcs = Task.create();
            tcss.add(tcs);
            tasks.add((Task<JSONObject>)tcs.getTask());
        }
        ArrayList<JSONObject> requests = new ArrayList<JSONObject>(batchSize);
        try {
            for (EasimartRESTObjectCommand easimartRESTObjectCommand : commands) {
                JSONObject requestParameters = new JSONObject();
                requestParameters.put("method", (Object)easimartRESTObjectCommand.method.toString());
                requestParameters.put("path", (Object)String.format("/1/%s", easimartRESTObjectCommand.httpPath));
                JSONObject body = easimartRESTObjectCommand.jsonParameters;
                if (body != null) {
                    requestParameters.put("body", (Object)body);
                }
                requests.add(requestParameters);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        HashMap<String, ArrayList<JSONObject>> parameters = new HashMap<String, ArrayList<JSONObject>>();
        parameters.put("requests", requests);
        EasimartRESTObjectBatchCommand easimartRESTObjectBatchCommand = new EasimartRESTObjectBatchCommand("batch", EasimartHttpRequest.Method.POST, parameters, sessionToken);
        easimartRESTObjectBatchCommand.executeAsync(client).continueWith((Continuation)new Continuation<JSONObject, Void>(){

            public Void then(Task<JSONObject> task) throws Exception {
                int i;
                JSONObject json;
                JSONArray results;
                int resultLength;
                Task.TaskCompletionSource tcs;
                if (task.isFaulted() || task.isCancelled()) {
                    for (int i2 = 0; i2 < batchSize; ++i2) {
                        tcs = (Task.TaskCompletionSource)tcss.get(i2);
                        if (task.isFaulted()) {
                            tcs.setError(task.getError());
                            continue;
                        }
                        tcs.setCancelled();
                    }
                }
                if ((resultLength = (results = (json = (JSONObject)task.getResult()).getJSONArray(EasimartRESTObjectBatchCommand.KEY_RESULTS)).length()) != batchSize) {
                    for (i = 0; i < batchSize; ++i) {
                        tcs = (Task.TaskCompletionSource)tcss.get(i);
                        tcs.setError((Exception)new IllegalStateException("Batch command result count expected: " + batchSize + " but was: " + resultLength));
                    }
                }
                for (i = 0; i < batchSize; ++i) {
                    JSONObject result = results.getJSONObject(i);
                    tcs = (Task.TaskCompletionSource)tcss.get(i);
                    if (result.has("success")) {
                        JSONObject success = result.getJSONObject("success");
                        tcs.setResult((Object)success);
                        continue;
                    }
                    if (!result.has("error")) continue;
                    JSONObject error = result.getJSONObject("error");
                    tcs.setError((Exception)new EasimartException(error.getInt("code"), error.getString("error")));
                }
                return null;
            }
        });
        return tasks;
    }

    private EasimartRESTObjectBatchCommand(String httpPath, EasimartHttpRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Task<JSONObject> onResponseAsync(EasimartHttpResponse response, ProgressCallback downloadProgressCallback) {
        JSONObject json;
        InputStream responseStream = null;
        String content = null;
        try {
            responseStream = response.getContent();
            content = new String(EasimartIOUtils.toByteArray(responseStream));
        }
        catch (IOException e) {
            Task task = Task.forError((Exception)e);
            return task;
        }
        finally {
            EasimartIOUtils.closeQuietly(responseStream);
        }
        try {
            JSONArray results = new JSONArray(content);
            json = new JSONObject();
            json.put(KEY_RESULTS, (Object)results);
        }
        catch (JSONException e) {
            return Task.forError((Exception)this.newTemporaryException("bad json response", e));
        }
        return Task.forResult((Object)json);
    }
}

