/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartObject;
import co.easimart.EasimartQuery;
import co.easimart.EasimartRESTCommand;
import co.easimart.EasimartTextUtils;
import co.easimart.PointerEncoder;
import co.easimart.http.EasimartHttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

class EasimartRESTQueryCommand
extends EasimartRESTCommand {
    public static <T extends EasimartObject> EasimartRESTQueryCommand findCommand(EasimartQuery.State<T> state, String sessionToken) {
        String httpPath = String.format("classes/%s", state.className());
        Map<String, String> parameters = EasimartRESTQueryCommand.encode(state, false);
        return new EasimartRESTQueryCommand(httpPath, EasimartHttpRequest.Method.GET, parameters, sessionToken);
    }

    public static <T extends EasimartObject> EasimartRESTQueryCommand countCommand(EasimartQuery.State<T> state, String sessionToken) {
        String httpPath = String.format("classes/%s", state.className());
        Map<String, String> parameters = EasimartRESTQueryCommand.encode(state, true);
        return new EasimartRESTQueryCommand(httpPath, EasimartHttpRequest.Method.GET, parameters, sessionToken);
    }

    static <T extends EasimartObject> Map<String, String> encode(EasimartQuery.State<T> state, boolean count) {
        Set<String> includeds;
        Set<String> selectedKeys;
        EasimartQuery.QueryConstraints conditions;
        PointerEncoder encoder = PointerEncoder.get();
        HashMap<String, String> parameters = new HashMap<String, String>();
        List<String> order = state.order();
        if (!order.isEmpty()) {
            parameters.put("order", EasimartTextUtils.join(",", order));
        }
        if (!(conditions = state.constraints()).isEmpty()) {
            JSONObject encodedConditions = (JSONObject)encoder.encode(conditions);
            parameters.put("where", encodedConditions.toString());
        }
        if ((selectedKeys = state.selectedKeys()) != null) {
            parameters.put("keys", EasimartTextUtils.join(",", selectedKeys));
        }
        if (!(includeds = state.includes()).isEmpty()) {
            parameters.put("include", EasimartTextUtils.join(",", includeds));
        }
        if (count) {
            parameters.put("count", Integer.toString(1));
        } else {
            int skip;
            int limit = state.limit();
            if (limit >= 0) {
                parameters.put("limit", Integer.toString(limit));
            }
            if ((skip = state.skip()) > 0) {
                parameters.put("skip", Integer.toString(skip));
            }
        }
        Map<String, Object> extraOptions = state.extraOptions();
        for (Map.Entry<String, Object> entry : extraOptions.entrySet()) {
            Object encodedExtraOptions = encoder.encode(entry.getValue());
            parameters.put(entry.getKey(), encodedExtraOptions.toString());
        }
        if (state.isTracingEnabled()) {
            parameters.put("trace", Integer.toString(1));
        }
        return parameters;
    }

    private EasimartRESTQueryCommand(String httpPath, EasimartHttpRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        super(httpPath, httpMethod, parameters, sessionToken);
    }
}

