/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Task;
import co.easimart.EasimartRESTCommand;
import co.easimart.PointerEncoder;
import co.easimart.ProgressCallback;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartRESTUserCommand
extends EasimartRESTCommand {
    private static final String HEADER_REVOCABLE_SESSION = "X-Easimart-Revocable-Session";
    private static final String HEADER_TRUE = "1";
    private boolean isRevocableSessionEnabled;
    private int statusCode;

    public static EasimartRESTUserCommand getCurrentUserCommand(String sessionToken) {
        return new EasimartRESTUserCommand("users/me", EasimartHttpRequest.Method.GET, null, sessionToken);
    }

    public static EasimartRESTUserCommand signUpUserCommand(JSONObject parameters, String sessionToken, boolean revocableSession) {
        return new EasimartRESTUserCommand("classes/_User", EasimartHttpRequest.Method.POST, parameters, sessionToken, revocableSession);
    }

    public static EasimartRESTUserCommand logInUserCommand(String username, String password, boolean revocableSession) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("username", username);
        parameters.put("password", password);
        return new EasimartRESTUserCommand("login", EasimartHttpRequest.Method.GET, parameters, null, revocableSession);
    }

    public static EasimartRESTUserCommand serviceLogInUserCommand(String authType, Map<String, String> authData, boolean revocableSession) {
        JSONObject parameters;
        try {
            JSONObject authenticationData = new JSONObject();
            authenticationData.put(authType, PointerEncoder.get().encode(authData));
            parameters = new JSONObject();
            parameters.put("authData", (Object)authenticationData);
        }
        catch (JSONException e) {
            throw new RuntimeException("could not serialize object to JSON");
        }
        return EasimartRESTUserCommand.serviceLogInUserCommand(parameters, null, revocableSession);
    }

    public static EasimartRESTUserCommand serviceLogInUserCommand(JSONObject parameters, String sessionToken, boolean revocableSession) {
        return new EasimartRESTUserCommand("users", EasimartHttpRequest.Method.POST, parameters, sessionToken, revocableSession);
    }

    public static EasimartRESTUserCommand resetPasswordResetCommand(String email) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("email", email);
        return new EasimartRESTUserCommand("requestPasswordReset", EasimartHttpRequest.Method.POST, parameters, null);
    }

    private EasimartRESTUserCommand(String httpPath, EasimartHttpRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken) {
        this(httpPath, httpMethod, parameters, sessionToken, false);
    }

    private EasimartRESTUserCommand(String httpPath, EasimartHttpRequest.Method httpMethod, Map<String, ?> parameters, String sessionToken, boolean isRevocableSessionEnabled) {
        super(httpPath, httpMethod, parameters, sessionToken);
        this.isRevocableSessionEnabled = isRevocableSessionEnabled;
    }

    private EasimartRESTUserCommand(String httpPath, EasimartHttpRequest.Method httpMethod, JSONObject parameters, String sessionToken, boolean isRevocableSessionEnabled) {
        super(httpPath, httpMethod, parameters, sessionToken);
        this.isRevocableSessionEnabled = isRevocableSessionEnabled;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    protected void addAdditionalHeaders(EasimartHttpRequest.Builder requestBuilder) {
        super.addAdditionalHeaders(requestBuilder);
        if (this.isRevocableSessionEnabled) {
            requestBuilder.addHeader(HEADER_REVOCABLE_SESSION, HEADER_TRUE);
        }
    }

    @Override
    protected Task<JSONObject> onResponseAsync(EasimartHttpResponse response, ProgressCallback progressCallback) {
        this.statusCode = response.getStatusCode();
        return super.onResponseAsync(response, progressCallback);
    }
}

