/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.Easimart;
import co.easimart.EasimartDeleteOperation;
import co.easimart.EasimartEncoder;
import co.easimart.EasimartFieldOperation;
import co.easimart.EasimartObject;
import co.easimart.EasimartRelation;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class EasimartRelationOperation<T extends EasimartObject>
implements EasimartFieldOperation {
    private final String targetClass;
    private final Set<EasimartObject> relationsToAdd;
    private final Set<EasimartObject> relationsToRemove;

    EasimartRelationOperation(Set<T> newRelationsToAdd, Set<T> newRelationsToRemove) {
        String targetClass = null;
        this.relationsToAdd = new HashSet<EasimartObject>();
        this.relationsToRemove = new HashSet<EasimartObject>();
        if (newRelationsToAdd != null) {
            for (EasimartObject object : newRelationsToAdd) {
                this.addEasimartObjectToSet(object, this.relationsToAdd);
                if (targetClass == null) {
                    targetClass = object.getClassName();
                    continue;
                }
                if (targetClass.equals(object.getClassName())) continue;
                throw new IllegalArgumentException("All objects in a relation must be of the same class.");
            }
        }
        if (newRelationsToRemove != null) {
            for (EasimartObject object : newRelationsToRemove) {
                this.addEasimartObjectToSet(object, this.relationsToRemove);
                if (targetClass == null) {
                    targetClass = object.getClassName();
                    continue;
                }
                if (targetClass.equals(object.getClassName())) continue;
                throw new IllegalArgumentException("All objects in a relation must be of the same class.");
            }
        }
        if (targetClass == null) {
            throw new IllegalArgumentException("Cannot create a EasimartRelationOperation with no objects.");
        }
        this.targetClass = targetClass;
    }

    private EasimartRelationOperation(String newTargetClass, Set<EasimartObject> newRelationsToAdd, Set<EasimartObject> newRelationsToRemove) {
        this.targetClass = newTargetClass;
        this.relationsToAdd = new HashSet<EasimartObject>(newRelationsToAdd);
        this.relationsToRemove = new HashSet<EasimartObject>(newRelationsToRemove);
    }

    private void addEasimartObjectToSet(EasimartObject obj, Set<EasimartObject> set) {
        if (Easimart.getLocalDatastore() != null || obj.getObjectId() == null) {
            set.add(obj);
            return;
        }
        for (EasimartObject existingObject : set) {
            if (!obj.getObjectId().equals(existingObject.getObjectId())) continue;
            set.remove(existingObject);
        }
        set.add(obj);
    }

    private void addAllEasimartObjectsToSet(Collection<EasimartObject> list, Set<EasimartObject> set) {
        for (EasimartObject obj : list) {
            this.addEasimartObjectToSet(obj, set);
        }
    }

    private void removeEasimartObjectFromSet(EasimartObject obj, Set<EasimartObject> set) {
        if (Easimart.getLocalDatastore() != null || obj.getObjectId() == null) {
            set.remove(obj);
            return;
        }
        for (EasimartObject existingObject : set) {
            if (!obj.getObjectId().equals(existingObject.getObjectId())) continue;
            set.remove(existingObject);
        }
    }

    private void removeAllEasimartObjectsFromSet(Collection<EasimartObject> list, Set<EasimartObject> set) {
        for (EasimartObject obj : list) {
            this.removeEasimartObjectFromSet(obj, set);
        }
    }

    String getTargetClass() {
        return this.targetClass;
    }

    JSONArray convertSetToArray(Set<EasimartObject> set, EasimartEncoder objectEncoder) throws JSONException {
        JSONArray array = new JSONArray();
        for (EasimartObject obj : set) {
            array.put(objectEncoder.encode(obj));
        }
        return array;
    }

    public JSONObject encode(EasimartEncoder objectEncoder) throws JSONException {
        JSONObject adds = null;
        JSONObject removes = null;
        if (this.relationsToAdd.size() > 0) {
            adds = new JSONObject();
            adds.put("__op", (Object)"AddRelation");
            adds.put("objects", (Object)this.convertSetToArray(this.relationsToAdd, objectEncoder));
        }
        if (this.relationsToRemove.size() > 0) {
            removes = new JSONObject();
            removes.put("__op", (Object)"RemoveRelation");
            removes.put("objects", (Object)this.convertSetToArray(this.relationsToRemove, objectEncoder));
        }
        if (adds != null && removes != null) {
            JSONObject result = new JSONObject();
            result.put("__op", (Object)"Batch");
            JSONArray ops = new JSONArray();
            ops.put((Object)adds);
            ops.put((Object)removes);
            result.put("ops", (Object)ops);
            return result;
        }
        if (adds != null) {
            return adds;
        }
        if (removes != null) {
            return removes;
        }
        throw new IllegalArgumentException("A EasimartRelationOperation was created without any data.");
    }

    @Override
    public EasimartFieldOperation mergeWithPrevious(EasimartFieldOperation previous) {
        if (previous == null) {
            return this;
        }
        if (previous instanceof EasimartDeleteOperation) {
            throw new IllegalArgumentException("You can't modify a relation after deleting it.");
        }
        if (previous instanceof EasimartRelationOperation) {
            EasimartRelationOperation previousOperation = (EasimartRelationOperation)previous;
            if (previousOperation.targetClass != null && !previousOperation.targetClass.equals(this.targetClass)) {
                throw new IllegalArgumentException("Related object object must be of class " + previousOperation.targetClass + ", but " + this.targetClass + " was passed in.");
            }
            HashSet<EasimartObject> newRelationsToAdd = new HashSet<EasimartObject>(previousOperation.relationsToAdd);
            HashSet<EasimartObject> newRelationsToRemove = new HashSet<EasimartObject>(previousOperation.relationsToRemove);
            if (this.relationsToAdd != null) {
                this.addAllEasimartObjectsToSet(this.relationsToAdd, newRelationsToAdd);
                this.removeAllEasimartObjectsFromSet(this.relationsToAdd, newRelationsToRemove);
            }
            if (this.relationsToRemove != null) {
                this.removeAllEasimartObjectsFromSet(this.relationsToRemove, newRelationsToAdd);
                this.addAllEasimartObjectsToSet(this.relationsToRemove, newRelationsToRemove);
            }
            return new EasimartRelationOperation<T>(this.targetClass, newRelationsToAdd, newRelationsToRemove);
        }
        throw new IllegalArgumentException("Operation is invalid after previous operation.");
    }

    @Override
    public Object apply(Object oldValue, String key) {
        EasimartRelation relation;
        if (oldValue == null) {
            relation = new EasimartRelation(this.targetClass);
        } else if (oldValue instanceof EasimartRelation) {
            relation = (EasimartRelation)oldValue;
            if (this.targetClass != null && !this.targetClass.equals(relation.getTargetClass())) {
                throw new IllegalArgumentException("Related object object must be of class " + relation.getTargetClass() + ", but " + this.targetClass + " was passed in.");
            }
        } else {
            throw new IllegalArgumentException("Operation is invalid after previous operation.");
        }
        for (EasimartObject relationToAdd : this.relationsToAdd) {
            relation.addKnownObject(relationToAdd);
        }
        for (EasimartObject relationToRemove : this.relationsToRemove) {
            relation.removeKnownObject(relationToRemove);
        }
        return relation;
    }
}

