/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import co.easimart.EasimartACL;
import co.easimart.EasimartClassName;
import co.easimart.EasimartObject;
import co.easimart.EasimartQuery;
import co.easimart.EasimartRelation;
import co.easimart.EasimartUser;
import java.util.regex.Pattern;

@EasimartClassName(value="_Role")
public class EasimartRole
extends EasimartObject {
    private static final Pattern NAME_PATTERN = Pattern.compile("^[0-9a-zA-Z_\\- ]+$");

    EasimartRole() {
    }

    public EasimartRole(String name) {
        this();
        this.setName(name);
    }

    public EasimartRole(String name, EasimartACL acl) {
        this(name);
        this.setACL(acl);
    }

    public void setName(String name) {
        this.put("name", name);
    }

    public String getName() {
        return this.getString("name");
    }

    public EasimartRelation<EasimartUser> getUsers() {
        return this.getRelation("users");
    }

    public EasimartRelation<EasimartRole> getRoles() {
        return this.getRelation("roles");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void validateSave() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.getObjectId() == null && this.getName() == null) {
                throw new IllegalStateException("New roles must specify a name.");
            }
            super.validateSave();
        }
    }

    @Override
    public void put(String key, Object value) {
        if ("name".equals(key)) {
            if (this.getObjectId() != null) {
                throw new IllegalArgumentException("A role's name can only be set before it has been saved.");
            }
            if (!(value instanceof String)) {
                throw new IllegalArgumentException("A role's name must be a String.");
            }
            if (!NAME_PATTERN.matcher((String)value).matches()) {
                throw new IllegalArgumentException("A role's name can only contain alphanumeric characters, _, -, and spaces.");
            }
        }
        super.put(key, value);
    }

    public static EasimartQuery<EasimartRole> getQuery() {
        return EasimartQuery.getQuery(EasimartRole.class);
    }
}

