/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.content.ContentValues;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartSQLiteCursor;
import co.easimart.TaskQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

class EasimartSQLiteDatabase {
    private static final ExecutorService dbExecutor = Executors.newSingleThreadExecutor();
    private static final TaskQueue taskQueue = new TaskQueue();
    private SQLiteDatabase db;
    private Task<Void> current = null;
    private final Object currentLock = new Object();
    private final Task.TaskCompletionSource tcs = Task.create();
    private int openFlags;

    static Task<EasimartSQLiteDatabase> openDatabaseAsync(SQLiteOpenHelper helper, int flags) {
        final EasimartSQLiteDatabase db = new EasimartSQLiteDatabase(flags);
        return db.open(helper).continueWithTask((Continuation)new Continuation<Void, Task<EasimartSQLiteDatabase>>(){

            public Task<EasimartSQLiteDatabase> then(Task<Void> task) throws Exception {
                return Task.forResult((Object)db);
            }
        });
    }

    private EasimartSQLiteDatabase(int flags) {
        this.openFlags = flags;
        taskQueue.enqueue(new Continuation<Void, Task<Void>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Task<Void> then(Task<Void> toAwait) throws Exception {
                Object object = EasimartSQLiteDatabase.this.currentLock;
                synchronized (object) {
                    EasimartSQLiteDatabase.this.current = toAwait;
                }
                return EasimartSQLiteDatabase.this.tcs.getTask();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Boolean> isReadOnlyAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.continueWith((Continuation)new Continuation<Void, Boolean>(){

                public Boolean then(Task<Void> task) throws Exception {
                    return EasimartSQLiteDatabase.this.db.isReadOnly();
                }
            });
            this.current = task.makeVoid();
            return task;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Boolean> isOpenAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.continueWith((Continuation)new Continuation<Void, Boolean>(){

                public Boolean then(Task<Void> task) throws Exception {
                    return EasimartSQLiteDatabase.this.db.isOpen();
                }
            });
            this.current = task.makeVoid();
            return task;
        }
    }

    public boolean inTransaction() {
        return this.db.inTransaction();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Task<Void> open(final SQLiteOpenHelper helper) {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWith((Continuation)new Continuation<Void, SQLiteDatabase>(){

                public SQLiteDatabase then(Task<Void> task) throws Exception {
                    return (EasimartSQLiteDatabase.this.openFlags & 1) == 1 ? helper.getReadableDatabase() : helper.getWritableDatabase();
                }
            }, (Executor)dbExecutor).continueWithTask((Continuation)new Continuation<SQLiteDatabase, Task<Void>>(){

                public Task<Void> then(Task<SQLiteDatabase> task) throws Exception {
                    EasimartSQLiteDatabase.this.db = (SQLiteDatabase)task.getResult();
                    return task.makeVoid();
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
            return this.current;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> beginTransactionAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    EasimartSQLiteDatabase.this.db.beginTransaction();
                    return task;
                }
            }, (Executor)dbExecutor);
            return this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> setTransactionSuccessfulAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.onSuccessTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    EasimartSQLiteDatabase.this.db.setTransactionSuccessful();
                    return task;
                }
            }, (Executor)dbExecutor);
            return this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> endTransactionAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWith((Continuation)new Continuation<Void, Void>(){

                public Void then(Task<Void> task) throws Exception {
                    EasimartSQLiteDatabase.this.db.endTransaction();
                    return null;
                }
            }, (Executor)dbExecutor);
            return this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> closeAsync() {
        Object object = this.currentLock;
        synchronized (object) {
            this.current = this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    try {
                        EasimartSQLiteDatabase.this.db.close();
                    }
                    finally {
                        EasimartSQLiteDatabase.this.tcs.setResult(null);
                    }
                    return EasimartSQLiteDatabase.this.tcs.getTask();
                }
            }, (Executor)dbExecutor);
            return this.current.continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

                public Task<Void> then(Task<Void> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Cursor> queryAsync(final String table, final String[] select, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Cursor>(){

                public Cursor then(Task<Void> task) throws Exception {
                    return EasimartSQLiteDatabase.this.db.query(table, select, where, args, null, null, null);
                }
            }, (Executor)dbExecutor).onSuccess((Continuation)new Continuation<Cursor, Cursor>(){

                public Cursor then(Task<Cursor> task) throws Exception {
                    Cursor cursor = EasimartSQLiteCursor.create((Cursor)task.getResult(), dbExecutor);
                    cursor.getCount();
                    return cursor;
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Cursor, Task<Cursor>>(){

                public Task<Cursor> then(Task<Cursor> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> insertWithOnConflict(final String table, final ContentValues values, final int conflictAlgorithm) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Long>(){

                public Long then(Task<Void> task) throws Exception {
                    return EasimartSQLiteDatabase.this.db.insertWithOnConflict(table, null, values, conflictAlgorithm);
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Long, Task<Long>>(){

                public Task<Long> then(Task<Long> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> insertOrThrowAsync(final String table, final ContentValues values) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Long>(){

                public Long then(Task<Void> task) throws Exception {
                    return EasimartSQLiteDatabase.this.db.insertOrThrow(table, null, values);
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Long, Task<Long>>(){

                public Task<Long> then(Task<Long> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Integer> updateAsync(final String table, final ContentValues values, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Integer>(){

                public Integer then(Task<Void> task) throws Exception {
                    return EasimartSQLiteDatabase.this.db.update(table, values, where, args);
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Integer, Task<Integer>>(){

                public Task<Integer> then(Task<Integer> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> deleteAsync(final String table, final String where, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Integer>(){

                public Integer then(Task<Void> task) throws Exception {
                    return EasimartSQLiteDatabase.this.db.delete(table, where, args);
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Integer, Task<Integer>>(){

                public Task<Integer> then(Task<Integer> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR).makeVoid();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Cursor> rawQueryAsync(final String sql, final String[] args) {
        Object object = this.currentLock;
        synchronized (object) {
            Task task = this.current.onSuccess((Continuation)new Continuation<Void, Cursor>(){

                public Cursor then(Task<Void> task) throws Exception {
                    return EasimartSQLiteDatabase.this.db.rawQuery(sql, args);
                }
            }, (Executor)dbExecutor).onSuccess((Continuation)new Continuation<Cursor, Cursor>(){

                public Cursor then(Task<Cursor> task) throws Exception {
                    Cursor cursor = EasimartSQLiteCursor.create((Cursor)task.getResult(), dbExecutor);
                    cursor.getCount();
                    return cursor;
                }
            }, (Executor)dbExecutor);
            this.current = task.makeVoid();
            return task.continueWithTask((Continuation)new Continuation<Cursor, Task<Cursor>>(){

                public Task<Cursor> then(Task<Cursor> task) throws Exception {
                    return task;
                }
            }, (Executor)Task.BACKGROUND_EXECUTOR);
        }
    }
}

