/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartClassName;
import co.easimart.EasimartCorePlugins;
import co.easimart.EasimartObject;
import co.easimart.EasimartQuery;
import co.easimart.EasimartSessionController;
import co.easimart.EasimartTaskUtils;
import co.easimart.EasimartUser;
import co.easimart.GetCallback;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@EasimartClassName(value="_Session")
public class EasimartSession
extends EasimartObject {
    private static final String KEY_SESSION_TOKEN = "sessionToken";
    private static final String KEY_CREATED_WITH = "createdWith";
    private static final String KEY_RESTRICTED = "restricted";
    private static final String KEY_USER = "user";
    private static final String KEY_EXPIRES_AT = "expiresAt";
    private static final String KEY_INSTALLATION_ID = "installationId";
    private static final List<String> READ_ONLY_KEYS = Collections.unmodifiableList(Arrays.asList("sessionToken", "createdWith", "restricted", "user", "expiresAt", "installationId"));

    private static EasimartSessionController getSessionController() {
        return EasimartCorePlugins.getInstance().getSessionController();
    }

    public static Task<EasimartSession> getCurrentSessionInBackground() {
        return EasimartUser.getCurrentSessionTokenAsync().onSuccessTask((Continuation)new Continuation<String, Task<EasimartSession>>(){

            public Task<EasimartSession> then(Task<String> task) throws Exception {
                String sessionToken = (String)task.getResult();
                if (sessionToken == null) {
                    return Task.forResult(null);
                }
                return EasimartSession.getSessionController().getSessionAsync(sessionToken).onSuccess((Continuation)new Continuation<EasimartObject.State, EasimartSession>(){

                    public EasimartSession then(Task<EasimartObject.State> task) throws Exception {
                        EasimartObject.State result = (EasimartObject.State)task.getResult();
                        return (EasimartSession)EasimartObject.from(result);
                    }
                });
            }
        });
    }

    public static void getCurrentSessionInBackground(GetCallback<EasimartSession> callback) {
        EasimartTaskUtils.callbackOnMainThreadAsync(EasimartSession.getCurrentSessionInBackground(), callback);
    }

    static Task<Void> revokeAsync(String sessionToken) {
        if (sessionToken == null || !EasimartSession.isRevocableSessionToken(sessionToken)) {
            return Task.forResult(null);
        }
        return EasimartSession.getSessionController().revokeAsync(sessionToken);
    }

    static Task<String> upgradeToRevocableSessionAsync(String sessionToken) {
        if (sessionToken == null || EasimartSession.isRevocableSessionToken(sessionToken)) {
            return Task.forResult((Object)sessionToken);
        }
        return EasimartSession.getSessionController().upgradeToRevocable(sessionToken).onSuccess((Continuation)new Continuation<EasimartObject.State, String>(){

            public String then(Task<EasimartObject.State> task) throws Exception {
                EasimartObject.State result = (EasimartObject.State)task.getResult();
                return ((EasimartSession)EasimartObject.from(result)).getSessionToken();
            }
        });
    }

    static boolean isRevocableSessionToken(String sessionToken) {
        return sessionToken.contains("r:");
    }

    public static EasimartQuery<EasimartSession> getQuery() {
        return EasimartQuery.getQuery(EasimartSession.class);
    }

    @Override
    boolean needsDefaultACL() {
        return false;
    }

    @Override
    boolean isKeyMutable(String key) {
        return !READ_ONLY_KEYS.contains(key);
    }

    public String getSessionToken() {
        return this.getString(KEY_SESSION_TOKEN);
    }
}

