/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import android.net.SSLCertificateSocketFactory;
import android.net.SSLSessionCache;
import co.easimart.EasimartHttpClient;
import co.easimart.http.EasimartHttpBody;
import co.easimart.http.EasimartHttpRequest;
import co.easimart.http.EasimartHttpResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HttpsURLConnection;

class EasimartURLConnectionHttpClient
extends EasimartHttpClient<HttpURLConnection, HttpURLConnection> {
    private static final String ACCEPT_ENCODING_HEADER = "Accept-encoding";
    private static final String GZIP_ENCODING = "gzip";
    private static final String CONTENT_LENGTH_HEADER = "Content-Length";
    private static final String CONTENT_TYPE_HEADER = "Content-Type";
    private int socketOperationTimeout;

    public EasimartURLConnectionHttpClient(int socketOperationTimeout, SSLSessionCache sslSessionCache) {
        this.socketOperationTimeout = socketOperationTimeout;
        HttpsURLConnection.setDefaultSSLSocketFactory(SSLCertificateSocketFactory.getDefault((int)socketOperationTimeout, (SSLSessionCache)sslSessionCache));
    }

    @Override
    EasimartHttpResponse executeInternal(EasimartHttpRequest parseRequest) throws IOException {
        HttpURLConnection connection = this.getRequest(parseRequest);
        EasimartHttpBody body = parseRequest.getBody();
        if (body != null) {
            OutputStream outputStream = connection.getOutputStream();
            body.writeTo(outputStream);
            outputStream.flush();
            outputStream.close();
        }
        return this.getResponse(connection);
    }

    @Override
    HttpURLConnection getRequest(EasimartHttpRequest httpRequest) throws IOException {
        EasimartHttpBody body;
        URL url = new URL(httpRequest.getUrl());
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod(httpRequest.getMethod().toString());
        connection.setConnectTimeout(this.socketOperationTimeout);
        connection.setReadTimeout(this.socketOperationTimeout);
        connection.setDoInput(true);
        connection.setInstanceFollowRedirects(false);
        for (Map.Entry<String, String> entry : httpRequest.getAllHeaders().entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        if (this.disableHttpLibraryAutoDecompress()) {
            connection.setRequestProperty(ACCEPT_ENCODING_HEADER, GZIP_ENCODING);
        }
        if ((body = httpRequest.getBody()) != null) {
            connection.setRequestProperty(CONTENT_LENGTH_HEADER, String.valueOf(body.getContentLength()));
            connection.setRequestProperty(CONTENT_TYPE_HEADER, body.getContentType());
            connection.setFixedLengthStreamingMode(body.getContentLength());
            connection.setDoOutput(true);
        }
        return connection;
    }

    @Override
    EasimartHttpResponse getResponse(HttpURLConnection connection) throws IOException {
        int statusCode = connection.getResponseCode();
        InputStream content = statusCode < 400 ? connection.getInputStream() : connection.getErrorStream();
        int totalSize = connection.getContentLength();
        String reasonPhrase = connection.getResponseMessage();
        HashMap<String, String> headers = new HashMap<String, String>();
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            if (entry.getKey() == null || entry.getValue().size() <= 0) continue;
            headers.put(entry.getKey(), entry.getValue() == null ? "" : entry.getValue().get(0));
        }
        String contentType = connection.getContentType();
        return new EasimartHttpResponse.Builder().setStatusCode(statusCode).setContent(content).setTotalSize(totalSize).setReasonPhrase(reasonPhrase).setHeaders(headers).setContentType(contentType).build();
    }
}

