/*
 * Decompiled with CFR 0.152.
 */
package co.easimart;

import bolts.Continuation;
import bolts.Task;
import co.easimart.EasimartDecoder;
import co.easimart.EasimartHttpClient;
import co.easimart.EasimartObject;
import co.easimart.EasimartObjectCoder;
import co.easimart.EasimartObjectController;
import co.easimart.EasimartOperationSet;
import co.easimart.EasimartRESTObjectBatchCommand;
import co.easimart.EasimartRESTObjectCommand;
import co.easimart.PointerEncoder;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONObject;

class NetworkObjectController
implements EasimartObjectController {
    private EasimartHttpClient client;
    private EasimartObjectCoder coder;

    public NetworkObjectController(EasimartHttpClient client) {
        this.client = client;
        this.coder = EasimartObjectCoder.get();
    }

    @Override
    public Task<EasimartObject.State> fetchAsync(final EasimartObject.State state, String sessionToken, final EasimartDecoder decoder) {
        EasimartRESTObjectCommand command = EasimartRESTObjectCommand.getObjectCommand(state.objectId(), state.className(), sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartObject.State>(){

            public EasimartObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                Object builder = ((EasimartObject.State.Init)state.newBuilder()).clear();
                return ((EasimartObject.State.Init)((EasimartObject.State.Init)NetworkObjectController.this.coder.decode(builder, result, decoder)).isComplete(true)).build();
            }
        });
    }

    @Override
    public Task<EasimartObject.State> saveAsync(final EasimartObject.State state, EasimartOperationSet operations, String sessionToken, final EasimartDecoder decoder) {
        JSONObject objectJSON = this.coder.encode(state, operations, PointerEncoder.get());
        EasimartRESTObjectCommand command = EasimartRESTObjectCommand.saveObjectCommand(state, objectJSON, sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).onSuccess((Continuation)new Continuation<JSONObject, EasimartObject.State>(){

            public EasimartObject.State then(Task<JSONObject> task) throws Exception {
                JSONObject result = (JSONObject)task.getResult();
                Object builder = ((EasimartObject.State.Init)state.newBuilder()).clear();
                return ((EasimartObject.State.Init)((EasimartObject.State.Init)NetworkObjectController.this.coder.decode(builder, result, decoder)).isComplete(false)).build();
            }
        });
    }

    @Override
    public List<Task<EasimartObject.State>> saveAllAsync(List<EasimartObject.State> states, List<EasimartOperationSet> operationsList, String sessionToken, List<EasimartDecoder> decoders) {
        int batchSize = states.size();
        ArrayList<EasimartRESTObjectCommand> commands = new ArrayList<EasimartRESTObjectCommand>(batchSize);
        PointerEncoder encoder = PointerEncoder.get();
        for (int i = 0; i < batchSize; ++i) {
            EasimartObject.State state = states.get(i);
            EasimartOperationSet operations = operationsList.get(i);
            JSONObject objectJSON = this.coder.encode(state, operations, encoder);
            EasimartRESTObjectCommand command = EasimartRESTObjectCommand.saveObjectCommand(state, objectJSON, sessionToken);
            commands.add(command);
        }
        List<Task<JSONObject>> batchTasks = EasimartRESTObjectBatchCommand.executeBatch(this.client, commands, sessionToken);
        ArrayList<Task<EasimartObject.State>> tasks = new ArrayList<Task<EasimartObject.State>>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            final EasimartObject.State state = states.get(i);
            final EasimartDecoder decoder = decoders.get(i);
            tasks.add((Task<EasimartObject.State>)batchTasks.get(i).onSuccess((Continuation)new Continuation<JSONObject, EasimartObject.State>(){

                public EasimartObject.State then(Task<JSONObject> task) throws Exception {
                    JSONObject result = (JSONObject)task.getResult();
                    Object builder = ((EasimartObject.State.Init)state.newBuilder()).clear();
                    return ((EasimartObject.State.Init)((EasimartObject.State.Init)NetworkObjectController.this.coder.decode(builder, result, decoder)).isComplete(false)).build();
                }
            }));
        }
        return tasks;
    }

    @Override
    public Task<Void> deleteAsync(EasimartObject.State state, String sessionToken) {
        EasimartRESTObjectCommand command = EasimartRESTObjectCommand.deleteObjectCommand(state, sessionToken);
        command.enableRetrying();
        return command.executeAsync(this.client).makeVoid();
    }

    @Override
    public List<Task<Void>> deleteAllAsync(List<EasimartObject.State> states, String sessionToken) {
        int batchSize = states.size();
        ArrayList<EasimartRESTObjectCommand> commands = new ArrayList<EasimartRESTObjectCommand>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            EasimartObject.State state = states.get(i);
            EasimartRESTObjectCommand command = EasimartRESTObjectCommand.deleteObjectCommand(state, sessionToken);
            command.enableRetrying();
            commands.add(command);
        }
        List<Task<JSONObject>> batchTasks = EasimartRESTObjectBatchCommand.executeBatch(this.client, commands, sessionToken);
        ArrayList<Task<Void>> tasks = new ArrayList<Task<Void>>(batchSize);
        for (int i = 0; i < batchSize; ++i) {
            tasks.add((Task<Void>)batchTasks.get(i).makeVoid());
        }
        return tasks;
    }
}

